/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMultiRuleUtil;
import org.eclipse.emf.henshin.provider.NamedElementItemProvider;
import org.eclipse.emf.henshin.provider.descriptors.NodeTypePropertyDescriptor;
import org.eclipse.emf.henshin.provider.util.IconUtil;
import org.eclipse.emf.henshin.provider.util.ItemPropertyDescriptorDecorator;

public class NodeItemProvider
extends NamedElementItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider {
    public NodeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTypePropertyDescriptor(object);
            this.addIncomingPropertyDescriptor(object);
            this.addOutgoingPropertyDescriptor(object);
            this.addAllEdgesPropertyDescriptor(object);
            List origDescriptors = this.itemPropertyDescriptors;
            this.itemPropertyDescriptors = new ArrayList(origDescriptors.size());
            for (IItemPropertyDescriptor origDescriptor : origDescriptors) {
                this.itemPropertyDescriptors.add(new ItemPropertyDescriptorDecorator(origDescriptor){

                    @Override
                    public boolean canSetProperty(Object object) {
                        return NodeItemProvider.this.isUserEditable(object) && super.canSetProperty(object);
                    }
                });
            }
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new NodeTypePropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Node_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Node_type_feature", "_UI_Node_type")));
    }

    protected void addIncomingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Node_incoming_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Node_incoming_feature", "_UI_Node_type"), (EStructuralFeature)HenshinPackage.Literals.NODE__INCOMING, true, false, true, null, null, null));
    }

    protected void addOutgoingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Node_outgoing_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Node_outgoing_feature", "_UI_Node_type"), (EStructuralFeature)HenshinPackage.Literals.NODE__OUTGOING, true, false, true, null, null, null));
    }

    protected void addAllEdgesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Node_allEdges_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Node_allEdges_feature", "_UI_Node_type"), (EStructuralFeature)HenshinPackage.Literals.NODE__ALL_EDGES, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.NODE__ATTRIBUTES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        Graph graph;
        Node kernelNode = this.getKernelNode((Node)object);
        if (kernelNode != null) {
            return this.getImage(kernelNode);
        }
        Node node = (Node)object;
        Object defaultImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Node.png"));
        if (node.eContainer() == null) {
            return defaultImage;
        }
        boolean needsAttention = false;
        if (needsAttention |= node.getType() == null) {
            Object attentionOverlay = this.getResourceLocator().getImage("full/ovr16/Attn_ovr.png");
            defaultImage = IconUtil.getCompositeImage(defaultImage, attentionOverlay);
        }
        if ((graph = node.getGraph()) == null) {
            return defaultImage;
        }
        EObject container = node.getGraph().eContainer();
        if (container instanceof Rule) {
            Rule rule = (Rule)container;
            for (Mapping mapping : rule.getMappings()) {
                if (mapping.getOrigin() != node && mapping.getImage() != node) continue;
                return defaultImage;
            }
            if (rule.getLhs() == graph) {
                Object deleteOverlay = this.getResourceLocator().getImage("full/ovr16/Del_ovr.png");
                return IconUtil.getCompositeImage(defaultImage, deleteOverlay);
            }
            Object createOverlay = this.getResourceLocator().getImage("full/ovr16/Create_ovr.png");
            return IconUtil.getCompositeImage(defaultImage, createOverlay);
        }
        return defaultImage;
    }

    @Override
    public String getText(Object object) {
        Node node = (Node)object;
        String prefix = this.getString("_UI_Node_type");
        String label = NodeItemProvider.getNodeLabel(node);
        return label.length() != 0 ? String.valueOf(prefix) + " " + label : prefix;
    }

    public static String getNodeLabel(Node node) {
        String label = "";
        if (node.getName() != null) {
            label = String.valueOf(label) + node.getName();
        }
        if (node.getType() != null) {
            label = String.valueOf(label) + ":" + node.getType().getName();
        }
        return label.trim();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Node.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                break;
            }
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                break;
            }
            case 0: {
                Node node = (Node)notification.getNotifier();
                this.notifyEdges(node, notification);
            }
        }
        super.notifyChanged(notification);
    }

    private void notifyEdges(Node node, Notification notification) {
        ArrayList edgeList = new ArrayList(node.getIncoming());
        edgeList.addAll(node.getOutgoing());
        if (!edgeList.isEmpty()) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)edgeList.get(0), null);
            for (Edge edge : edgeList) {
                ViewerNotification notif = new ViewerNotification(notification, (Object)edge, false, true);
                adapter.fireNotifyChanged((Notification)notif);
            }
        }
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.NODE__ATTRIBUTES, HenshinFactory.eINSTANCE.createAttribute()));
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        Node node = (Node)owner;
        CompoundCommand cmpCmd = new CompoundCommand(Integer.MIN_VALUE);
        for (Node dependentNode : HenshinMultiRuleUtil.getDependentNodes((Node)node)) {
            cmpCmd.append(this.createSetCommand(domain, (EObject)dependentNode, feature, value, index));
        }
        cmpCmd.append(super.createSetCommand(domain, owner, feature, value, index));
        return cmpCmd.unwrap();
    }

    protected boolean isUserEditable(Object object) {
        return this.getKernelNode((Node)object) == null;
    }

    protected Node getKernelNode(Node node) {
        if (node.getGraph() != null && (node.getGraph().isLhs() || node.getGraph().isRhs())) {
            Rule rule = node.getGraph().getContainerRule();
            return (Node)rule.getOriginInKernelRule((GraphElement)node);
        }
        return null;
    }

    public Object getForeground(Object object) {
        return this.isUserEditable(object) ? super.getForeground(object) : URI.createURI((String)"color://rgb/0/0/255");
    }
}

