/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.combpattern;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class CombBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/combpattern";
    final HenshinResourceSet resourceSet;
    final Engine engine;

    public CombBenchmark(String path) {
        this.resourceSet = new HenshinResourceSet(path);
        this.engine = new EngineImpl();
    }

    public long buildGrid(EGraph graph, int width, int height, boolean sparse) {
        int expectedEdges;
        TransformationSystem system = this.resourceSet.getTransformationSystem(sparse ? "grid-sparse.henshin" : "grid-full.henshin");
        TransformationUnit unit = system.findUnitByName("buildGrid");
        UnitApplicationImpl application = new UnitApplicationImpl(this.engine);
        application.setUnit(unit);
        application.setEGraph(graph);
        application.setParameterValue("width", (Object)width);
        application.setParameterValue("height", (Object)height);
        long time = System.currentTimeMillis();
        application.execute(null);
        time = System.currentTimeMillis() - time;
        int expectedNodes = height * width + 1;
        int n = expectedEdges = sparse ? width * height + width / 2 * (3 * height - 2) : width * height + (height - 1) * width + height * (width - 1);
        if (graph.size() != expectedNodes || InterpreterUtil.countEdges((EGraph)graph) != expectedEdges) {
            throw new AssertionError((Object)"Generated grid incorrect");
        }
        return time;
    }

    public Rule buildCombPattern(int width) {
        TransformationSystem system = this.resourceSet.getTransformationSystem("comb.henshin");
        TransformationUnit unit = system.findUnitByName("buildCombPattern");
        Rule rule = (Rule)EcoreUtil.copy((EObject)system.findRuleByName("combPattern"));
        EGraphImpl graph = new EGraphImpl();
        graph.addTree((EObject)rule);
        for (EPackage epackage : system.getImports()) {
            graph.addTree((EObject)epackage);
        }
        UnitApplicationImpl application = new UnitApplicationImpl(this.engine);
        application.setUnit(unit);
        application.setEGraph((EGraph)graph);
        application.setParameterValue("width", (Object)width);
        application.execute(null);
        int expectedNodes = 2 * width;
        int expectedEdges = 2 * width - 1;
        if (rule.getLhs().getNodes().size() != expectedNodes || rule.getLhs().getEdges().size() != expectedEdges) {
            throw new AssertionError((Object)"Generated comb pattern incorrect");
        }
        return rule;
    }

    public long matchCombPattern(EGraph graph, int gridWidth, int gridHeight, boolean sparse, int patternWidth, Rule combPattern) {
        long time = System.currentTimeMillis();
        int foundMatches = InterpreterUtil.findAllMatches((Engine)this.engine, (Rule)combPattern, (EGraph)graph, null).size();
        time = System.currentTimeMillis() - time;
        int expectedMatches = CombBenchmark.expectedCombMatchCount(gridWidth, gridHeight, sparse, patternWidth);
        if (expectedMatches != foundMatches) {
            throw new AssertionError((Object)("Expected " + expectedMatches + " for the comb pattern, but found " + foundMatches));
        }
        return time;
    }

    public static int expectedCombMatchCount(int gridWidth, int gridHeight, boolean sparse, int patternWidth) {
        return sparse ? 0 : (gridWidth - patternWidth + 1) * (gridWidth - 1);
    }

    public static void run(String path) {
        Rule pattern;
        System.out.println("Starting comb benchmark...");
        System.out.println("MaxMemory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "M\n");
        CombBenchmark benchmark = new CombBenchmark(path);
        benchmark.engine.getOptions().put("SORT_VARIABLES", false);
        EGraphImpl grid = new EGraphImpl();
        int maxFullLen = 60;
        int maxSparseLen = 100;
        System.out.println("Benchmark for generating sparse grid...");
        System.out.println("Length\tNodes\tTime");
        int i = 10;
        while (i <= maxSparseLen) {
            System.out.println(String.valueOf(i) + "\t" + i * i + "\t" + benchmark.buildGrid((EGraph)grid, i, i, true));
            grid.clear();
            i += 10;
        }
        System.out.println("\nBenchmark for generating full grid...");
        System.out.println("Length\tNodes\tTime");
        i = 10;
        while (i <= maxFullLen) {
            System.out.println(String.valueOf(i) + "\t" + i * i + "\t" + benchmark.buildGrid((EGraph)grid, i, i, false));
            grid.clear();
            i += 10;
        }
        System.out.println("\nBenchmark for matching comb pattern in full grid...");
        System.out.println("GridLen\tPatLen\tMatches\tTime");
        benchmark.buildGrid((EGraph)grid, maxFullLen, maxFullLen, false);
        int j = 10;
        while (j <= maxFullLen) {
            pattern = benchmark.buildCombPattern(j);
            System.out.println(String.valueOf(maxFullLen) + "\t" + j + "\t" + CombBenchmark.expectedCombMatchCount(maxFullLen, maxFullLen, false, j) + "\t" + benchmark.matchCombPattern((EGraph)grid, maxFullLen, maxFullLen, false, j, pattern));
            j += 10;
        }
        grid.clear();
        System.out.println("\nBenchmark for matching comb pattern in sparse grid (no matches)...");
        System.out.println("GridLen\tPatLen\tTime");
        benchmark.buildGrid((EGraph)grid, maxSparseLen, maxSparseLen, true);
        j = 10;
        while (j <= maxSparseLen) {
            pattern = benchmark.buildCombPattern(j);
            System.out.println(String.valueOf(maxSparseLen) + "\t" + j + "\t" + benchmark.matchCombPattern((EGraph)grid, maxSparseLen, maxSparseLen, true, j, pattern));
            j += 10;
        }
        grid.clear();
    }

    public static void main(String[] args) {
        CombBenchmark.run(PATH);
    }
}

