/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.actions.internal.AbstractMapEditor;
import org.eclipse.emf.henshin.model.actions.internal.EdgeMapEditor;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public class NodeMapEditor
extends AbstractMapEditor<Node> {
    private EdgeMapEditor edgeMapEditor;

    public NodeMapEditor(Graph source, Graph target, List<Mapping> mappings) {
        super(source, target, mappings);
        this.edgeMapEditor = new EdgeMapEditor(this);
    }

    public NodeMapEditor(Graph target) {
        super(target);
        this.edgeMapEditor = new EdgeMapEditor(this);
    }

    public NodeMapEditor(EdgeMapEditor edgeMapEditor) {
        super(edgeMapEditor);
        this.edgeMapEditor = edgeMapEditor;
    }

    @Override
    protected void doRemove(Node node) {
        node.getGraph().removeNode(node);
    }

    @Override
    protected Node doCopy(Node node) {
        Node copy = this.performCopy(node);
        for (Edge incoming : node.getIncoming()) {
            this.performCopy(incoming.getSource());
            this.edgeMapEditor.copy(incoming);
        }
        for (Edge outgoing : node.getOutgoing()) {
            this.performCopy(outgoing.getTarget());
            this.edgeMapEditor.copy(outgoing);
        }
        return copy;
    }

    @Override
    protected void doMove(Node node) {
        Graph newGraph = this.getOpposite(node.getGraph());
        for (Edge incoming : node.getIncoming()) {
            incoming.setSource(this.performCopy(incoming.getSource()));
            incoming.setGraph(newGraph);
        }
        for (Edge outgoing : node.getOutgoing()) {
            outgoing.setTarget(this.performCopy(outgoing.getTarget()));
            outgoing.setGraph(newGraph);
        }
        node.setGraph(newGraph);
    }

    @Override
    protected Node doReplace(Node node) {
        Edge oldEdge;
        Node opposite = this.getOpposite(node);
        Graph graph = node.getGraph();
        for (Edge incoming : opposite.getIncoming()) {
            oldEdge = this.edgeMapEditor.getOpposite(incoming);
            if (oldEdge != null) {
                graph.removeEdge(oldEdge);
            }
            incoming.setSource(this.performCopy(incoming.getSource()));
            incoming.setGraph(graph);
        }
        for (Edge outgoing : opposite.getOutgoing()) {
            oldEdge = this.edgeMapEditor.getOpposite(outgoing);
            if (oldEdge != null) {
                graph.removeEdge(oldEdge);
            }
            outgoing.setTarget(this.performCopy(outgoing.getTarget()));
            outgoing.setGraph(graph);
        }
        for (Edge incoming : new ArrayList<Edge>((Collection<Edge>)node.getIncoming())) {
            incoming.setTarget(opposite);
        }
        for (Edge outgoing : new ArrayList<Edge>((Collection<Edge>)node.getOutgoing())) {
            outgoing.setSource(opposite);
        }
        this.removeMapping(node, opposite);
        int index = graph.getNodes().indexOf((Object)node);
        graph.getNodes().set(index, (Object)opposite);
        return opposite;
    }

    Node performCopy(Node node) {
        Node opposite = this.getOpposite(node);
        if (opposite == null) {
            opposite = (Node)EcoreUtil.copy((EObject)node);
            opposite.setGraph(this.getOpposite(node.getGraph()));
            this.createMapping(node, opposite);
        }
        return opposite;
    }

    @Override
    protected void doRemoveMapping(Node origin, Node image) {
        HenshinMappingUtil.removeMapping(origin, image, this.getMappings());
    }

    @Override
    protected void doCreateMapping(Node origin, Node image) {
        HenshinMappingUtil.createMapping(origin, image, this.getMappings());
    }
}

