/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.model.Rule;

public class InterpreterUtil {
    public static int countEdges(EGraph graph) {
        int links = 0;
        for (EObject object : graph) {
            for (EReference ref : object.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    links += ((EList)object.eGet((EStructuralFeature)ref)).size();
                    continue;
                }
                if (object.eGet((EStructuralFeature)ref) == null) continue;
                ++links;
            }
        }
        return links;
    }

    public static List<Match> findAllMatches(Engine engine, Rule rule, EGraph graph, Match partialMatch) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Match match : engine.findMatches(rule, graph, partialMatch)) {
            matches.add(match);
        }
        return matches;
    }

    public static String objectToString(Object object) {
        EClass eclass;
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof DynamicEObjectImpl && (eclass = ((DynamicEObjectImpl)object).eClass()) != null) {
            String type = eclass.getName();
            EPackage epackage = eclass.getEPackage();
            while (epackage != null) {
                type = String.valueOf(epackage.getName()) + "." + type;
                epackage = epackage.getESuperPackage();
            }
            String args = "";
            for (EAttribute att : eclass.getEAllAttributes()) {
                args = String.valueOf(args) + ", " + att.getName() + "=" + InterpreterUtil.objectToString(((DynamicEObjectImpl)object).eGet((EStructuralFeature)att));
            }
            return String.valueOf(type) + "@" + Integer.toHexString(object.hashCode()) + " (dynamic" + args + ")";
        }
        return String.valueOf(object);
    }
}

