/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.impl.AbstractApplicationImpl;
import org.eclipse.emf.henshin.interpreter.impl.AssignmentImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class UnitApplicationImpl
extends AbstractApplicationImpl {
    protected Assignment assignment;
    protected Assignment resultAssignment;
    protected final Stack<RuleApplication> appliedRules = new Stack();
    protected final Stack<RuleApplication> undoneRules = new Stack();

    public UnitApplicationImpl(Engine engine) {
        super(engine);
    }

    protected UnitApplicationImpl(Engine engine, EGraph graph, TransformationUnit unit, Assignment assignment) {
        this(engine);
        this.setEGraph(graph);
        this.setUnit(unit);
        this.setAssignment(assignment);
    }

    @Override
    public boolean execute(ApplicationMonitor monitor) {
        if (monitor == null) {
            monitor = InterpreterFactory.INSTANCE.createApplicationMonitor();
        }
        this.appliedRules.clear();
        this.undoneRules.clear();
        this.resultAssignment = this.assignment != null ? new AssignmentImpl(this.assignment, true) : new AssignmentImpl(this.unit, true);
        return this.doExecute(monitor);
    }

    protected boolean doExecute(ApplicationMonitor monitor) {
        if (this.unit.isActivated()) {
            switch (this.unit.eClass().getClassifierID()) {
                case 3: {
                    return this.executeRule(monitor);
                }
                case 13: {
                    return this.executeIndependentUnit(monitor);
                }
                case 14: {
                    return this.executeSequentialUnit(monitor);
                }
                case 15: {
                    return this.executeConditionalUnit(monitor);
                }
                case 16: {
                    return this.executePriorityUnit(monitor);
                }
                case 17: {
                    return this.executeIteratedUnit(monitor);
                }
                case 18: {
                    return this.executeLoopUnit(monitor);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean undo(ApplicationMonitor monitor) {
        if (this.appliedRules.isEmpty()) {
            return true;
        }
        if (monitor == null) {
            monitor = InterpreterFactory.INSTANCE.createApplicationMonitor();
        }
        boolean success = true;
        while (!this.appliedRules.isEmpty()) {
            RuleApplication ruleApplication = this.appliedRules.pop();
            if (!ruleApplication.undo(monitor)) {
                success = false;
                break;
            }
            this.undoneRules.push(ruleApplication);
        }
        monitor.notifyUndo(this, success);
        return success;
    }

    @Override
    public boolean redo(ApplicationMonitor monitor) {
        if (this.undoneRules.isEmpty()) {
            return true;
        }
        if (monitor == null) {
            monitor = InterpreterFactory.INSTANCE.createApplicationMonitor();
        }
        boolean success = true;
        while (!this.undoneRules.isEmpty()) {
            RuleApplication ruleApplication = this.undoneRules.pop();
            if (!ruleApplication.redo(monitor)) {
                success = false;
                break;
            }
            this.appliedRules.push(ruleApplication);
        }
        monitor.notifyRedo(this, success);
        return success;
    }

    protected boolean executeRule(ApplicationMonitor monitor) {
        Rule rule = (Rule)this.unit;
        RuleApplicationImpl ruleApp = new RuleApplicationImpl(this.engine, this.graph, rule, this.resultAssignment);
        if (ruleApp.execute(monitor)) {
            this.resultAssignment = new AssignmentImpl(ruleApp.getResultMatch(), true);
            this.appliedRules.push(ruleApp);
            return true;
        }
        return false;
    }

    protected boolean executeIndependentUnit(ApplicationMonitor monitor) {
        IndependentUnit indepUnit = (IndependentUnit)this.unit;
        ArrayList subUnits = new ArrayList(indepUnit.getSubUnits());
        boolean success = false;
        while (!subUnits.isEmpty()) {
            if (monitor.isCanceled()) {
                if (!monitor.isUndo()) break;
                this.undo(monitor);
                break;
            }
            int index = new Random().nextInt(subUnits.size());
            UnitApplicationImpl unitApp = this.createApplicationFor((TransformationUnit)subUnits.remove(index));
            if (!unitApp.execute(monitor)) continue;
            this.updateParameterValues(unitApp);
            this.appliedRules.addAll(unitApp.appliedRules);
            success = true;
            break;
        }
        monitor.notifyExecute(this, success);
        return success;
    }

    protected boolean executeSequentialUnit(ApplicationMonitor monitor) {
        SequentialUnit seqUnit = (SequentialUnit)this.unit;
        boolean success = true;
        for (TransformationUnit subUnit : seqUnit.getSubUnits()) {
            if (monitor.isCanceled()) {
                if (monitor.isUndo()) {
                    this.undo(monitor);
                }
                success = false;
                break;
            }
            UnitApplicationImpl unitApp = this.createApplicationFor(subUnit);
            if (unitApp.execute(monitor)) {
                this.updateParameterValues(unitApp);
                this.appliedRules.addAll(unitApp.appliedRules);
                continue;
            }
            if (!seqUnit.isStrict()) break;
            success = false;
            if (!seqUnit.isRollback()) break;
            this.undo(monitor);
            break;
        }
        monitor.notifyExecute(this, success);
        return success;
    }

    protected boolean executeConditionalUnit(ApplicationMonitor monitor) {
        boolean success = false;
        ConditionalUnit condUnit = (ConditionalUnit)this.unit;
        UnitApplicationImpl ifUnitApp = this.createApplicationFor(condUnit.getIf());
        if (ifUnitApp.execute(monitor)) {
            this.updateParameterValues(ifUnitApp);
            this.appliedRules.addAll(ifUnitApp.appliedRules);
            UnitApplicationImpl thenUnitApp = this.createApplicationFor(condUnit.getThen());
            success = thenUnitApp.execute(monitor);
            if (success) {
                this.updateParameterValues(thenUnitApp);
            }
            this.appliedRules.addAll(thenUnitApp.appliedRules);
        } else if (condUnit.getElse() != null) {
            UnitApplicationImpl elseUnitApp = this.createApplicationFor(condUnit.getElse());
            success = elseUnitApp.execute(monitor);
            if (success) {
                this.updateParameterValues(elseUnitApp);
            }
            this.appliedRules.addAll(elseUnitApp.appliedRules);
        }
        if (monitor.isCanceled()) {
            if (monitor.isUndo()) {
                this.undo(monitor);
            }
            monitor.notifyExecute(this, false);
            return false;
        }
        if (!success) {
            this.undo(monitor);
        }
        monitor.notifyExecute(this, success);
        return success;
    }

    protected boolean executePriorityUnit(ApplicationMonitor monitor) {
        PriorityUnit priUnit = (PriorityUnit)this.unit;
        boolean success = false;
        for (TransformationUnit subUnit : priUnit.getSubUnits()) {
            if (monitor.isCanceled()) {
                if (!monitor.isUndo()) break;
                this.undo(monitor);
                break;
            }
            UnitApplicationImpl unitApp = this.createApplicationFor(subUnit);
            if (!unitApp.execute(monitor)) continue;
            this.updateParameterValues(unitApp);
            this.appliedRules.addAll(unitApp.appliedRules);
            success = true;
            break;
        }
        monitor.notifyExecute(this, success);
        return success;
    }

    protected boolean executeIteratedUnit(ApplicationMonitor monitor) {
        int iterations;
        IteratedUnit iteratedUnit = (IteratedUnit)this.unit;
        ScriptEngine scriptEngine = this.engine.getScriptEngine();
        for (Parameter param : this.unit.getParameters()) {
            scriptEngine.put(param.getName(), this.resultAssignment.getParameterValue(param));
        }
        try {
            Object value = scriptEngine.eval(iteratedUnit.getIterations());
            if (value == null) {
                throw new RuntimeException("Error determining number of iterations for unit '" + iteratedUnit.getName() + "'");
            }
            String valueString = value.toString();
            int index = valueString.indexOf(46);
            if (index == 0) {
                valueString = "0";
            } else if (index > 0) {
                valueString = valueString.substring(0, index);
            }
            iterations = Integer.parseInt(valueString);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.getMessage());
        }
        boolean success = true;
        int i = 0;
        while (i < iterations) {
            if (monitor.isCanceled()) {
                if (monitor.isUndo()) {
                    this.undo(monitor);
                }
                success = false;
                break;
            }
            UnitApplicationImpl unitApp = this.createApplicationFor(iteratedUnit.getSubUnit());
            if (!unitApp.execute(monitor)) {
                success = false;
                break;
            }
            this.updateParameterValues(unitApp);
            this.appliedRules.addAll(unitApp.appliedRules);
            ++i;
        }
        monitor.notifyExecute(this, success);
        return success;
    }

    protected boolean executeLoopUnit(ApplicationMonitor monitor) {
        LoopUnit loopUnit = (LoopUnit)this.unit;
        boolean success = true;
        while (true) {
            if (monitor.isCanceled()) {
                if (monitor.isUndo()) {
                    this.undo(monitor);
                }
                success = false;
                break;
            }
            UnitApplicationImpl unitApp = this.createApplicationFor(loopUnit.getSubUnit());
            if (!unitApp.execute(monitor)) break;
            this.updateParameterValues(unitApp);
            this.appliedRules.addAll(unitApp.appliedRules);
        }
        monitor.notifyExecute(this, success);
        return success;
    }

    protected UnitApplicationImpl createApplicationFor(TransformationUnit subUnit) {
        if (this.resultAssignment == null) {
            this.resultAssignment = new AssignmentImpl(this.unit);
        }
        AssignmentImpl assign = new AssignmentImpl(subUnit);
        for (ParameterMapping mapping : this.unit.getParameterMappings()) {
            Parameter source = mapping.getSource();
            Parameter target = mapping.getTarget();
            if (target.getUnit() != subUnit) continue;
            assign.setParameterValue(target, this.resultAssignment.getParameterValue(source));
        }
        return new UnitApplicationImpl(this.engine, this.graph, subUnit, assign);
    }

    protected void updateParameterValues(UnitApplicationImpl subUnitApp) {
        if (this.resultAssignment == null) {
            this.resultAssignment = new AssignmentImpl(this.unit);
        }
        for (ParameterMapping mapping : this.unit.getParameterMappings()) {
            Object value;
            Parameter param;
            Parameter source = mapping.getSource();
            Parameter target = mapping.getTarget();
            if (source.getUnit() != subUnitApp.getUnit() || (param = subUnitApp.getUnit().getParameterByName(source.getName())) == null || (value = subUnitApp.getResultAssignment().getParameterValue(param)) == null) continue;
            this.resultAssignment.setParameterValue(target, value);
        }
    }

    @Override
    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    @Override
    public Assignment getResultAssignment() {
        return this.resultAssignment;
    }

    @Override
    public Object getResultParameterValue(String paramName) {
        if (this.unit == null) {
            throw new RuntimeException("Transformation unit not set");
        }
        Parameter param = this.unit.getParameterByName(paramName);
        if (param == null) {
            throw new RuntimeException("No parameter \"" + paramName + "\" in transformation unit \"" + this.unit.getName() + "\" found");
        }
        if (this.resultAssignment != null) {
            return this.resultAssignment.getParameterValue(param);
        }
        return null;
    }

    @Override
    public void setParameterValue(String paramName, Object value) {
        if (this.unit == null) {
            throw new RuntimeException("Transformation unit not set");
        }
        Parameter param = this.unit.getParameterByName(paramName);
        if (param == null) {
            throw new RuntimeException("No parameter \"" + paramName + "\" in transformation unit \"" + this.unit.getName() + "\" found");
        }
        if (this.assignment == null) {
            this.assignment = new AssignmentImpl(this.unit);
        }
        this.assignment.setParameterValue(param, value);
    }

    public List<RuleApplication> getAppliedRules() {
        return new ArrayList<RuleApplication>(this.appliedRules);
    }

    public List<RuleApplication> getUndoneRules() {
        return new ArrayList<RuleApplication>(this.undoneRules);
    }
}

