/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.jit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.jit.JITMatcher;
import org.eclipse.emf.henshin.interpreter.jit.JITMatcherCompiler;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public abstract class AbstractJITMatcherCompiler
implements JITMatcherCompiler {
    @Override
    public JITMatcher generateMatcher(Rule rule, Map<String, Object> options) {
        StringWriter ruleFields = new StringWriter();
        StringWriter ruleInitCode = new StringWriter();
        StringWriter matcherFields = new StringWriter();
        StringWriter matcherCode = new StringWriter();
        MatchingCodeGenerator generator = new MatchingCodeGenerator();
        generator.ruleFields = new PrintWriter(ruleFields);
        generator.ruleInitCode = new PrintWriter(ruleInitCode);
        generator.matcherFields = new PrintWriter(matcherFields);
        generator.matcherCode = new PrintWriter(matcherCode);
        if (this.generateNextMatchMethod(rule, generator)) {
            File root = new File("/tmp/henshin-jit");
            int rand = Long.valueOf((long)rule.hashCode() + System.currentTimeMillis()).intValue();
            if (rand < 0) {
                rand = -rand;
            }
            String className = "JIT" + rand;
            File sourceFile = new File(root, String.valueOf(className) + ".java");
            try {
                sourceFile.getParentFile().mkdirs();
                PrintWriter out = new PrintWriter(new FileWriter(sourceFile));
                out.println("import java.util.*;");
                out.println("import org.eclipse.emf.ecore.*;");
                out.println("import org.eclipse.emf.henshin.model.*;");
                out.println("import org.eclipse.emf.henshin.interpreter.*;");
                out.println("import org.eclipse.emf.henshin.interpreter.impl.*;");
                out.println("import org.eclipse.emf.henshin.interpreter.matching.jit.*;");
                out.println();
                out.println("public class " + className + " implements JITMatchFinder {");
                out.println();
                out.println(ruleFields.toString());
                out.println();
                out.println("  public void init(Rule rule) {");
                out.println(ruleInitCode.toString());
                out.println("  }");
                out.println();
                out.println("  public Iterable<Match> findMatches(final EGraph graph) {");
                out.println("    return new Iterable<Match>() {");
                out.println("      public Iterator<Match> iterator() {");
                out.println("        return new Iterator<Match>() {");
                out.println();
                out.println("          private Match nextMatch;");
                out.println("          private boolean computedNext = false;");
                out.println(matcherFields.toString());
                out.println();
                out.println("          public boolean hasNext() {");
                out.println("            if (!computedNext) {");
                out.println("      \t       nextMatch = nextMatch();");
                out.println("      \t       computedNext = true;");
                out.println("            }");
                out.println("            return (nextMatch!=null);");
                out.println("          }");
                out.println();
                out.println("          public Match next() {");
                out.println("      \t     if (hasNext()) {");
                out.println("      \t       computedNext = false;");
                out.println("      \t     }");
                out.println("      \t     return nextMatch;");
                out.println("          }");
                out.println();
                out.println("          public void remove() {");
                out.println("            throw new UnsupportedOperationException();");
                out.println("          }");
                out.println();
                out.println("          public Match nextMatch() {");
                out.println(matcherCode.toString());
                out.println("          }");
                out.println();
                out.println("        }; // new Iterator");
                out.println("      } // iterator()");
                out.println("    }; // new Iterable");
                out.println("  } // findMatches()");
                out.println("} // JITMatchFinderImpl");
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            compiler.run(null, null, null, sourceFile.getPath());
            try {
                URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{root.toURI().toURL()});
                JITMatcher matchFinder = (JITMatcher)Class.forName(className, true, classLoader).newInstance();
                Method init = matchFinder.getClass().getMethod("init", Rule.class);
                init.invoke((Object)matchFinder, rule);
                return matchFinder;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return null;
    }

    protected void initRuleFields(Rule rule, MatchingCodeGenerator gen) {
        gen.ruleFields.println("  Rule " + this.objField((EObject)rule) + ";");
        gen.ruleInitCode.println("    " + this.objField((EObject)rule) + " = rule;");
        this.initChildFields((EObject)rule, gen);
    }

    private void initChildFields(EObject parent, MatchingCodeGenerator gen) {
        for (EReference con : parent.eClass().getEAllContainments()) {
            List<EObject> children;
            String getter = String.valueOf(this.objField(parent)) + this.getter((EStructuralFeature)con);
            if (con.isMany()) {
                children = (List)parent.eGet((EStructuralFeature)con);
            } else {
                children = new ArrayList();
                if (parent.eGet((EStructuralFeature)con) != null) {
                    children.add((EObject)parent.eGet((EStructuralFeature)con));
                }
            }
            int i = 0;
            while (i < children.size()) {
                EObject child = (EObject)children.get(i);
                String type = child.eClass().getName();
                gen.ruleFields.println("  " + type + " " + this.objField(child) + ";");
                gen.ruleInitCode.println("    " + this.objField(child) + " = (" + type + ") " + getter + (con.isMany() ? ".get(" + i + ");" : ";"));
                if (child instanceof Node) {
                    gen.ruleFields.println("  EClass " + this.typeField(child) + ";");
                    gen.ruleInitCode.println("    " + this.typeField(child) + " = " + this.objField(child) + ".getType();");
                }
                if (child instanceof Edge) {
                    gen.ruleFields.println("  EReference " + this.typeField(child) + ";");
                    gen.ruleInitCode.println("    " + this.typeField(child) + " = " + this.objField(child) + ".getType();");
                }
                if (child instanceof Attribute) {
                    gen.ruleFields.println("  EAttribute " + this.typeField(child) + ";");
                    gen.ruleInitCode.println("    " + this.typeField(child) + " = " + this.objField(child) + ".getType();");
                }
                this.initChildFields((EObject)children.get(i), gen);
                ++i;
            }
        }
    }

    protected String objField(EObject object) {
        return String.valueOf(object.eClass().getName().toLowerCase()) + object.hashCode();
    }

    protected String typeField(EObject object) {
        return "type" + object.hashCode();
    }

    protected String indexField(EObject object) {
        return "index" + object.hashCode();
    }

    protected String getter(EStructuralFeature feature) {
        return ".get" + feature.getName().substring(0, 1).toUpperCase() + feature.getName().substring(1) + "()";
    }

    protected abstract boolean generateNextMatchMethod(Rule var1, MatchingCodeGenerator var2);

    protected class MatchingCodeGenerator {
        PrintWriter ruleFields;
        PrintWriter ruleInitCode;
        PrintWriter matcherFields;
        PrintWriter matcherCode;

        protected MatchingCodeGenerator() {
        }
    }
}

