/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.commands.GraphComplexUnsetCommand;
import org.eclipse.emf.henshin.commands.NegligentRemoveCommand;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.provider.TransformationUnitItemProvider;
import org.eclipse.emf.henshin.provider.trans.RuleMappingItemProvider;

public class RuleItemProvider
extends TransformationUnitItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public static final int MAX_UNFOLD_MAPPINGS = 5;

    public RuleItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addCheckDanglingPropertyDescriptor(object);
            this.addInjectiveMatchingPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addCheckDanglingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rule_checkDangling_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rule_checkDangling_feature", "_UI_Rule_type"), (EStructuralFeature)HenshinPackage.Literals.RULE__CHECK_DANGLING, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addInjectiveMatchingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rule_injectiveMatching_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rule_injectiveMatching_feature", "_UI_Rule_type"), (EStructuralFeature)HenshinPackage.Literals.RULE__INJECTIVE_MATCHING, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__LHS);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__RHS);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__ATTRIBUTE_CONDITIONS);
            this.childrenFeatures.add(HenshinPackage.Literals.RULE__MAPPINGS);
        }
        return this.childrenFeatures;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        Collection<?> childrenList = super.getChildren(object);
        Rule rule = (Rule)object;
        if (rule.getMappings().size() > 5) {
            childrenList.removeAll((Collection<?>)rule.getMappings());
            if (!this.filteringEnabled || !this.filterProvider.isFiltered((EClassifier)HenshinPackage.eINSTANCE.getMapping())) {
                childrenList.add(new RuleMappingItemProvider(this.adapterFactory, (EObject)rule));
            }
        }
        return childrenList;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Rule"));
    }

    @Override
    public String getText(Object object) {
        String label = ((Rule)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_Rule_type") : String.valueOf(this.getString("_UI_Rule_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Rule.class)) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                this.notifyMappedNodes(notification);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    private void notifyMappedNodes(Notification notification) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        switch (notification.getEventType()) {
            case 4: {
                mappings.add((Mapping)notification.getOldValue());
                break;
            }
            case 3: {
                mappings.add((Mapping)notification.getNewValue());
                break;
            }
            case 5: {
                mappings.addAll((Collection)notification.getNewValue());
                break;
            }
            case 6: {
                mappings.addAll((Collection)notification.getOldValue());
            }
        }
        if (!mappings.isEmpty()) {
            for (Mapping mapping : mappings) {
                if (mapping.getImage() != null) {
                    this.notifyNodeForRefresh(notification, mapping.getImage());
                }
                if (mapping.getOrigin() == null) continue;
                this.notifyNodeForRefresh(notification, mapping.getOrigin());
            }
        }
    }

    private void notifyNodeForRefresh(Notification notification, Node node) {
        if (node != null) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)node, Node.class);
            ViewerNotification notif = new ViewerNotification(notification, (Object)node, false, true);
            adapter.fireNotifyChanged((Notification)notif);
        }
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__LHS, HenshinFactory.eINSTANCE.createGraph()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__RHS, HenshinFactory.eINSTANCE.createGraph()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__ATTRIBUTE_CONDITIONS, HenshinFactory.eINSTANCE.createAttributeCondition()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.RULE__MAPPINGS, HenshinFactory.eINSTANCE.createMapping()));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        boolean qualify;
        Object childFeature = feature;
        Object childObject = child;
        boolean bl = qualify = childFeature == HenshinPackage.Literals.RULE__LHS || childFeature == HenshinPackage.Literals.RULE__RHS;
        if (qualify) {
            return this.getString("_UI_CreateChild_text2", new Object[]{this.getTypeText(childObject), this.getFeatureText(childFeature), this.getTypeText(owner)});
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == HenshinPackage.Literals.RULE__MAPPINGS) {
            return new NegligentRemoveCommand(domain, owner, feature, collection);
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if ((feature == HenshinPackage.Literals.RULE__LHS || feature == HenshinPackage.Literals.RULE__RHS) && value == SetCommand.UNSET_VALUE) {
            return new GraphComplexUnsetCommand(domain, owner, feature);
        }
        return super.createSetCommand(domain, owner, feature, value);
    }
}

