/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionType;
import org.eclipse.emf.henshin.diagram.edit.actions.EdgeActionHelper;
import org.eclipse.emf.henshin.diagram.edit.actions.NodeActionHelper;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.diagram.parsers.NodeActionParser;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class EdgeActionParser
extends AbstractParser {
    public EdgeActionParser() {
        super(new EAttribute[0]);
    }

    public String getEditString(IAdaptable element, int flags) {
        Edge edge = (Edge)element.getAdapter(EObject.class);
        Action action = EdgeActionHelper.INSTANCE.getAction(edge);
        return action != null ? action.toString() : "unknown";
    }

    public String getPrintString(IAdaptable element, int flags) {
        return NodeActionParser.addActionQuotes(this.getEditString(element, flags));
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Edge edge = (Edge)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)edge);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Edge Action", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return EdgeActionParser.this.doParsing(value, edge);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Edge edge) {
        try {
            Action action = Action.parse(value);
            NodeActionHelper helper = NodeActionHelper.INSTANCE;
            Node src = helper.getActionNode(edge.getSource());
            Node trg = helper.getActionNode(edge.getTarget());
            Action srcAction = helper.getAction(src);
            Action trgAction = helper.getAction(trg);
            if (!srcAction.equals(action) && (srcAction.getType() != ActionType.PRESERVE || srcAction.isAmalgamated())) {
                NodeActionHelper.INSTANCE.setAction(src, action);
            }
            if (!trgAction.equals(action) && (trgAction.getType() != ActionType.PRESERVE || trgAction.isAmalgamated())) {
                NodeActionHelper.INSTANCE.setAction(trg, action);
            }
            EdgeActionHelper.INSTANCE.setAction(edge, action);
            return CommandResult.newOKCommandResult();
        }
        catch (Throwable t) {
            HenshinDiagramEditorPlugin.getInstance().logError("Error occurred when trying to set an edge action", t);
            return CommandResult.newErrorCommandResult((Throwable)t);
        }
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

