/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionHelper;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionNACUtil;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionType;
import org.eclipse.emf.henshin.diagram.edit.helpers.AmalgamationEditHelper;
import org.eclipse.emf.henshin.diagram.edit.maps.MapEditor;
import org.eclipse.emf.henshin.diagram.edit.maps.MappingMapEditor;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinNACUtil;

public abstract class GenericActionHelper<E extends EObject, C extends EObject>
implements ActionHelper<E, C> {
    @Override
    public Action getAction(E element) {
        MapEditor<E> editor;
        EObject origin;
        Graph graph = this.getGraph(element);
        if (graph == null) {
            return null;
        }
        Rule rule = graph.getContainerRule();
        if (rule == null) {
            return null;
        }
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromMultiRule(rule);
        boolean isAmalgamated = this.isAmalgamated(element, amalgamation);
        String[] amalgamationParams = this.getAmalgamationParameters(element, rule, amalgamation);
        if (amalgamation != null && !isAmalgamated) {
            return null;
        }
        if (graph == rule.getLhs()) {
            MapEditor<E> editor2 = this.getMapEditor(rule.getRhs());
            EObject image = (EObject)editor2.getOpposite(element);
            if (image != null) {
                return new Action(ActionType.PRESERVE, isAmalgamated, amalgamationParams);
            }
            return new Action(ActionType.DELETE, isAmalgamated, amalgamationParams);
        }
        if (graph == rule.getRhs()) {
            MapEditor<E> editor3 = this.getMapEditor(rule.getRhs());
            EObject origin2 = (EObject)editor3.getOpposite(element);
            if (origin2 == null) {
                return new Action(ActionType.CREATE, isAmalgamated, amalgamationParams);
            }
        } else if (this.isNAC(graph) && (origin = (EObject)(editor = this.getMapEditor(graph)).getOpposite(element)) == null) {
            if ("default".equals(graph.getName())) {
                return new Action(ActionType.FORBID, new String[0]);
            }
            return new Action(ActionType.FORBID, graph.getName());
        }
        return null;
    }

    @Override
    public void setAction(E element, Action action) {
        Rule newMulti;
        AmalgamationUnit amalgamation;
        NestedCondition nac;
        Action current = this.getAction(element);
        if (current == null) {
            throw new IllegalArgumentException();
        }
        if (action.equals(current)) {
            return;
        }
        Graph graph = this.getGraph(element);
        Rule rule = graph.getContainerRule();
        if (current.getType() == ActionType.PRESERVE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            EObject image = (EObject)editor.getOpposite(element);
            if (action.getType() == ActionType.DELETE) {
                editor.remove(image);
            } else if (action.getType() == ActionType.CREATE) {
                editor.replace(image);
            } else if (action.getType() == ActionType.FORBID) {
                editor.remove(image);
                NestedCondition nac2 = ActionNACUtil.getOrCreateNAC(action, rule);
                editor = this.getMapEditor(nac2.getConclusion());
                editor.move(element);
            }
        } else if (current.getType() == ActionType.CREATE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            if (action.getType() != ActionType.CREATE) {
                editor.move(element);
            }
            if (action.getType() == ActionType.PRESERVE) {
                editor.copy(element);
            } else if (action.getType() == ActionType.FORBID) {
                nac = ActionNACUtil.getOrCreateNAC(action, rule);
                editor = this.getMapEditor(nac.getConclusion());
                editor.move(element);
            }
        } else if (current.getType() == ActionType.DELETE) {
            MapEditor<E> editor = this.getMapEditor(rule.getRhs());
            if (action.getType() == ActionType.PRESERVE) {
                editor.copy(element);
            } else if (action.getType() == ActionType.CREATE) {
                editor.move(element);
            } else if (action.getType() == ActionType.FORBID) {
                nac = ActionNACUtil.getOrCreateNAC(action, rule);
                editor = this.getMapEditor(nac.getConclusion());
                editor.move(element);
            }
        } else if (current.getType() == ActionType.FORBID) {
            nac = (NestedCondition)graph.eContainer();
            MapEditor<E> editor = this.getMapEditor(nac.getConclusion());
            if (action.getType() != ActionType.FORBID) {
                editor.move(element);
            }
            if (action.getType() == ActionType.PRESERVE) {
                editor = this.getMapEditor(rule.getRhs());
                editor.copy(element);
            } else if (action.getType() == ActionType.CREATE) {
                editor = this.getMapEditor(rule.getRhs());
                editor.move(element);
            } else if (action.getType() == ActionType.FORBID) {
                NestedCondition newNac = ActionNACUtil.getOrCreateNAC(action, rule);
                editor = this.getMapEditor(newNac.getConclusion());
                editor.move(element);
            }
            if (HenshinNACUtil.isTrivialNAC((NestedCondition)nac)) {
                HenshinNACUtil.removeNAC((Rule)rule, (NestedCondition)nac);
            }
        }
        if (current.isAmalgamated() != action.isAmalgamated()) {
            Rule multi;
            if (action.isAmalgamated()) {
                multi = this.getOrCreateMultiRule(rule, action.getArguments());
                amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(rule);
            } else {
                multi = rule;
                amalgamation = AmalgamationEditHelper.getAmalgamationFromMultiRule(rule);
            }
            Rule kernel = amalgamation.getKernelRule();
            this.sanitizeMultiRule(multi, amalgamation);
            if (action.getType() == ActionType.CREATE) {
                this.getMapEditor(kernel.getRhs(), multi.getRhs(), (List<Mapping>)amalgamation.getRhsMappings()).move(element);
            } else if (action.getType() == ActionType.DELETE) {
                this.getMapEditor(kernel.getLhs(), multi.getLhs(), (List<Mapping>)amalgamation.getLhsMappings()).move(element);
            } else if (action.getType() == ActionType.PRESERVE) {
                MappingMapEditor mappingEditor = new MappingMapEditor(kernel, multi, (List<Mapping>)amalgamation.getLhsMappings(), (List<Mapping>)amalgamation.getRhsMappings());
                mappingEditor.moveMappedElement(element);
            }
            AmalgamationEditHelper.cleanUpAmalagamation(amalgamation);
        }
        if (current.isAmalgamated() && action.isAmalgamated() && (newMulti = this.getOrCreateMultiRule((amalgamation = AmalgamationEditHelper.getAmalgamationFromMultiRule(rule)).getKernelRule(), action.getArguments())) != rule) {
            this.sanitizeMultiRule(newMulti, amalgamation);
            if (action.getType() == ActionType.CREATE) {
                this.getMapEditor(rule.getRhs(), newMulti.getRhs(), null).move(element);
            } else if (action.getType() == ActionType.DELETE) {
                this.getMapEditor(rule.getLhs(), newMulti.getLhs(), null).move(element);
            } else if (action.getType() == ActionType.PRESERVE) {
                MappingMapEditor mappingEditor = new MappingMapEditor(rule, newMulti, null, null);
                mappingEditor.moveMappedElement(element);
            }
            AmalgamationEditHelper.cleanUpAmalagamation(amalgamation);
        }
    }

    private void sanitizeMultiRule(Rule multi, AmalgamationUnit amalgamation) {
        MappingMapEditor mappingEditor = new MappingMapEditor(amalgamation.getKernelRule(), multi, (List<Mapping>)amalgamation.getLhsMappings(), (List<Mapping>)amalgamation.getRhsMappings());
        mappingEditor.ensureCompleteness();
    }

    protected Graph getGraph(E e) {
        EObject current = e.eContainer();
        while (current != null) {
            if (current instanceof Graph) {
                return (Graph)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    protected boolean isNAC(Graph graph) {
        return graph.eContainer() instanceof NestedCondition;
    }

    protected abstract MapEditor<E> getMapEditor(Graph var1);

    protected abstract MapEditor<E> getMapEditor(Graph var1, Graph var2, List<Mapping> var3);

    protected List<E> filterElementsByAction(List<E> elements, Action action) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject element : elements) {
            Action current = this.getAction((E)element);
            if (current == null || action != null && !action.equals(current)) continue;
            result.add(element);
        }
        return result;
    }

    private boolean isAmalgamated(E element, AmalgamationUnit amalgamation) {
        if (amalgamation != null && element instanceof GraphElement) {
            try {
                return AmalgamationEditHelper.getPreimageInKernelRule((GraphElement)element, amalgamation) == null;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return false;
    }

    private String[] getAmalgamationParameters(E element, Rule multiRule, AmalgamationUnit amalgamation) {
        if (!this.isAmalgamated(element, amalgamation)) {
            return new String[0];
        }
        String name = AmalgamationEditHelper.getMultiRuleName(multiRule, amalgamation);
        if (name == null || name.length() == 0) {
            return new String[0];
        }
        return new String[]{name};
    }

    private Rule getOrCreateMultiRule(Rule kernel, String[] actionArguments) {
        Rule multiRule;
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(kernel);
        if (amalgamation == null) {
            amalgamation = HenshinFactory.eINSTANCE.createAmalgamationUnit();
            amalgamation.setName(kernel.getName());
            amalgamation.setKernelRule(kernel);
            kernel.getTransformationSystem().getTransformationUnits().add((Object)amalgamation);
        }
        if (actionArguments.length == 0) {
            multiRule = AmalgamationEditHelper.getDefaultMultiRule(kernel);
            if (multiRule == null) {
                multiRule = AmalgamationEditHelper.createDefaultMultiRule(amalgamation);
            }
        } else {
            String name = actionArguments[0].trim();
            multiRule = AmalgamationEditHelper.getMultiRule(kernel, name);
            if (multiRule == null) {
                multiRule = AmalgamationEditHelper.createMultiRule(amalgamation, name);
            }
        }
        return multiRule;
    }
}

