/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;
import org.eclipse.emf.henshin.statespace.properties.ParametersPropertiesManager;

public class TransitionImpl
extends StorageImpl
implements Transition {
    protected State target;
    protected Rule rule;
    protected static final int MATCH_EDEFAULT = 0;
    protected static final int PARAMETER_COUNT_EDEFAULT = 0;
    protected static final int[] PARAMETER_IDS_EDEFAULT = null;

    @Override
    public String getLabel() {
        if (this.rule == null) {
            return null;
        }
        String label = this.rule.getName();
        if (this.getParameterCount() > 0) {
            label = String.valueOf(label) + "(";
            char[] prefixes = this.getParamPrefixes();
            int[] params = this.getParameterIDs();
            int count = Math.min(prefixes.length, params.length);
            int i = 0;
            while (i < count) {
                label = String.valueOf(label) + prefixes[i] + params[i];
                if (i < count - 1) {
                    label = String.valueOf(label) + ",";
                }
                ++i;
            }
            label = String.valueOf(label) + ")";
        }
        return label;
    }

    private char[] getParamPrefixes() {
        List<Node> nodes;
        if (this.getSource() == null || this.getSource().getStateSpace() == null) {
            return new char[0];
        }
        try {
            nodes = ParametersPropertiesManager.getParameters(this.getSource().getStateSpace(), this.rule);
        }
        catch (StateSpaceException e) {
            throw new RuntimeException(e);
        }
        char[] prefixes = new char[nodes.size()];
        int i = 0;
        while (i < prefixes.length) {
            EClass type = nodes.get(i).getType();
            prefixes[i] = type != null && type.getName() != null ? type.getName().toLowerCase().charAt(0) : (char)120;
            ++i;
        }
        return prefixes;
    }

    @Override
    public int getMatch() {
        return this.getData(0);
    }

    @Override
    public void setMatch(int match) {
        this.setData(0, match);
    }

    @Override
    public int getParameterCount() {
        return this.getData(1);
    }

    @Override
    public void setParameterCount(int paramCount) {
        this.setData(1, paramCount);
    }

    @Override
    public int[] getParameterIDs() {
        return this.getData(2, 2 + this.getParameterCount());
    }

    @Override
    public void setParameterIDs(int[] paramIDs) {
        this.setData(2, paramIDs);
    }

    @Override
    public String toString() {
        if (this.getSource() != null && this.target != null && this.rule != null) {
            return String.valueOf(this.getSource().getIndex()) + " -- " + this.getLabel() + " -> " + this.target.getIndex();
        }
        return super.toString();
    }

    protected TransitionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return StateSpacePackage.Literals.TRANSITION;
    }

    @Override
    public State getSource() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (State)this.eContainer();
    }

    public NotificationChain basicSetSource(State newSource, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newSource, 1, msgs);
        return msgs;
    }

    @Override
    public void setSource(State newSource) {
        if (newSource != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newSource != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newSource)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newSource != null) {
                msgs = ((InternalEObject)newSource).eInverseAdd((InternalEObject)this, 3, State.class, msgs);
            }
            if ((msgs = this.basicSetSource(newSource, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newSource, (Object)newSource));
        }
    }

    @Override
    public State getTarget() {
        if (this.target != null && this.target.eIsProxy()) {
            InternalEObject oldTarget = (InternalEObject)this.target;
            this.target = (State)this.eResolveProxy(oldTarget);
            if (this.target != oldTarget && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldTarget, (Object)this.target));
            }
        }
        return this.target;
    }

    public State basicGetTarget() {
        return this.target;
    }

    public NotificationChain basicSetTarget(State newTarget, NotificationChain msgs) {
        State oldTarget = this.target;
        this.target = newTarget;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldTarget, (Object)newTarget);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTarget(State newTarget) {
        if (newTarget != this.target) {
            NotificationChain msgs = null;
            if (this.target != null) {
                msgs = ((InternalEObject)this.target).eInverseRemove((InternalEObject)this, 2, State.class, msgs);
            }
            if (newTarget != null) {
                msgs = ((InternalEObject)newTarget).eInverseAdd((InternalEObject)this, 2, State.class, msgs);
            }
            if ((msgs = this.basicSetTarget(newTarget, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newTarget, (Object)newTarget));
        }
    }

    @Override
    public Rule getRule() {
        if (this.rule != null && this.rule.eIsProxy()) {
            InternalEObject oldRule = (InternalEObject)this.rule;
            this.rule = (Rule)this.eResolveProxy(oldRule);
            if (this.rule != oldRule && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldRule, (Object)this.rule));
            }
        }
        return this.rule;
    }

    public Rule basicGetRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule newRule) {
        Rule oldRule = this.rule;
        this.rule = newRule;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldRule, (Object)this.rule));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetSource((State)otherEnd, msgs);
            }
            case 2: {
                if (this.target != null) {
                    msgs = ((InternalEObject)this.target).eInverseRemove((InternalEObject)this, 2, State.class, msgs);
                }
                return this.basicSetTarget((State)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetSource(null, msgs);
            }
            case 2: {
                return this.basicSetTarget(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 3, State.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getSource();
            }
            case 2: {
                if (resolve) {
                    return this.getTarget();
                }
                return this.basicGetTarget();
            }
            case 3: {
                if (resolve) {
                    return this.getRule();
                }
                return this.basicGetRule();
            }
            case 4: {
                return this.getMatch();
            }
            case 5: {
                return this.getParameterCount();
            }
            case 6: {
                return this.getParameterIDs();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setSource((State)newValue);
                return;
            }
            case 2: {
                this.setTarget((State)newValue);
                return;
            }
            case 3: {
                this.setRule((Rule)newValue);
                return;
            }
            case 4: {
                this.setMatch((Integer)newValue);
                return;
            }
            case 5: {
                this.setParameterCount((Integer)newValue);
                return;
            }
            case 6: {
                this.setParameterIDs((int[])newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setSource(null);
                return;
            }
            case 2: {
                this.setTarget(null);
                return;
            }
            case 3: {
                this.setRule(null);
                return;
            }
            case 4: {
                this.setMatch(0);
                return;
            }
            case 5: {
                this.setParameterCount(0);
                return;
            }
            case 6: {
                this.setParameterIDs(PARAMETER_IDS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.getSource() != null;
            }
            case 2: {
                return this.target != null;
            }
            case 3: {
                return this.rule != null;
            }
            case 4: {
                return this.getMatch() != 0;
            }
            case 5: {
                return this.getParameterCount() != 0;
            }
            case 6: {
                return PARAMETER_IDS_EDEFAULT == null ? this.getParameterIDs() != null : !PARAMETER_IDS_EDEFAULT.equals(this.getParameterIDs());
            }
        }
        return super.eIsSet(featureID);
    }
}

