/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.equality;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.equality.EcoreEqualityHelper;
import org.eclipse.emf.henshin.statespace.equality.GraphTraversalHelper;
import org.eclipse.emf.henshin.statespace.hashcodes.HashCodeMap;

public class GraphEqualityHelper
extends HashMap<EObject, EObject> {
    private static final long serialVersionUID = 1L;
    private EcoreEqualityHelper attributeHelper;
    private boolean ignoreNodeIDs;
    private boolean ignoreAttributes;
    private Model model1;
    private Model model2;
    private Map<Integer, List<EObject>> slots1;
    private Map<Integer, List<EObject>> slots2;
    private HashCodeMap hashcodes1;
    private HashCodeMap hashcodes2;
    private GraphTraversalHelper traversalHelper;

    public GraphEqualityHelper(boolean ignoreNodeIDs, boolean ignoreAttributes) {
        this.ignoreNodeIDs = ignoreNodeIDs;
        this.ignoreAttributes = ignoreAttributes;
        this.attributeHelper = new EcoreEqualityHelper(ignoreNodeIDs, ignoreAttributes);
    }

    public boolean equals(Model model1, HashCodeMap map1, Model model2, HashCodeMap map2) {
        long time = System.currentTimeMillis();
        if (map1 == null || map2 == null) {
            this.hashcodes1 = HashCodeMap.ECLASS_HASH_CODE_MAP;
            this.hashcodes2 = HashCodeMap.ECLASS_HASH_CODE_MAP;
            StateSpacePlugin.INSTANCE.logWarning("Using EClass-based node comparison (very slow!)");
        } else {
            this.hashcodes1 = map1;
            this.hashcodes2 = map2;
        }
        this.slots1 = GraphEqualityHelper.generateSlots(model1, this.hashcodes1);
        this.slots2 = GraphEqualityHelper.generateSlots(model2, this.hashcodes2);
        if (!this.slots1.keySet().equals(this.slots2.keySet())) {
            this.slots1 = null;
            this.slots2 = null;
            return false;
        }
        this.model1 = model1;
        this.model2 = model2;
        this.traversalHelper = new GraphTraversalHelper(this.hashcodes1);
        this.clear();
        boolean result = this.matchFirst();
        this.slots1 = null;
        this.slots2 = null;
        this.hashcodes1 = null;
        this.hashcodes2 = null;
        this.model1 = null;
        this.model2 = null;
        this.traversalHelper = null;
        time = System.currentTimeMillis() - time;
        this.log("Equality check took " + time + "ms\n");
        return result;
    }

    private boolean matchFirst() {
        EObject[] candidates;
        EObject next = null;
        int hashcode = 0;
        if (next == null) {
            Map.Entry<Integer, List<EObject>> smallest = null;
            for (Map.Entry<Integer, List<EObject>> entry : this.slots1.entrySet()) {
                int elements = entry.getValue().size();
                if (elements <= 0 || smallest != null && elements >= smallest.getValue().size()) continue;
                smallest = entry;
            }
            if (smallest != null) {
                next = (EObject)((List)smallest.getValue()).get(0);
                hashcode = (Integer)smallest.getKey();
            }
        }
        if (next == null) {
            return true;
        }
        EObject[] eObjectArray = candidates = this.slots2.get(hashcode).toArray(new EObject[0]);
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            EObject candidate = eObjectArray[n2];
            if (this.match(next, candidate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean basicCanMatch(EObject o1, EObject o2) {
        EObject m1 = (EObject)this.get(o1);
        if (m1 != null && m1 != o2) {
            return false;
        }
        EObject m2 = (EObject)this.get(o2);
        if (m2 != null && m2 != o1) {
            return false;
        }
        if (this.hashcodes1.getHashCode(o1) != this.hashcodes2.getHashCode(o2)) {
            return false;
        }
        if (!this.ignoreNodeIDs && ((Integer)this.model1.getNodeIDsMap().get((Object)o1)).intValue() != ((Integer)this.model2.getNodeIDsMap().get((Object)o2)).intValue()) {
            return false;
        }
        if (!o1.eClass().equals(o2.eClass())) {
            return false;
        }
        if (!this.ignoreAttributes) {
            for (EAttribute attribute : o1.eClass().getEAllAttributes()) {
                if (this.attributeHelper.haveEqualAttribute(o1, o2, attribute)) continue;
                return false;
            }
        }
        for (EReference reference : this.traversalHelper.getReferences(o1)) {
            List<EObject> list1 = this.traversalHelper.getContents(o1, reference);
            List<EObject> list2 = this.traversalHelper.getContents(o2, reference);
            if (list1.size() != list2.size()) {
                return false;
            }
            for (EObject l1 : list1) {
                EObject l2 = (EObject)this.get(l1);
                if (l2 == null || list2.contains(l2)) continue;
                return false;
            }
            for (EObject l2 : list2) {
                EObject l1 = (EObject)this.get(l2);
                if (l1 == null || list1.contains(l1)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canMatch(EObject o1, EObject o2) {
        if (!this.basicCanMatch(o1, o2)) {
            return false;
        }
        for (EReference reference : this.traversalHelper.getReferences(o1)) {
            List<EObject> list1 = this.traversalHelper.getContents(o1, reference);
            List<EObject> list2 = this.traversalHelper.getContents(o2, reference);
            for (EObject l1 : list1) {
                boolean canMatch = false;
                for (EObject l2 : list2) {
                    if (!this.basicCanMatch(l1, l2)) continue;
                    canMatch = true;
                    break;
                }
                if (canMatch) continue;
                return false;
            }
        }
        return true;
    }

    private boolean match(EObject o1, EObject o2) {
        if (!this.canMatch(o1, o2)) {
            this.log("Cannot match " + o1 + " with " + o2);
            return false;
        }
        if (this.containsKey(o1)) {
            return this.matchFirst();
        }
        this.doMatch(o1, o2);
        for (EReference reference : this.traversalHelper.getReferences(o1)) {
            EObject l1 = null;
            for (EObject current : this.traversalHelper.getContents(o1, reference)) {
                if (this.containsKey(current)) continue;
                l1 = current;
                break;
            }
            if (l1 == null) continue;
            for (EObject l2 : this.traversalHelper.getContents(o2, reference)) {
                if (this.values().contains(l2) || !this.match(l1, l2) || !this.canMatch(o1, o2)) continue;
                return true;
            }
            this.doUnmatch(o1, o2);
            return false;
        }
        if (this.matchFirst()) {
            return true;
        }
        this.doUnmatch(o1, o2);
        return false;
    }

    private void doMatch(EObject o1, EObject o2) {
        this.log("Trying to match " + o1 + " with " + o2);
        this.put(o1, o2);
        this.put(o2, o1);
        Integer hash = (Integer)this.hashcodes1.get(o1);
        this.slots1.get(hash).remove(o1);
        this.slots2.get(hash).remove(o2);
    }

    private void doUnmatch(EObject o1, EObject o2) {
        this.remove(o1);
        this.remove(o2);
        Integer hash = (Integer)this.hashcodes1.get(o1);
        this.slots1.get(hash).add(o1);
        this.slots2.get(hash).add(o2);
        this.log("Aborting match  " + o1 + " with " + o2);
    }

    private void log(String message) {
    }

    private static Map<Integer, List<EObject>> generateSlots(Model model, HashCodeMap map) {
        LinkedHashMap<Integer, List<EObject>> slots = new LinkedHashMap<Integer, List<EObject>>();
        TreeIterator it = model.getResource().getAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            Integer hash = (Integer)map.get(next);
            ArrayList<EObject> objects = (ArrayList<EObject>)slots.get(hash);
            if (objects == null) {
                objects = new ArrayList<EObject>();
                slots.put(hash, objects);
            }
            objects.add(next);
        }
        return slots;
    }
}

