/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;

public class CreateEdgeCommand
extends AbstractCommand {
    protected Node source;
    protected Node target;
    protected EReference edgeType;
    protected Graph graph;
    protected Edge edge;

    public CreateEdgeCommand(Node source, Node target, EReference edgeType) {
        this.source = source;
        this.target = target;
        this.edgeType = edgeType;
    }

    protected boolean prepare() {
        this.graph = this.source.getGraph();
        return QuantUtil.noneNull(this.source, this.target, this.edgeType, this.graph);
    }

    public void execute() {
        this.edge = HenshinFactory.eINSTANCE.createEdge();
        this.edge.setType(this.edgeType);
        this.redo();
    }

    public void undo() {
        this.graph.getEdges().remove((Object)this.edge);
        this.edge.setSource(null);
        this.edge.setTarget(null);
    }

    public void redo() {
        this.graph.getEdges().add((Object)this.edge);
        this.edge.setSource(this.source);
        this.edge.setTarget(this.target);
    }

    public Collection<?> getAffectedObjects() {
        return Collections.singleton(this.edge);
    }
}

