/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.List;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class HenshinMappingUtil {
    public static Mapping getMapping(Node origin, Node image, List<Mapping> mappings) {
        for (Mapping mapping : mappings) {
            if (mapping.getOrigin() != origin || mapping.getImage() != image) continue;
            return mapping;
        }
        return null;
    }

    public static Mapping createMapping(Node origin, Node image) {
        Mapping mapping = HenshinFactory.eINSTANCE.createMapping();
        mapping.setOrigin(origin);
        mapping.setImage(image);
        return mapping;
    }

    public static Mapping createMapping(Node origin, Node image, List<Mapping> mappings) {
        Mapping mapping = HenshinMappingUtil.getMapping(origin, image, mappings);
        if (mapping == null) {
            mapping = HenshinMappingUtil.createMapping(origin, image);
            mappings.add(mapping);
        }
        return mapping;
    }

    public static Mapping removeMapping(Node origin, Node image, List<Mapping> mappings) {
        Mapping mapping = HenshinMappingUtil.getMapping(origin, image, mappings);
        if (mapping != null) {
            mappings.remove(mapping);
        }
        return mapping;
    }

    public static List<Mapping> getRuleMappings(Graph imageGraph) {
        Rule rule = imageGraph.getContainerRule();
        if (rule == null) {
            throw new IllegalArgumentException("Graph not contained in a rule");
        }
        if (imageGraph == rule.getRhs()) {
            return rule.getMappings();
        }
        NestedCondition nested = (NestedCondition)imageGraph.eContainer();
        return nested.getMappings();
    }

    public static Node getNodeImage(Node origin, Graph targetGraph, List<Mapping> mappings) {
        Mapping mapping = HenshinMappingUtil.getNodeImageMapping(origin, targetGraph, mappings);
        return mapping != null ? mapping.getImage() : null;
    }

    public static Node getNodeOrigin(Node image, List<Mapping> mappings) {
        Mapping mapping = HenshinMappingUtil.getNodeOriginMapping(image, mappings);
        return mapping != null ? mapping.getOrigin() : null;
    }

    public static Mapping getNodeImageMapping(Node origin, Graph targetGraph, List<Mapping> mappings) {
        for (Mapping mapping : mappings) {
            if (mapping.getOrigin() != origin || mapping.getImage().getGraph() != targetGraph) continue;
            return mapping;
        }
        return null;
    }

    public static Mapping getNodeOriginMapping(Node image, List<Mapping> mappings) {
        for (Mapping mapping : mappings) {
            if (mapping.getImage() != image) continue;
            return mapping;
        }
        return null;
    }

    public static Edge getEdgeImage(Edge edge, Graph targetGraph, List<Mapping> mappings) {
        if (edge.getSource() == null || edge.getTarget() == null) {
            return null;
        }
        Node source = HenshinMappingUtil.getNodeImage(edge.getSource(), targetGraph, mappings);
        Node target = HenshinMappingUtil.getNodeImage(edge.getTarget(), targetGraph, mappings);
        if (source == null || target == null) {
            return null;
        }
        return source.findOutgoingEdgeByType(target, edge.getType());
    }

    public static Edge getEdgeOrigin(Edge edge, List<Mapping> mappings) {
        if (edge.getSource() == null || edge.getTarget() == null) {
            return null;
        }
        Node source = HenshinMappingUtil.getNodeOrigin(edge.getSource(), mappings);
        Node target = HenshinMappingUtil.getNodeOrigin(edge.getTarget(), mappings);
        if (source == null || target == null) {
            return null;
        }
        return source.findOutgoingEdgeByType(target, edge.getType());
    }

    public static Attribute getAttributeImage(Attribute attribute, Graph targetGraph, List<Mapping> mappings) {
        if (attribute.getNode() == null) {
            return null;
        }
        Node nodeImage = HenshinMappingUtil.getNodeImage(attribute.getNode(), targetGraph, mappings);
        if (nodeImage == null) {
            return null;
        }
        return nodeImage.findAttributeByType(attribute.getType());
    }

    public static Attribute getAttributeOrigin(Attribute attribute, List<Mapping> mappings) {
        if (attribute.getNode() == null) {
            return null;
        }
        Node nodeOrigin = HenshinMappingUtil.getNodeOrigin(attribute.getNode(), mappings);
        if (nodeOrigin == null) {
            return null;
        }
        return nodeOrigin.findAttributeByType(attribute.getType());
    }

    public static <T> T getImage(T element, Graph target, List<Mapping> mappings) {
        if (element instanceof Node) {
            return (T)HenshinMappingUtil.getNodeImage((Node)element, target, mappings);
        }
        if (element instanceof Edge) {
            return (T)HenshinMappingUtil.getEdgeImage((Edge)element, target, mappings);
        }
        if (element instanceof Attribute) {
            return (T)HenshinMappingUtil.getAttributeImage((Attribute)element, target, mappings);
        }
        throw new IllegalArgumentException();
    }

    public static <T> T getOrigin(T element, List<Mapping> mappings) {
        if (element instanceof Node) {
            return (T)HenshinMappingUtil.getNodeOrigin((Node)element, mappings);
        }
        if (element instanceof Edge) {
            return (T)HenshinMappingUtil.getEdgeOrigin((Edge)element, mappings);
        }
        if (element instanceof Attribute) {
            return (T)HenshinMappingUtil.getAttributeOrigin((Attribute)element, mappings);
        }
        throw new IllegalArgumentException();
    }

    public static void removeInvalidMappings(List<Mapping> mappings, Graph source, Graph target) {
        int i = 0;
        while (i < mappings.size()) {
            Mapping mapping = mappings.get(i);
            if (mapping.getOrigin().getGraph() != source || mapping.getImage().getGraph() != target) {
                mappings.remove(i--);
            }
            ++i;
        }
    }
}

