/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;

public class RecordingCommandTest
extends AbstractTest {
    public static Test suite() {
        return new TestSuite(RecordingCommandTest.class, "Recording Command Tests");
    }

    public void testPrePostDoExecute() {
        TransactionalEditingDomain domain = this.createEditingDomain((ResourceSet)new ResourceSetImpl());
        _RecordingCommand cmd = new _RecordingCommand(domain);
        domain.getCommandStack().execute((Command)cmd);
        RecordingCommandTest.assertEquals((int)1, (int)cmd.preExecuteCalled);
        RecordingCommandTest.assertEquals((int)2, (int)cmd.doExecuteCalled);
        RecordingCommandTest.assertEquals((int)3, (int)cmd.postExecuteCalled);
    }

    private final class _RecordingCommand
    extends RecordingCommand {
        public int preExecuteCalled;
        public int doExecuteCalled;
        public int postExecuteCalled;
        private int counter;

        private _RecordingCommand(TransactionalEditingDomain domain) {
            super(domain);
            this.preExecuteCalled = 0;
            this.doExecuteCalled = 0;
            this.postExecuteCalled = 0;
            this.counter = 0;
        }

        protected void preExecute() {
            this.preExecuteCalled = ++this.counter;
        }

        protected void doExecute() {
            this.doExecuteCalled = ++this.counter;
        }

        protected void postExecute() {
            this.postExecuteCalled = ++this.counter;
        }
    }
}

