/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.rental.impl;

import java.util.Date;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.teneo.rental.Currency;
import org.eclipse.emf.teneo.rental.Manufacturer;
import org.eclipse.emf.teneo.rental.RentalBicycle;
import org.eclipse.emf.teneo.rental.RentalBicycleType;
import org.eclipse.emf.teneo.rental.RentalCar;
import org.eclipse.emf.teneo.rental.RentalCarSize;
import org.eclipse.emf.teneo.rental.RentalContract;
import org.eclipse.emf.teneo.rental.RentalFactory;
import org.eclipse.emf.teneo.rental.RentalPackage;
import org.eclipse.emf.teneo.rental.impl.CurrencyImpl;
import org.eclipse.emf.teneo.rental.impl.ManufacturerImpl;
import org.eclipse.emf.teneo.rental.impl.RentalBicycleImpl;
import org.eclipse.emf.teneo.rental.impl.RentalCarImpl;
import org.eclipse.emf.teneo.rental.impl.RentalContractImpl;

public class RentalFactoryImpl
extends EFactoryImpl
implements RentalFactory {
    public static RentalFactory init() {
        try {
            RentalFactory theRentalFactory = (RentalFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/teneo/rental");
            if (theRentalFactory != null) {
                return theRentalFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RentalFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createRentalBicycle();
            }
            case 1: {
                return this.createCurrency();
            }
            case 2: {
                return this.createRentalCar();
            }
            case 3: {
                return this.createRentalContract();
            }
            case 5: {
                return this.createManufacturer();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createRentalBicycleTypeFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createRentalCarSizeFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createDateFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createRentalBicycleTypeObjectFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createRentalCarSizeObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertRentalBicycleTypeToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertRentalCarSizeToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertDateToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertRentalBicycleTypeObjectToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertRentalCarSizeObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public RentalBicycle createRentalBicycle() {
        RentalBicycleImpl rentalBicycle = new RentalBicycleImpl();
        return rentalBicycle;
    }

    public Currency createCurrency() {
        CurrencyImpl currency = new CurrencyImpl();
        return currency;
    }

    public RentalCar createRentalCar() {
        RentalCarImpl rentalCar = new RentalCarImpl();
        return rentalCar;
    }

    public RentalContract createRentalContract() {
        RentalContractImpl rentalContract = new RentalContractImpl();
        return rentalContract;
    }

    public Manufacturer createManufacturer() {
        ManufacturerImpl manufacturer = new ManufacturerImpl();
        return manufacturer;
    }

    public RentalBicycleType createRentalBicycleTypeFromString(EDataType eDataType, String initialValue) {
        RentalBicycleType result = RentalBicycleType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRentalBicycleTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RentalCarSize createRentalCarSizeFromString(EDataType eDataType, String initialValue) {
        RentalCarSize result = RentalCarSize.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRentalCarSizeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Date createDateFromString(EDataType eDataType, String initialValue) {
        return (Date)super.createFromString(eDataType, initialValue);
    }

    public String convertDateToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public RentalBicycleType createRentalBicycleTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createRentalBicycleTypeFromString((EDataType)RentalPackage.Literals.RENTAL_BICYCLE_TYPE, initialValue);
    }

    public String convertRentalBicycleTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertRentalBicycleTypeToString((EDataType)RentalPackage.Literals.RENTAL_BICYCLE_TYPE, instanceValue);
    }

    public RentalCarSize createRentalCarSizeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createRentalCarSizeFromString((EDataType)RentalPackage.Literals.RENTAL_CAR_SIZE, initialValue);
    }

    public String convertRentalCarSizeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertRentalCarSizeToString((EDataType)RentalPackage.Literals.RENTAL_CAR_SIZE, instanceValue);
    }

    public RentalPackage getRentalPackage() {
        return (RentalPackage)this.getEPackage();
    }

    @Deprecated
    public static RentalPackage getPackage() {
        return RentalPackage.eINSTANCE;
    }
}

