/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.property;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.AbstractMapper;
import org.eclipse.emf.teneo.simpledom.DocumentHelper;
import org.eclipse.emf.teneo.simpledom.Element;

public class ColumnMapper
extends AbstractMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(ColumnMapper.class);

    public void map(Column column, Element fieldElement) {
        log.debug((Object)"Adding column element");
        Element columnElement = DocumentHelper.createElement((String)"column");
        if (column.getName() != null && column.getName().length() > 0) {
            columnElement.addAttribute("name", column.getName());
        }
        if (column.isNullable()) {
            log.debug((Object)"Allows null");
            columnElement.addAttribute("allows-null", "true");
        } else {
            columnElement.addAttribute("allows-null", "false");
        }
        if (column.isSetLength()) {
            log.debug((Object)("Set length " + column.getLength()));
            columnElement.addAttribute("length", Integer.toString(column.getLength()));
        }
        if (column.isSetPrecision()) {
            log.debug((Object)("Set precision (using length attribute) " + column.getPrecision()));
            columnElement.addAttribute("length", Integer.toString(column.getPrecision()));
        }
        if (column.isSetScale()) {
            log.debug((Object)("Set scale " + column.getScale()));
            columnElement.addAttribute("scale", Integer.toString(column.getScale()));
        }
        if (column.isUnique()) {
            fieldElement.add(columnElement);
            Element unique = fieldElement.addElement("unique");
            unique.add((Element)columnElement.clone());
        } else {
            fieldElement.add(columnElement);
        }
        if (column.getTable() != null) {
            fieldElement.addAttribute("table", column.getTable());
        }
    }
}

