/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.InternallyAcyclicPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;

public class RootPartition
implements InternallyAcyclicPartition {
    protected final @NonNull String name;
    protected final @NonNull Iterable<@NonNull Partition> partitions;
    protected final @NonNull Map<@NonNull Partition, @NonNull Set<@NonNull Partition>> partition2predecessors;
    protected final @NonNull Set<@NonNull TraceClassAnalysis<@NonNull Partition>> cyclicTraceClassAnalyses;
    protected final @NonNull Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> cyclicTracePropertyAnalyses;
    private @Nullable ScheduledRegion scheduledRegion = null;
    private @Nullable List<@NonNull Iterable<@NonNull Partition>> partitionSchedule = null;
    private @Nullable List<@NonNull Collection<@NonNull Region>> regionSchedule = null;

    public RootPartition(@NonNull String name, @NonNull Map<@NonNull Partition, @NonNull Set<@NonNull Partition>> partition2predecessors, @NonNull Set<@NonNull TraceClassAnalysis<@NonNull Partition>> cyclicTraceClassAnalyses, @NonNull Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> cyclicTracePropertyAnalyses) {
        this.name = name;
        this.partitions = partition2predecessors.keySet();
        this.partition2predecessors = partition2predecessors;
        this.cyclicTraceClassAnalyses = cyclicTraceClassAnalyses;
        this.cyclicTracePropertyAnalyses = cyclicTracePropertyAnalyses;
    }

    @Override
    public @NonNull List<@NonNull Iterable<@NonNull Partition>> getPartitionSchedule() {
        List<@NonNull Iterable<@NonNull Partition>> partitionSchedule2 = this.partitionSchedule;
        if (partitionSchedule2 == null) {
            this.partitionSchedule = partitionSchedule2 = CompilerUtil.computeParallelSchedule(this.partition2predecessors);
            for (Partition partition : this.partitions) {
                if (!(partition instanceof InternallyAcyclicPartition)) continue;
                ((InternallyAcyclicPartition)((Object)partition)).getPartitionSchedule();
            }
        }
        return partitionSchedule2;
    }

    @Override
    public @NonNull Iterable<@NonNull Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public @NonNull List<@NonNull Collection<@NonNull Region>> getRegionSchedule() {
        List<@NonNull Collection<@NonNull Region>> regionSchedule2 = this.regionSchedule;
        if (regionSchedule2 == null) {
            this.regionSchedule = regionSchedule2 = new ArrayList<Collection<Region>>();
            assert (this.scheduledRegion != null);
            LoadingRegion loadingRegion = this.scheduledRegion.getOwnedLoadingRegion();
            if (loadingRegion != null) {
                regionSchedule2.add(Lists.newArrayList((Object[])new Region[]{loadingRegion}));
            }
            for (Iterable<Partition> concurrentPartitions : this.getPartitionSchedule()) {
                ArrayList<@NonNull MappingRegion> concurrentRegions = new ArrayList<MappingRegion>();
                for (Partition partition : concurrentPartitions) {
                    Region partitionRegion = partition.getRegion();
                    if (partition instanceof CyclicPartition) {
                        for (MappingRegion mappingRegion : ((CyclicPartition)partition).createMicroMappingRegions(partitionRegion)) {
                            this.getScheduledRegion().getMappingRegions().add((Object)mappingRegion);
                            concurrentRegions.add(mappingRegion);
                        }
                        continue;
                    }
                    int partitionNumber = partitionRegion.getNextPartitionNumber();
                    MappingRegion mappingRegion = partition.createMicroMappingRegion(partitionNumber);
                    this.getScheduledRegion().getMappingRegions().add((Object)mappingRegion);
                    concurrentRegions.add(mappingRegion);
                }
                regionSchedule2.add(concurrentRegions);
            }
        }
        return regionSchedule2;
    }

    public @NonNull ScheduledRegion getScheduledRegion() {
        return (ScheduledRegion)ClassUtil.nonNullState((Object)this.scheduledRegion);
    }

    @Override
    public @NonNull Iterable<@NonNull TraceClassAnalysis<@NonNull Partition>> getTraceClassAnalyses() {
        return this.cyclicTraceClassAnalyses;
    }

    @Override
    public @NonNull Iterable<@NonNull TracePropertyAnalysis<@NonNull Partition>> getTracePropertyAnalyses() {
        return this.cyclicTracePropertyAnalyses;
    }

    public void setScheduledRegion(@NonNull ScheduledRegion scheduledRegion) {
        this.scheduledRegion = scheduledRegion;
    }

    public @NonNull String toString() {
        return this.name;
    }
}

