/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTBase.operations;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.AbstractQVTBaseOperations;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.QVTBaseMessages;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.TransformationOperations;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.TypedModelOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainOperations
extends AbstractQVTBaseOperations {
    public static DomainOperations INSTANCE = new DomainOperations();

    public boolean checkCheckableOrEnforceable(Domain domain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (domain.isIsCheckable() || domain.isIsEnforceable()) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)domain, context)};
        this.appendError(diagnostics, domain, QVTBaseMessages._UI_Domain_IsNotCheckableOrEnforceable, messageSubstitutions);
        return false;
    }

    public boolean checkTypedModelExistsWarning(Domain domain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        TypedModel typedModel = domain.getTypedModel();
        if (typedModel != null) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)domain, context)};
        this.appendWarning(diagnostics, domain, QVTBaseMessages._UI_Domain_TypedModelDoesNotExistWarning, messageSubstitutions);
        return false;
    }

    public boolean checkTypedModelDefinedByTransformation(Domain domain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Transformation transformation = domain.getRule().getTransformation();
        TypedModel typedModel = domain.getTypedModel();
        if (typedModel == null) {
            return true;
        }
        if (TransformationOperations.INSTANCE.definesModel(transformation, typedModel)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)typedModel, context), this.getObjectLabel((EObject)domain, context), this.getObjectLabel((EObject)transformation, context)};
        this.appendError(diagnostics, domain, QVTBaseMessages._UI_Domain_TypedModelIsNotDefinedByTransformation, messageSubstitutions);
        return false;
    }

    public boolean declaresType(Domain domain, EClassifier type) {
        return this.isPredefinedType(type) || this.getDeclaredPackages(domain).contains(type.getEPackage());
    }

    public Set<EPackage> getDeclaredPackages(Domain domain) {
        TypedModel typedModel = domain.getTypedModel();
        if (typedModel != null) {
            return TypedModelOperations.INSTANCE.getDeclaredPackages(typedModel);
        }
        return new HashSet<EPackage>();
    }
}

