/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SuperRegion;

public abstract class AbstractMappingRegion
extends AbstractRegion
implements MappingRegion {
    private @Nullable List<@NonNull Node> headNodes = null;

    protected AbstractMappingRegion(@NonNull SuperRegion superRegion) {
        super(superRegion);
    }

    protected void addHeadNode(@NonNull Node headNode) {
        this.getHeadNodes().add(headNode);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull List<@NonNull Node> computeHeadNodes() {
        Object targetClosure;
        ArrayList<@NonNull Node> headNodeGroups = new ArrayList<Node>();
        Iterable<@NonNull Node> navigableNodes = this.getNavigableNodes();
        HashMap<@NonNull Node, @NonNull Iterator<@NonNull K>> source2targetClosure = new HashMap();
        for (Node navigableNode : navigableNodes) {
            if (navigableNode.isAttributeNode()) continue;
            Class type = navigableNode.getCompleteClass().getPrimaryClass();
            if (type instanceof CollectionType) {
                System.err.println("No head created for CollectionType " + type + " in " + this);
                continue;
            }
            targetClosure = new HashSet();
            source2targetClosure.put(navigableNode, targetClosure);
            targetClosure.add(navigableNode);
            for (Edge edge : navigableNode.getNavigationEdges()) {
                if (edge.isRealized()) continue;
                targetClosure.add(edge.getTarget());
            }
            for (Edge edge : navigableNode.getComputationEdges()) {
                targetClosure.add(edge.getSource());
            }
        }
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (Node sourceNode : navigableNodes) {
                targetClosure = (Set)source2targetClosure.get(sourceNode);
                if (targetClosure == null) continue;
                for (Node node : new ArrayList(targetClosure)) {
                    Set nextTargetClosure = (Set)source2targetClosure.get(node);
                    if (nextTargetClosure == null || !targetClosure.addAll(nextTargetClosure)) continue;
                    isChanged = true;
                }
            }
        }
        final HashMap<@NonNull Node, @NonNull HashSet<@NonNull E>> target2sourceClosure = new HashMap();
        for (Node targetNode : navigableNodes) {
            HashSet<@NonNull Node> hashSet = new HashSet<Node>();
            target2sourceClosure.put(targetNode, hashSet);
            hashSet.add(targetNode);
        }
        for (Node sourceNode : source2targetClosure.keySet()) {
            @NonNull Set set = (Set)source2targetClosure.get(sourceNode);
            assert (set != null);
            for (Node targetNode : set) {
                @NonNull Set sourceClosure2 = (Set)target2sourceClosure.get(targetNode);
                if (sourceClosure2 == null) continue;
                sourceClosure2.add(sourceNode);
            }
        }
        ArrayList<@NonNull E> headLessNodes = new ArrayList();
        Iterables.addAll(headLessNodes, source2targetClosure.keySet());
        Collections.sort(headLessNodes, new Comparator<Node>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public int compare(@NonNull Node o1, @NonNull Node o2) {
                int l2;
                @NonNull Set set1 = (Set)target2sourceClosure.get(o1);
                @NonNull Set set2 = (Set)target2sourceClosure.get(o2);
                if (!($assertionsDisabled || set1 != null && set2 != null)) {
                    throw new AssertionError();
                }
                int l1 = set1.size();
                int diff = l1 - (l2 = set2.size());
                if (diff != 0) {
                    return diff;
                }
                for (NavigationEdge e : o1.getNavigationEdges()) {
                    if (e.getTarget() != o2) continue;
                    return e.getProperty().isIsImplicit() ? 1 : -1;
                }
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        while (!headLessNodes.isEmpty()) {
            Node headNode = (Node)headLessNodes.remove(0);
            assert (headNode != null);
            @NonNull Set set = (Set)target2sourceClosure.get(headNode);
            assert (set != null);
            @NonNull Set targetClosure3 = (Set)source2targetClosure.get(headNode);
            assert (targetClosure3 != null);
            ArrayList<@NonNull Node> headGroup = new ArrayList<Node>();
            headNode.setHead();
            assert (!headGroup.contains(headNode));
            headGroup.add(headNode);
            int i = 0;
            while (i < headLessNodes.size()) {
                Node nextNode = (Node)headLessNodes.get(i);
                assert (nextNode != null);
                @NonNull Set nextClosure = (Set)target2sourceClosure.get(nextNode);
                assert (nextClosure != null);
                if (nextClosure.size() > set.size()) break;
                if (nextClosure.equals(set)) {
                    assert (!headGroup.contains(nextNode));
                    headGroup.add(nextNode);
                    headLessNodes.remove(nextNode);
                }
                ++i;
            }
            headLessNodes.removeAll(targetClosure3);
            targetClosure3.removeAll(headGroup);
            Node bestHeadNode = this.selectBestHeadNode(headGroup);
            assert (!headNodeGroups.contains(bestHeadNode));
            headNodeGroups.add(bestHeadNode);
        }
        return headNodeGroups;
    }

    @Override
    public @NonNull List<@NonNull Node> getHeadNodes() {
        List<@NonNull Node> headNodes2 = this.headNodes;
        if (headNodes2 == null) {
            this.headNodes = headNodes2 = this.computeHeadNodes();
        }
        return headNodes2;
    }
}

