/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.trace.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.SourceElementList;
import org.eclipse.m2m.atl.emftvm.trace.TraceLink;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;
import org.eclipse.m2m.atl.emftvm.trace.TracedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracedRuleImpl
extends EObjectImpl
implements TracedRule {
    protected static final String RULE_EDEFAULT = null;
    protected String rule = RULE_EDEFAULT;
    protected EList<TraceLink> links;
    protected EList<SourceElement> uniqueSourceElements;
    protected EList<SourceElementList> uniqueSourceElementLists;
    protected final Map<EObject, SourceElement> uniqueSourceObjects = new HashMap<EObject, SourceElement>();
    protected final Map<List<EObject>, SourceElementList> uniqueSourceObjectLists = new HashMap<List<EObject>, SourceElementList>();

    protected TracedRuleImpl() {
    }

    protected EClass eStaticClass() {
        return TracePackage.Literals.TRACED_RULE;
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    @Override
    public void setRule(String newRule) {
        String oldRule = this.rule;
        this.rule = newRule;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldRule, (Object)this.rule));
        }
    }

    @Override
    public EList<TraceLink> getLinks() {
        if (this.links == null) {
            this.links = new EObjectContainmentWithInverseEList(TraceLink.class, (InternalEObject)this, 1, 2);
        }
        return this.links;
    }

    @Override
    public TraceLinkSet getLinkSet() {
        if (this.eContainerFeatureID() != 2) {
            return null;
        }
        return (TraceLinkSet)this.eContainer();
    }

    public NotificationChain basicSetLinkSet(TraceLinkSet newLinkSet, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newLinkSet, 2, msgs);
        return msgs;
    }

    @Override
    public void setLinkSet(TraceLinkSet newLinkSet) {
        if (newLinkSet != this.eInternalContainer() || this.eContainerFeatureID() != 2 && newLinkSet != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newLinkSet)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newLinkSet != null) {
                msgs = ((InternalEObject)newLinkSet).eInverseAdd((InternalEObject)this, 0, TraceLinkSet.class, msgs);
            }
            if ((msgs = this.basicSetLinkSet(newLinkSet, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newLinkSet, (Object)newLinkSet));
        }
    }

    @Override
    public EList<SourceElement> getUniqueSourceElements() {
        if (this.uniqueSourceElements == null) {
            this.uniqueSourceElements = new EObjectWithInverseResolvingEList(SourceElement.class, (InternalEObject)this, 3, 5);
        }
        return this.uniqueSourceElements;
    }

    @Override
    public EList<SourceElementList> getUniqueSourceElementLists() {
        if (this.uniqueSourceElementLists == null) {
            this.uniqueSourceElementLists = new EObjectContainmentWithInverseEList(SourceElementList.class, (InternalEObject)this, 4, 2);
        }
        return this.uniqueSourceElementLists;
    }

    @Override
    public SourceElement getUniqueSourceElement(EObject sourceElement) {
        return this.uniqueSourceObjects.get(sourceElement);
    }

    @Override
    public SourceElementList getUniqueSourceElements(List<?> sourceElements) {
        return this.uniqueSourceObjectLists.get(sourceElements);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getLinks()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetLinkSet((TraceLinkSet)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getUniqueSourceElements()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getUniqueSourceElementLists()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getLinks()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return this.basicSetLinkSet(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getUniqueSourceElements()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getUniqueSourceElementLists()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 0, TraceLinkSet.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getRule();
            }
            case 1: {
                return this.getLinks();
            }
            case 2: {
                return this.getLinkSet();
            }
            case 3: {
                return this.getUniqueSourceElements();
            }
            case 4: {
                return this.getUniqueSourceElementLists();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setRule((String)newValue);
                return;
            }
            case 1: {
                this.getLinks().clear();
                this.getLinks().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setLinkSet((TraceLinkSet)newValue);
                return;
            }
            case 3: {
                this.getUniqueSourceElements().clear();
                this.getUniqueSourceElements().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getUniqueSourceElementLists().clear();
                this.getUniqueSourceElementLists().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setRule(RULE_EDEFAULT);
                return;
            }
            case 1: {
                this.getLinks().clear();
                return;
            }
            case 2: {
                this.setLinkSet(null);
                return;
            }
            case 3: {
                this.getUniqueSourceElements().clear();
                return;
            }
            case 4: {
                this.getUniqueSourceElementLists().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return RULE_EDEFAULT == null ? this.rule != null : !RULE_EDEFAULT.equals(this.rule);
            }
            case 1: {
                return this.links != null && !this.links.isEmpty();
            }
            case 2: {
                return this.getLinkSet() != null;
            }
            case 3: {
                return this.uniqueSourceElements != null && !this.uniqueSourceElements.isEmpty();
            }
            case 4: {
                return this.uniqueSourceElementLists != null && !this.uniqueSourceElementLists.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        return this.rule == null ? super.toString() : this.rule;
    }

    public boolean eNotificationRequired() {
        return true;
    }

    public void eNotify(Notification notification) {
        block20: {
            super.eNotify(notification);
            block0 : switch (notification.getFeatureID(null)) {
                case 3: {
                    switch (notification.getEventType()) {
                        case 3: {
                            this.uniqueSourceElementAdded((SourceElement)notification.getNewValue());
                            break;
                        }
                        case 5: {
                            for (SourceElement se : (Collection)notification.getNewValue()) {
                                this.uniqueSourceElementAdded(se);
                            }
                            break block0;
                        }
                        case 4: {
                            this.uniqueSourceElementRemoved((SourceElement)notification.getOldValue());
                            break;
                        }
                        case 6: {
                            for (SourceElement se : (Collection)notification.getOldValue()) {
                                this.uniqueSourceElementRemoved(se);
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    switch (notification.getEventType()) {
                        case 3: {
                            this.uniqueSourceElementListAdded((SourceElementList)notification.getNewValue());
                            break block0;
                        }
                        case 5: {
                            for (SourceElementList sel : (Collection)notification.getNewValue()) {
                                this.uniqueSourceElementListAdded(sel);
                            }
                            break block20;
                        }
                        case 4: {
                            this.uniqueSourceElementListRemoved((SourceElementList)notification.getOldValue());
                            break block0;
                        }
                        case 6: {
                            for (SourceElementList sel : (Collection)notification.getOldValue()) {
                                this.uniqueSourceElementListRemoved(sel);
                            }
                        }
                    }
                }
            }
        }
    }

    private void uniqueSourceElementAdded(SourceElement se) {
        EObject object = se.getObject();
        if (this.uniqueSourceObjects.containsKey(object)) {
            SourceElement eSe = this.uniqueSourceObjects.get(object);
            throw new IllegalArgumentException(String.format("Unique trace already exists for source element %s::%s: %s::%s", se.getSourceOf().getRule(), se, eSe.getSourceOf().getRule(), eSe));
        }
        this.uniqueSourceObjects.put(object, se);
    }

    private void uniqueSourceElementRemoved(SourceElement se) {
        this.uniqueSourceObjects.remove(se.getObject());
    }

    private void uniqueSourceElementListAdded(SourceElementList sel) {
        EList<EObject> objects = sel.getSourceObjects();
        if (this.uniqueSourceObjectLists.containsKey(objects)) {
            assert (!sel.getSourceElements().isEmpty());
            TracedRule selRule = ((SourceElement)sel.getSourceElements().get(0)).getSourceOf().getRule();
            SourceElementList eSel = this.uniqueSourceObjectLists.get(objects);
            assert (!eSel.getSourceElements().isEmpty());
            TracedRule eSelRule = ((SourceElement)eSel.getSourceElements().get(0)).getSourceOf().getRule();
            throw new IllegalArgumentException(String.format("Unique trace already exists for source element list %s::%s: %s::%s", selRule, sel, eSelRule, eSel));
        }
        this.uniqueSourceObjectLists.put((List<EObject>)objects, sel);
    }

    private void uniqueSourceElementListRemoved(SourceElementList sel) {
        this.uniqueSourceObjectLists.remove(sel.getSourceObjects());
    }
}

