/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.ui.contentassist;

import com.google.common.base.Function;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mita.base.expressions.ExpressionsPackage;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.ImportStatement;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.PackageAssociation;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.SystemResourceEvent;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.DefaultValueProvider;
import org.eclipse.mita.program.model.ImportHelper;
import org.eclipse.mita.program.scoping.ProgramDslResourceDescriptionStrategy;
import org.eclipse.mita.program.ui.contentassist.AbstractProgramDslProposalProvider;
import org.eclipse.mita.program.ui.contentassist.ProposalPriorityHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalPriorities;
import org.eclipse.xtext.xbase.lib.Extension;

public class ProgramDslProposalProvider
extends AbstractProgramDslProposalProvider {
    @Inject
    private ProposalPriorityHelper priorityHelper;
    @Inject
    private ILabelProvider labelProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    protected ITypeSystemInferrer typeInferrer;
    @Inject
    @Extension
    protected ImportHelper _importHelper;
    @Inject
    private DefaultValueProvider defaultValueProvider;

    public Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        IQualifiedNameConverter _qualifiedNameConverter = this.getQualifiedNameConverter();
        abstract class __ProgramDslProposalProvider_1
        extends AbstractJavaBasedContentProposalProvider.DefaultProposalCreator {
            __ProgramDslProposalProvider_1(ContentAssistContext arg0, String arg1, IQualifiedNameConverter arg2) {
                super((AbstractJavaBasedContentProposalProvider)ProgramDslProposalProvider.this, arg0, arg1, arg2);
            }

            protected abstract void createFunctionDefinitionProposal(IEObjectDescription var1, ICompletionProposal var2);

            protected abstract String getParamTypes(IEObjectDescription var1);

            protected abstract String getType(IEObjectDescription var1);
        }
        return new __ProgramDslProposalProvider_1(this, contentAssistContext, ruleName, _qualifiedNameConverter){
            {
                super($anonymous0, $anonymous1, $anonymous2);
            }

            public ICompletionProposal apply(IEObjectDescription candidate) {
                ICompletionProposal proposal = super.apply(candidate);
                boolean _isSuperTypeOf = TypesPackage.Literals.OPERATION.isSuperTypeOf(candidate.getEClass());
                if (_isSuperTypeOf) {
                    this.createFunctionDefinitionProposal(candidate, proposal);
                }
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ((ConfigurableCompletionProposal)proposal).setImage(labelProvider.getImage((Object)candidate.getEObjectOrProxy()));
                }
                return proposal;
            }

            @Override
            protected void createFunctionDefinitionProposal(IEObjectDescription candidate, ICompletionProposal proposal) {
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal configProposal = (ConfigurableCompletionProposal)proposal;
                    String paramTypes = this.getParamTypes(candidate).replace("[", "").replace("]", "");
                    String returnType = this.getType(candidate);
                    if (paramTypes != null) {
                        boolean _greaterThan;
                        boolean _equals = "void".equals(returnType);
                        if (_equals) {
                            String _replacementString = configProposal.getReplacementString();
                            String _plus = String.valueOf(_replacementString) + "();";
                            configProposal.setReplacementString(_plus);
                        } else {
                            String _replacementString_1 = configProposal.getReplacementString();
                            String _plus_1 = String.valueOf(_replacementString_1) + "()";
                            configProposal.setReplacementString(_plus_1);
                        }
                        int _length = paramTypes.split(",").length;
                        boolean bl = _greaterThan = _length > 0;
                        if (_greaterThan) {
                            int _cursorPosition = configProposal.getCursorPosition();
                            int _plus_2 = _cursorPosition + 1;
                            configProposal.setCursorPosition(_plus_2);
                        } else {
                            int _cursorPosition_1 = configProposal.getCursorPosition();
                            int _plus_3 = _cursorPosition_1 + 2;
                            configProposal.setCursorPosition(_plus_3);
                        }
                        String _displayString = configProposal.getDisplayString();
                        String _plus_4 = String.valueOf(_displayString) + "(";
                        String _plus_5 = String.valueOf(_plus_4) + paramTypes;
                        String _plus_6 = String.valueOf(_plus_5) + ")";
                        String _plus_7 = String.valueOf(_plus_6) + " : ";
                        String _plus_8 = String.valueOf(_plus_7) + returnType;
                        configProposal.setDisplayString(_plus_8);
                    }
                }
            }

            @Override
            protected String getParamTypes(IEObjectDescription candidate) {
                String _xifexpression = null;
                boolean _eIsProxy = candidate.getEObjectOrProxy().eIsProxy();
                if (_eIsProxy) {
                    _xifexpression = candidate.getUserData("OPERATION_PARAM_TYPES");
                } else {
                    EObject _eObjectOrProxy = candidate.getEObjectOrProxy();
                    _xifexpression = Arrays.toString(ProgramDslResourceDescriptionStrategy.getOperationParameterTypes((Operation)((Operation)_eObjectOrProxy)));
                }
                return _xifexpression;
            }

            @Override
            protected String getType(IEObjectDescription candidate) {
                boolean _eIsProxy = candidate.getEObjectOrProxy().eIsProxy();
                if (_eIsProxy) {
                    return candidate.getUserData("TYPE");
                }
                ITypeSystemInferrer.InferenceResult _infer = typeInferrer.infer(candidate.getEObjectOrProxy());
                Type _type = null;
                if (_infer != null) {
                    _type = _infer.getType();
                }
                String _name = null;
                if (_type != null) {
                    _name = _type.getName();
                }
                return _name;
            }
        };
    }

    public IContentProposalPriorities getPriorityHelper() {
        return this.priorityHelper;
    }

    public void proposeComplexTypeConstructors(Boolean scoped, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IScope scope = this.scopeProvider.getScope(model, ExpressionsPackage.eINSTANCE.getElementReferenceExpression_Reference());
        Iterable _allElements = scope.getAllElements();
        for (IEObjectDescription element : _allElements) {
            boolean inSetupBlock;
            EObject obj = element.getEObjectOrProxy();
            Program _containerOfType = (Program)EcoreUtil2.getContainerOfType((EObject)obj, Program.class);
            boolean fromPlatform = _containerOfType == null;
            SystemResourceSetup _containerOfType_1 = (SystemResourceSetup)EcoreUtil2.getContainerOfType((EObject)model, SystemResourceSetup.class);
            boolean bl = inSetupBlock = _containerOfType_1 != null;
            if (Boolean.valueOf(fromPlatform) != Boolean.valueOf(inSetupBlock) || !(obj instanceof SumAlternative) && !(obj instanceof StructureType)) continue;
            String _xifexpression = null;
            if (scoped.booleanValue() && obj instanceof SumAlternative) {
                EObject _eContainer = obj.eContainer();
                String _name = ((SumType)_eContainer).getName();
                _xifexpression = String.valueOf(_name) + ".";
            } else {
                _xifexpression = "";
            }
            String prefix = _xifexpression;
            String s = this.defaultValueProvider.getDummyConstructor(prefix, (ComplexType)obj);
            if (s == null) continue;
            StyledString _styledString = new StyledString(s);
            ICompletionProposal proposal = this.createCompletionProposal(s, _styledString, this.labelProvider.getImage((Object)obj), context);
            if (proposal instanceof ConfigurableCompletionProposal) {
                ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)obj);
                ((ConfigurableCompletionProposal)proposal).setHover(this.getHover());
                IContentProposalPriorities _priorityHelper = this.getPriorityHelper();
                String _name_1 = ((ComplexType)obj).getName();
                String _plus = String.valueOf(prefix) + _name_1;
                _priorityHelper.adjustCrossReferencePriority(proposal, _plus);
            }
            acceptor.accept(proposal);
        }
    }

    public void complete_ElementReferenceExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleEquals;
        SystemResourceSetup _containerOfType = (SystemResourceSetup)EcoreUtil2.getContainerOfType((EObject)model, SystemResourceSetup.class);
        boolean bl = _tripleEquals = _containerOfType == null;
        if (_tripleEquals) {
            return;
        }
        this.proposeComplexTypeConstructors(false, model, context, acceptor);
    }

    public void complete_FeatureCall(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleNotEquals;
        SystemResourceSetup _containerOfType = (SystemResourceSetup)EcoreUtil2.getContainerOfType((EObject)model, SystemResourceSetup.class);
        boolean bl = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            return;
        }
        IScope scope = this.scopeProvider.getScope(model, ExpressionsPackage.eINSTANCE.getElementReferenceExpression_Reference());
        Iterable _allElements = scope.getAllElements();
        for (IEObjectDescription element : _allElements) {
            EObject obj = element.getEObjectOrProxy();
            if (!(obj instanceof AbstractSystemResource)) continue;
            EList _modalities = ((AbstractSystemResource)obj).getModalities();
            for (Modality modality : _modalities) {
                StringConcatenation _builder = new StringConcatenation();
                QualifiedName _name = element.getName();
                _builder.append((Object)_name);
                _builder.append(".");
                String _name_1 = modality.getName();
                _builder.append(_name_1);
                _builder.append(".read()");
                String proposalString = _builder.toString();
                ICompletionProposal proposal = this.createCustomProposal(proposalString, (EObject)modality, context);
                acceptor.accept(proposal);
            }
        }
        this.proposeComplexTypeConstructors(true, model, context, acceptor);
    }

    @Override
    public void complete_SystemEventSource(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IScope scope = this.scopeProvider.getScope(model, ProgramPackage.eINSTANCE.getSystemEventSource_Origin());
        Iterable _allElements = scope.getAllElements();
        for (IEObjectDescription element : _allElements) {
            EObject obj = element.getEObjectOrProxy();
            if (!(obj instanceof AbstractSystemResource)) continue;
            EList _events = ((AbstractSystemResource)obj).getEvents();
            for (SystemResourceEvent event : _events) {
                String _name = ((AbstractSystemResource)obj).getName();
                String _plus = String.valueOf(_name) + ".";
                String _name_1 = event.getName();
                String proposalString = String.valueOf(_plus) + _name_1;
                ICompletionProposal proposal = this.createCustomProposal(proposalString, (EObject)event, context);
                acceptor.accept(proposal);
            }
        }
    }

    protected ICompletionProposal createCustomProposal(String proposalString, EObject element, ContentAssistContext context) {
        ICompletionProposal _xblockexpression = null;
        StyledString _styledString = new StyledString(proposalString);
        ICompletionProposal proposal = this.createCompletionProposal(proposalString, _styledString, this.labelProvider.getImage((Object)element), context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            EObject _xifexpression = null;
            boolean _eIsProxy = element.eIsProxy();
            _xifexpression = _eIsProxy ? EcoreUtil.resolve((EObject)element, (Resource)context.getResource()) : element;
            ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)_xifexpression);
            ((ConfigurableCompletionProposal)proposal).setHover(this.getHover());
            this.getPriorityHelper().adjustCrossReferencePriority(proposal, context.getPrefix());
        }
        _xblockexpression = proposal;
        return _xblockexpression;
    }

    public void complete_QID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof ImportStatement) {
            this.complete_ImportStatement_ImportedNamespace(model, ruleCall, context, acceptor);
        }
        super.complete_QID(model, ruleCall, context, acceptor);
    }

    public void complete_ImportStatement_ImportedNamespace(final EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        List candidates = this._importHelper.getVisiblePackages(model.eResource());
        PackageAssociation _containerOfType = (PackageAssociation)EcoreUtil2.getContainerOfType((EObject)model, PackageAssociation.class);
        String _name = null;
        if (_containerOfType != null) {
            _name = _containerOfType.getName();
        }
        candidates.remove(_name);
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String it) {
                acceptor.accept(ProgramDslProposalProvider.this.createCompletionProposal(it, it, ProgramDslProposalProvider.this.labelProvider.getImage((Object)model), context));
            }
        };
        candidates.forEach(_function);
    }
}

