/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.mita.program.validation.MethodCall;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class NoiseSensorValidator
implements IResourceValidator {
    public static final int DEFAULT_SAMPLING_FREQUENCY = 2560;
    public static final int MINIMUM_SAMPLING_FREQUENCY = 6;
    public static final int MAXIMUM_SAMPLING_FREQUENCY = 45000;
    public static final double MINIMUM_SAMPLE_TIME = 5.688888888888889;
    public static final int DEFAULT_TIMEOUT = 100;
    public static final String NOISE_SENSOR_TYPE_NAME = "noise_sensor";
    public static final String TIMEOUT_SMALLER_THAN_SAMPLING_TIME = "Timeout is smaller than sampling time (~%f for 256 samples). This could lead to exceptions being thrown. Consider increasing timeout to at least %d or increasing sampling frequency to at least %d.";

    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            boolean _equals;
            AbstractSystemResource _type = ((SystemResourceSetup)context).getType();
            String _name = null;
            if (_type != null) {
                _name = _type.getName();
            }
            if (_equals = Objects.equal((Object)_name, (Object)NOISE_SENSOR_TYPE_NAME)) {
                boolean _lessThan;
                boolean _greaterThan;
                Pair<Integer, Expression> samplingFrequency_expr = NoiseSensorValidator.getSamplingFrequency((SystemResourceSetup)context);
                Integer _key = (Integer)samplingFrequency_expr.getKey();
                boolean bl = _greaterThan = _key > 45000;
                if (_greaterThan) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Sampling frequency too high (");
                    Integer _key_1 = (Integer)samplingFrequency_expr.getKey();
                    _builder.append((Object)_key_1);
                    _builder.append("), maximum is 45000.");
                    acceptor.acceptError(_builder.toString(), (EObject)samplingFrequency_expr.getValue(), null, 0, "", new String[0]);
                    return;
                }
                Integer _key_2 = (Integer)samplingFrequency_expr.getKey();
                boolean bl2 = _lessThan = _key_2 < 6;
                if (_lessThan) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Sampling frequency too low (");
                    Integer _key_3 = (Integer)samplingFrequency_expr.getKey();
                    _builder_1.append((Object)_key_3);
                    _builder_1.append("), minimum is 6.");
                    acceptor.acceptError(_builder_1.toString(), (EObject)samplingFrequency_expr.getValue(), null, 0, "", new String[0]);
                    return;
                }
                Pair<Double, Expression> timePerSampleInMs_expr = NoiseSensorValidator.getTimePerSampleInMs((SystemResourceSetup)context);
                Double timePerSampleInMs = (Double)timePerSampleInMs_expr.getKey();
                boolean _isNaN = timePerSampleInMs.isNaN();
                if (_isNaN) {
                    acceptor.acceptError("Invalid sampling frequency", (EObject)timePerSampleInMs_expr.getValue(), null, 0, "", new String[0]);
                    return;
                }
                Pair<Integer, Expression> timeout_expr = NoiseSensorValidator.getTimeout((SystemResourceSetup)context);
                Integer timeout = (Integer)timeout_expr.getKey();
                if ((double)timeout.intValue() < timePerSampleInMs) {
                    double _ceil = Math.ceil(256000.0 / (double)timeout.intValue());
                    int minSamplingFrequency = (int)_ceil;
                    acceptor.acceptWarning(String.format(TIMEOUT_SMALLER_THAN_SAMPLING_TIME, timePerSampleInMs, timePerSampleInMs.intValue(), minSamplingFrequency), (EObject)timePerSampleInMs_expr.getValue(), null, 0, "", new String[0]);
                    acceptor.acceptWarning(String.format(TIMEOUT_SMALLER_THAN_SAMPLING_TIME, timePerSampleInMs, timePerSampleInMs.intValue(), minSamplingFrequency), (EObject)timeout_expr.getValue(), null, 0, "", new String[0]);
                }
            }
        }
    }

    public static Pair<Integer, Expression> getTimeout(SystemResourceSetup setup) {
        Expression _configurationItemValue = null;
        if (setup != null) {
            _configurationItemValue = setup.getConfigurationItemValue("timeout");
        }
        Expression expr = _configurationItemValue;
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                InputOutput.println((Object)"Warning: no timeout");
            }
        };
        Object value = StaticValueInferrer.infer((EObject)expr, (Procedures.Procedure1)_function);
        Integer _xifexpression = null;
        _xifexpression = value instanceof Integer ? (Integer)value : Integer.valueOf(100);
        Integer timeout = _xifexpression;
        return Pair.of((Object)timeout, (Object)expr);
    }

    public static Pair<Integer, Expression> getSamplingFrequency(SystemResourceSetup setup) {
        Expression _configurationItemValue = null;
        if (setup != null) {
            _configurationItemValue = setup.getConfigurationItemValue("samplingFrequency");
        }
        Expression expr = _configurationItemValue;
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                InputOutput.println((Object)"Warning: no samplingFrequency");
            }
        };
        Object value = StaticValueInferrer.infer((EObject)expr, (Procedures.Procedure1)_function);
        Integer _xifexpression = null;
        _xifexpression = value instanceof Integer ? (Integer)value : Integer.valueOf(2560);
        Integer samplingFrequency = _xifexpression;
        return Pair.of((Object)samplingFrequency, (Object)expr);
    }

    public static Pair<Double, Expression> getTimePerSampleInMs(SystemResourceSetup setup) {
        Pair<Integer, Expression> f_expr = NoiseSensorValidator.getSamplingFrequency(setup);
        Integer f = (Integer)f_expr.getKey();
        if (f > 0) {
            Expression _value = (Expression)f_expr.getValue();
            return Pair.of((Object)(256000.0 / (double)f.intValue()), (Object)_value);
        }
        Expression _value_1 = (Expression)f_expr.getValue();
        return Pair.of((Object)Double.NaN, (Object)_value_1);
    }

    public static void validateNoiseRead(final Set<MethodCall.MethodCallModality> noiseReads, final MethodCall.MethodCallModality mcm, ValidationMessageAcceptor acceptor) {
        ArgumentExpression _source = null;
        if (mcm != null) {
            _source = mcm.getSource();
        }
        TreeIterator _allContents = _source.eResource().getResourceSet().getAllContents();
        UnmodifiableIterator _filter = null;
        if (_allContents != null) {
            _filter = Iterators.filter((Iterator)_allContents, Program.class);
        }
        Iterator _flatMap = null;
        if (_filter != null) {
            Functions.Function1<Program, Iterator<SystemResourceSetup>> _function = new Functions.Function1<Program, Iterator<SystemResourceSetup>>(){

                public Iterator<SystemResourceSetup> apply(Program it) {
                    return it.getSetup().iterator();
                }
            };
            _flatMap = IteratorExtensions.flatMap((Iterator)_filter, (Functions.Function1)_function);
        }
        Iterator _filter_1 = null;
        if (_flatMap != null) {
            Functions.Function1<SystemResourceSetup, Boolean> _function_1 = new Functions.Function1<SystemResourceSetup, Boolean>(){

                public Boolean apply(SystemResourceSetup it) {
                    AbstractSystemResource _type = it.getType();
                    String _name = null;
                    if (_type != null) {
                        _name = _type.getName();
                    }
                    return Objects.equal((Object)_name, (Object)NoiseSensorValidator.NOISE_SENSOR_TYPE_NAME);
                }
            };
            _filter_1 = IteratorExtensions.filter((Iterator)_flatMap, (Functions.Function1)_function_1);
        }
        Iterator setups = _filter_1;
        SystemResourceSetup _head = null;
        if (setups != null) {
            _head = (SystemResourceSetup)IteratorExtensions.head((Iterator)setups);
        }
        Pair<Double, Expression> sampleTime_expr = NoiseSensorValidator.getTimePerSampleInMs(_head);
        ProgramBlock outerProgramBlock = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)mcm.getSource(), ProgramBlock.class);
        if (outerProgramBlock == null) {
            return;
        }
        boolean outerMost = false;
        while (!outerMost) {
            ProgramBlock next = (ProgramBlock)EcoreUtil2.getContainerOfType((EObject)outerProgramBlock.eContainer(), ProgramBlock.class);
            if (next == null) {
                outerMost = true;
                continue;
            }
            outerProgramBlock = next;
        }
        Functions.Function1<EObject, Boolean> _function_2 = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(final EObject obj) {
                Functions.Function1<MethodCall.MethodCallModality, Boolean> _function = new Functions.Function1<MethodCall.MethodCallModality, Boolean>(){

                    public Boolean apply(MethodCall.MethodCallModality it) {
                        ArgumentExpression _source = it.getSource();
                        return Objects.equal((Object)_source, (Object)obj);
                    }
                };
                MethodCall.MethodCallModality _findFirst = (MethodCall.MethodCallModality)IterableExtensions.findFirst((Iterable)noiseReads, (Functions.Function1)_function);
                return _findFirst != null;
            }
        };
        List nearbyReads = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)outerProgramBlock.eAllContents(), (Functions.Function1)_function_2));
        Functions.Function1<EObject, Boolean> _function_3 = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject it) {
                ArgumentExpression _source = mcm.getSource();
                return it != _source;
            }
        };
        List previousNoiseReads = IterableExtensions.toList((Iterable)IterableExtensions.takeWhile((Iterable)nearbyReads, (Functions.Function1)_function_3));
        EventHandlerDeclaration eventHandler = (EventHandlerDeclaration)EcoreUtil2.getContainerOfType((EObject)mcm.getSource(), EventHandlerDeclaration.class);
        EventSource event = eventHandler.getEvent();
        int _length = ((Object[])Conversions.unwrapArray((Object)previousNoiseReads, Object.class)).length;
        int numberOfPreviousReadsInThisEventHandler = _length + 1;
        Double _key = (Double)sampleTime_expr.getKey();
        double actualSampleTime = _key * (double)numberOfPreviousReadsInThisEventHandler;
        if (event instanceof TimeIntervalEvent) {
            int eventSampleTime = ModelUtils.getIntervalInMilliseconds((TimeIntervalEvent)((TimeIntervalEvent)event));
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("You can't sample the noise sensor this often. Minimum time per sample is ");
            double _ceil = Math.ceil(5.688888888888889);
            _builder.append((Object)((int)_ceil));
            _builder.append("ms. This means that you will get exceptions or eventually overflow the event queue.");
            String msgFasterThanXdkIsCapable = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Noise samples won't be calculated fast enough for how often you are sampling, which means that you will get exceptions. Consider increasing sampling frequency to ");
            double _ceil_1 = Math.ceil(256000.0 / (double)(eventSampleTime / numberOfPreviousReadsInThisEventHandler));
            _builder_1.append((Object)((int)_ceil_1));
            _builder_1.append(" or increasing your event handler interval to ");
            _builder_1.append((Object)((int)actualSampleTime));
            _builder_1.append("ms.");
            String msgFasterThanConfigured = _builder_1.toString();
            if ((double)(eventSampleTime / numberOfPreviousReadsInThisEventHandler) < 5.688888888888889) {
                acceptor.acceptWarning(msgFasterThanXdkIsCapable, (EObject)((TimeIntervalEvent)event).getInterval(), null, 0, "", new String[0]);
                acceptor.acceptWarning(msgFasterThanXdkIsCapable, (EObject)mcm.getSource(), null, 0, "", new String[0]);
                return;
            }
            if ((double)eventSampleTime < actualSampleTime && !ModelUtils.isInTryCatchFinally((EObject)mcm.getSource())) {
                acceptor.acceptWarning(String.valueOf(msgFasterThanConfigured) + " Alternatively you should catch exceptions here.", (EObject)mcm.getSource(), null, 0, "", new String[0]);
                acceptor.acceptWarning(msgFasterThanConfigured, (EObject)((TimeIntervalEvent)event).getInterval(), null, 0, "", new String[0]);
            }
        }
    }
}

