/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.ExpressionsPackage;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class MqttValidator
implements IResourceValidator {
    @Inject
    private GeneratorUtils generatorUtils;

    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        if (context instanceof SystemResourceSetup) {
            this.validateUrl((SystemResourceSetup)context, acceptor);
            this.validateTopicQualityOfService((SystemResourceSetup)context, acceptor);
        }
    }

    public void validateUrl(SystemResourceSetup setup, ValidationMessageAcceptor acceptor) {
        block24: {
            try {
                Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                    public Boolean apply(ConfigurationItemValue it) {
                        String _name = it.getItem().getName();
                        return Objects.equal((Object)_name, (Object)"url");
                    }
                };
                ConfigurationItemValue urlConfigValue = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)setup.getConfigurationItemValues(), (Functions.Function1)_function);
                Expression url = setup.getConfigurationItemValue("url");
                if (url == null) {
                    return;
                }
                Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                    public void apply(EObject it) {
                    }
                };
                Object urlContent = StaticValueInferrer.infer((EObject)url, (Procedures.Procedure1)_function_1);
                if (!(urlContent instanceof String)) {
                    acceptor.acceptError("URL must be a string", (EObject)urlConfigValue, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "url_must_be_string", new String[0]);
                }
                String urlContentString = (String)urlContent;
                Expression sntpConfigValue = setup.getConfigurationItemValue("sntpServer");
                Procedures.Procedure1<EObject> _function_2 = new Procedures.Procedure1<EObject>(){

                    public void apply(EObject it) {
                    }
                };
                Object sntpString = StaticValueInferrer.infer((EObject)sntpConfigValue, (Procedures.Procedure1)_function_2);
                try {
                    String _scheme;
                    boolean _equals;
                    URI parsedUrl = new URI(urlContentString);
                    if (!Objects.equal((Object)parsedUrl.getScheme(), (Object)"mqtt") && !Objects.equal((Object)parsedUrl.getScheme(), (Object)"mqtts")) {
                        acceptor.acceptError("Protocol must be mqtt (URL must start with mqtt(s)://)", (EObject)urlConfigValue, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "url_must_start_mqtt", new String[0]);
                    }
                    if (_equals = Objects.equal((Object)(_scheme = parsedUrl.getScheme()), (Object)"mqtts")) {
                        Procedures.Procedure1<EObject> _function_3;
                        Expression certificate = setup.getConfigurationItemValue("certificatePath");
                        Object certificateString = StaticValueInferrer.infer((EObject)certificate, (Procedures.Procedure1)(_function_3 = new Procedures.Procedure1<EObject>(){

                            public void apply(EObject it) {
                            }
                        }));
                        if (certificateString instanceof String) {
                            List certificateContent;
                            Stream _fileContents = this.generatorUtils.getFileContents(setup.eResource(), (String)certificateString);
                            List _collect = null;
                            if (_fileContents != null) {
                                _collect = _fileContents.collect(Collectors.toList());
                            }
                            if ((certificateContent = _collect) == null) {
                                acceptor.acceptError("Certificate does not exist", (EObject)certificate, null, 0, "", new String[0]);
                            } else if (!Objects.equal((Object)IterableExtensions.head(certificateContent), (Object)"-----BEGIN CERTIFICATE-----") || !Objects.equal((Object)IterableExtensions.last(certificateContent), (Object)"-----END CERTIFICATE-----")) {
                                acceptor.acceptError("Invalid certificate", (EObject)certificate, null, 0, "", new String[0]);
                            }
                        } else {
                            acceptor.acceptError("Missing configuration item 'certificatePath' when using secure MQTT", (EObject)setup, null, 0, "certificate_path not configured", new String[0]);
                        }
                    }
                    if (parsedUrl.getHost() == null || parsedUrl.getHost().isEmpty()) {
                        acceptor.acceptError("The URL must have a host (e.g. mqtt://thisismyhost.com)", (EObject)urlConfigValue, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "url_must_have_host", new String[0]);
                    }
                    if (parsedUrl.getPath() != null && !parsedUrl.getPath().isEmpty()) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("The URL must not have a path (e.g. ");
                        String _path = parsedUrl.getPath();
                        _builder.append(_path);
                        _builder.append(")");
                        acceptor.acceptError(_builder.toString(), (EObject)urlConfigValue, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "url_mustnt_have_path", new String[0]);
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof MalformedURLException) {
                        MalformedURLException e = (MalformedURLException)_t;
                        String _message = e.getMessage();
                        String _plus = "URL is malformed: " + _message;
                        acceptor.acceptError(_plus, (EObject)urlConfigValue, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "url_is_malformed", new String[0]);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                try {
                    if (sntpString instanceof String) {
                        boolean _isNullOrEmpty_1;
                        boolean _not;
                        boolean _isNullOrEmpty;
                        boolean _notEquals;
                        URI sntpUrl = new URI((String)sntpString);
                        String _scheme_1 = sntpUrl.getScheme();
                        boolean bl = _notEquals = !Objects.equal((Object)_scheme_1, (Object)"sntp");
                        if (_notEquals) {
                            acceptor.acceptError("SNTP must have scheme 'sntp://'", (EObject)sntpConfigValue, null, 0, "", new String[0]);
                        }
                        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)sntpUrl.getHost())) {
                            acceptor.acceptError("SNTP must have a host", (EObject)sntpConfigValue, null, 0, "", new String[0]);
                        }
                        boolean bl2 = _not = !(_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)sntpUrl.getPath()));
                        if (_not) {
                            String _path_1 = sntpUrl.getPath();
                            String _plus_1 = "SNTP must not have a path (" + _path_1;
                            String _plus_2 = String.valueOf(_plus_1) + ")";
                            acceptor.acceptError(_plus_2, (EObject)sntpConfigValue, null, 0, "", new String[0]);
                        }
                    }
                }
                catch (Throwable _t_1) {
                    if (_t_1 instanceof MalformedURLException) {
                        MalformedURLException e_1 = (MalformedURLException)_t_1;
                        String _message_1 = e_1.getMessage();
                        String _plus_3 = "URL is malformed: " + _message_1;
                        acceptor.acceptError(_plus_3, (EObject)sntpConfigValue, (EStructuralFeature)ProgramPackage.Literals.CONFIGURATION_ITEM_VALUE__VALUE, 0, "url_is_malformed", new String[0]);
                        break block24;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t_1);
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    public void validateTopicQualityOfService(SystemResourceSetup setup, ValidationMessageAcceptor acceptor) {
        EList _signalInstances = setup.getSignalInstances();
        for (SignalInstance siginst : _signalInstances) {
            Procedures.Procedure1<EObject> _function;
            Object qosValue;
            Expression qos;
            if (!Objects.equal((Object)siginst.getInstanceOf().getName(), (Object)"topic") && !Objects.equal((Object)siginst.getInstanceOf().getName(), (Object)"telemetry") || (qos = ModelUtils.getArgumentValue((SignalInstance)siginst, (String)"qos")) == null || !((qosValue = StaticValueInferrer.infer((EObject)qos, (Procedures.Procedure1)(_function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                }
            }))) instanceof Integer) || (Integer)qosValue >= 0 && (Integer)qosValue <= 2) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("QOS level must be between 0 and 2");
            acceptor.acceptError(_builder.toString(), qos.eContainer(), (EStructuralFeature)ExpressionsPackage.Literals.ARGUMENT__VALUE, 0, "qos_level_oob", new String[0]);
        }
    }
}

