/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.ProgramDslTraceExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.GeneratorNodeExtensions;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.TemplateNode;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CodeFragment
extends CompositeGeneratorNode {
    public static final CodeFragment EMPTY = new CodeFragment();
    @Inject
    @Extension
    private ProgramDslTraceExtensions traceExtension;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    private final List<IncludePath> includePaths = new LinkedList<IncludePath>();
    private IGeneratorNode preamble = null;

    public CodeFragment addHeader(String path, boolean isSystemInclude) {
        IncludePath includePath = new IncludePath(path, isSystemInclude);
        this.includePaths.add(includePath);
        return this;
    }

    public CodeFragment addHeader(String path, boolean isSystemInclude, int priority) {
        IncludePath includePath = new IncludePath(path, isSystemInclude, priority);
        this.includePaths.add(includePath);
        return this;
    }

    public CodeFragment addHeader(IncludePath ... paths) {
        CollectionExtensions.addAll(this.includePaths, (Object[])paths);
        return this;
    }

    public CodeFragment setPreamble(IGeneratorNode preamble) {
        this.preamble = preamble;
        return this;
    }

    public CodeFragment setPreamble(StringConcatenationClient preamble) {
        TemplateNode _templateNode = new TemplateNode(preamble, (GeneratorNodeExtensions)this.traceExtension);
        this.preamble = _templateNode;
        return this;
    }

    public List<IncludePath> getIncludePaths() {
        return this.includePaths;
    }

    protected List<String> combineIncludes(Iterable<IncludePath> paths) {
        Iterable allIncludes = IterableExtensions.filterNull(paths);
        Functions.Function1<IncludePath, String> _function = new Functions.Function1<IncludePath, String>(){

            public String apply(IncludePath x) {
                return x.toString();
            }
        };
        Map includeMap = IterableExtensions.groupBy((Iterable)allIncludes, (Functions.Function1)_function);
        Functions.Function1<List<IncludePath>, IncludePath> _function_1 = new Functions.Function1<List<IncludePath>, IncludePath>(){

            public IncludePath apply(List<IncludePath> x) {
                Functions.Function1<IncludePath, Integer> _function = new Functions.Function1<IncludePath, Integer>(){

                    public Integer apply(IncludePath y) {
                        return y.priority;
                    }
                };
                return (IncludePath)IterableExtensions.maxBy(x, (Functions.Function1)_function);
            }
        };
        List includes = IterableExtensions.toList((Iterable)IterableExtensions.map(includeMap.values(), (Functions.Function1)_function_1));
        Functions.Function1<IncludePath, Integer> _function_2 = new Functions.Function1<IncludePath, Integer>(){

            public Integer apply(IncludePath x) {
                int _xifexpression = 0;
                boolean _isSystemInclude = x.isSystemInclude();
                _xifexpression = _isSystemInclude ? 10 : 1;
                return x.priority * _xifexpression;
            }
        };
        Functions.Function1<IncludePath, String> _function_3 = new Functions.Function1<IncludePath, String>(){

            public String apply(IncludePath x) {
                return x.toString();
            }
        };
        return ListExtensions.map((List)ListExtensions.reverse((List)IterableExtensions.sortBy((Iterable)includes, (Functions.Function1)_function_2)), (Functions.Function1)_function_3);
    }

    public CompositeGeneratorNode toHeader(final CompilationContext context, final String guardName) {
        Iterable<IncludePath> _findIncludes = this.findIncludes(this.getChildren());
        final List<String> includes = this.combineIncludes(Iterables.concat(this.includePaths, _findIncludes));
        final CompositeGeneratorNode preamble = new CompositeGeneratorNode();
        if (this.preamble != null) {
            List _children = preamble.getChildren();
            _children.add(this.preamble);
        }
        List _children_1 = preamble.getChildren();
        Iterable<IGeneratorNode> _findPreamble = this.findPreamble(this.getChildren());
        Iterables.addAll((Collection)_children_1, _findPreamble);
        CompositeGeneratorNode result = new CompositeGeneratorNode();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CharSequence _generateHeaderComment = CodeFragment.this._generatorUtils.generateHeaderComment(context);
                _builder.append((Object)_generateHeaderComment);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"#ifndef ");
                String _upperCase = guardName.toUpperCase();
                _builder.append((Object)_upperCase);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"#define ");
                String _upperCase_1 = guardName.toUpperCase();
                _builder.append((Object)_upperCase_1);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                for (String include : includes) {
                    _builder.append((Object)include);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)preamble);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)CodeFragment.this);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"#endif");
                _builder.newLine();
            }
        };
        TemplateNode _templateNode = new TemplateNode(_client, (GeneratorNodeExtensions)this.traceExtension);
        result.getChildren().add(_templateNode);
        return result;
    }

    public CompositeGeneratorNode toImplementation(final CompilationContext context) {
        Iterable<IncludePath> _findIncludes = this.findIncludes(this.getChildren());
        final List<String> includes = this.combineIncludes(Iterables.concat(this.includePaths, _findIncludes));
        final CompositeGeneratorNode preamble = new CompositeGeneratorNode();
        if (this.preamble != null) {
            List _children = preamble.getChildren();
            _children.add(this.preamble);
        }
        List _children_1 = preamble.getChildren();
        Iterable<IGeneratorNode> _findPreamble = this.findPreamble(this.getChildren());
        Iterables.addAll((Collection)_children_1, _findPreamble);
        CompositeGeneratorNode result = new CompositeGeneratorNode();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CharSequence _generateHeaderComment = CodeFragment.this._generatorUtils.generateHeaderComment(context);
                _builder.append((Object)_generateHeaderComment);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                for (String include : includes) {
                    _builder.append((Object)include);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)preamble);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)CodeFragment.this);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        };
        TemplateNode _templateNode = new TemplateNode(_client, (GeneratorNodeExtensions)this.traceExtension);
        result.getChildren().add(_templateNode);
        return result;
    }

    private Iterable<IncludePath> findIncludes(Iterable<IGeneratorNode> nodes) {
        Functions.Function1<CompositeGeneratorNode, Iterable<IncludePath>> _function = new Functions.Function1<CompositeGeneratorNode, Iterable<IncludePath>>(){

            public Iterable<IncludePath> apply(CompositeGeneratorNode x) {
                Iterable _xifexpression = null;
                if (x instanceof CodeFragment) {
                    Iterable _findIncludes = CodeFragment.this.findIncludes(((CodeFragment)x).getChildren());
                    _xifexpression = Iterables.concat((Iterable)((CodeFragment)x).includePaths, (Iterable)_findIncludes);
                } else {
                    _xifexpression = CodeFragment.this.findIncludes(x.getChildren());
                }
                return _xifexpression;
            }
        };
        return Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(nodes, CompositeGeneratorNode.class), (Functions.Function1)_function));
    }

    private Iterable<IGeneratorNode> findPreamble(Iterable<IGeneratorNode> nodes) {
        Functions.Function1<CompositeGeneratorNode, Iterable<IGeneratorNode>> _function = new Functions.Function1<CompositeGeneratorNode, Iterable<IGeneratorNode>>(){

            public Iterable<IGeneratorNode> apply(CompositeGeneratorNode x) {
                Iterable _xifexpression = null;
                if (x instanceof CodeFragment) {
                    Iterable _findPreamble = CodeFragment.this.findPreamble(((CodeFragment)x).getChildren());
                    _xifexpression = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IGeneratorNode[]{((CodeFragment)x).preamble})), (Iterable)_findPreamble);
                } else {
                    _xifexpression = CodeFragment.this.findPreamble(x.getChildren());
                }
                return _xifexpression;
            }
        };
        return Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(nodes, CompositeGeneratorNode.class), (Functions.Function1)_function));
    }

    private static Iterable<IGeneratorNode> cleanNullChildren(Iterable<IGeneratorNode> nodes) {
        Iterable<IGeneratorNode> _xblockexpression = null;
        for (IGeneratorNode node : nodes) {
            if (!(node instanceof CompositeGeneratorNode)) continue;
            Iterable<IGeneratorNode> newChildren = CodeFragment.cleanNullChildren(IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)((CompositeGeneratorNode)node).getChildren())));
            ((CompositeGeneratorNode)node).getChildren().clear();
            Iterables.addAll((Collection)((CompositeGeneratorNode)node).getChildren(), newChildren);
        }
        _xblockexpression = nodes;
        return _xblockexpression;
    }

    public static CompositeGeneratorNode cleanNullChildren(CompositeGeneratorNode fragment) {
        CompositeGeneratorNode _xblockexpression = null;
        LinkedList<IGeneratorNode> newChildren = new LinkedList<IGeneratorNode>();
        newChildren.addAll(fragment.getChildren());
        CodeFragment.cleanNullChildren(newChildren);
        fragment.getChildren().clear();
        fragment.getChildren().addAll(newChildren);
        _xblockexpression = fragment;
        return _xblockexpression;
    }

    public static class IncludePath {
        public static final int ULTRA_LOW_PRIORITY = 0;
        public static final int VERY_LOW_PRIORITY = 250;
        public static final int LOW_PRIORITY = 500;
        public static final int DEFAULT_PRIORITY = 500;
        public static final int HIGH_PRIORITY = 750;
        public static final int VERY_HIGH_PRIORITY = 1000;
        public static final int ULTRA_HIGH_PRIORITY = 1250;
        private final String path;
        private final boolean systemInclude;
        private final int priority;

        public IncludePath(String path, boolean isSystemInclude) {
            this(path, isSystemInclude, 500);
        }

        public IncludePath(String path, boolean isSystemInclude, int priority) {
            this.path = path;
            this.systemInclude = isSystemInclude;
            this.priority = priority;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isSystemInclude() {
            return this.systemInclude;
        }

        public String toString() {
            String _xifexpression = null;
            _xifexpression = this.systemInclude ? "<" : "\"";
            String opener = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = this.systemInclude ? ">" : "\"";
            String closer = _xifexpression_1;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("#include ");
            _builder.append(opener);
            _builder.append(this.path);
            _builder.append(closer);
            return _builder.toString();
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

