/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.mft.gmf.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.mylyn.mft.gmf.ui.ContextDecorator;
import org.eclipse.mylyn.mft.gmf.ui.ContextDecoratorProvider;
import org.eclipse.mylyn.mft.gmf.ui.figures.FigureManagerHelper;
import org.eclipse.mylyn.mft.gmf.ui.figures.IRevealableFigure;
import org.eclipse.swt.graphics.Color;

public class EdgeDecorator
extends ContextDecorator {
    private Map<IFigure, Color> priorForegroundForFigure;
    private final EObject connectionSource;
    private final EObject connectionTarget;
    private final List<EdgeMaskingFigure> edgeMaskHandles = new ArrayList<EdgeMaskingFigure>();

    public EdgeDecorator(ContextDecoratorProvider provider, IDecoratorTarget target, EObject connectionSource, EObject connectionTarget) {
        super(provider, target);
        this.connectionSource = connectionSource;
        this.connectionTarget = connectionTarget;
    }

    @Override
    protected void createDecoration() {
        this.removeDecorations();
        if (!this.isInteresting()) {
            this.priorForegroundForFigure = new HashMap<IFigure, Color>();
            for (IFigure figure : this.getManagedFigures()) {
                this.priorForegroundForFigure.put(figure, figure.getForegroundColor());
            }
            EdgeMaskingFigure edgeHandle = new EdgeMaskingFigure(this.getDecoratedFigure(), true);
            this.edgeMaskHandles.add(edgeHandle);
            this.addDecoration(edgeHandle);
            EdgeMaskingFigure edgeHandle2 = new EdgeMaskingFigure(this.getDecoratedFigure(), false);
            this.edgeMaskHandles.add(edgeHandle2);
            this.addDecoration(edgeHandle2);
            this.unreveal();
        }
    }

    public void reveal() {
        double nearness = 0.0;
        for (EdgeMaskingFigure mask : this.edgeMaskHandles) {
            if (!(mask.nearness > nearness)) continue;
            nearness = mask.nearness;
        }
        for (IFigure figure : this.getManagedFigures()) {
            Color figureColor = this.priorForegroundForFigure.get(figure);
            FigureManagerHelper.INSTANCE.reveal(figure, this.getMaskingColor(), figureColor, nearness);
        }
    }

    public void restore() {
        for (IFigure figure : this.getManagedFigures()) {
            Color priorColor = this.priorForegroundForFigure.get(figure);
            figure.setForegroundColor(priorColor);
        }
    }

    public void unreveal() {
        for (IFigure figure : this.getManagedFigures()) {
            FigureManagerHelper.INSTANCE.unreveal(figure, this.getMaskingColor());
        }
    }

    public Collection<IFigure> getManagedFigures() {
        ArrayList<IFigure> figures = new ArrayList<IFigure>();
        figures.add(this.getDecoratedFigure());
        for (Object child : this.getEditPart().getChildren()) {
            if (!(child instanceof IGraphicalEditPart)) continue;
            GraphicalEditPart childPart = (GraphicalEditPart)child;
            IFigure childFigure = childPart.getFigure();
            figures.add(childFigure);
            figures.add(childFigure.getParent());
        }
        return figures;
    }

    public Color getMaskingColor() {
        IFigure backgroundFigure = this.getDecoratedFigure();
        if (backgroundFigure.getParent() != null) {
            backgroundFigure = backgroundFigure.getParent();
        }
        if (backgroundFigure.getParent() != null) {
            backgroundFigure = backgroundFigure.getParent();
        }
        return backgroundFigure.getBackgroundColor();
    }

    @Override
    public boolean isInteresting() {
        return this.getProvider().isInteresting(this.connectionSource) && this.getProvider().isInteresting(this.connectionTarget);
    }

    @Override
    public boolean isLandmark() {
        return false;
    }

    class EdgeMaskingFigure
    extends RectangleFigure
    implements IRevealableFigure {
        double nearness;
        private final IFigure decorated;
        private final boolean head;

        public EdgeMaskingFigure(IFigure decorated, boolean head) {
            this.decorated = decorated;
            this.head = head;
            this.setOutline(false);
            this.setFill(true);
            this.unreveal();
        }

        public void relocate(IFigure target) {
            if (target instanceof Decoration && this.decorated instanceof PolylineConnection) {
                PolylineConnection connection = (PolylineConnection)this.decorated;
                Point point = this.head ? connection.getPoints().getFirstPoint() : connection.getPoints().getLastPoint();
                target.setBounds(new Rectangle(point, new Dimension(1, 1)));
            }
        }

        @Override
        public void reveal(double nearness) {
            this.nearness = nearness;
            EdgeDecorator.this.reveal();
        }

        @Override
        public void restore() {
            EdgeDecorator.this.restore();
        }

        @Override
        public void unreveal() {
            EdgeDecorator.this.unreveal();
        }
    }
}

