/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.profiles.ui.internal.dialog;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.profiles.core.internal.ProfileState;
import org.eclipse.m2e.profiles.ui.internal.Messages;
import org.eclipse.m2e.profiles.ui.internal.dialog.ProfileSelection;
import org.eclipse.m2e.profiles.ui.internal.dialog.ProfileUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class SelectProfilesDialog
extends TitleAreaDialog
implements IMenuListener {
    private static int PROFILE_ID_COLUMN = 0;
    private static int SOURCE_COLUMN = 1;
    private CheckboxTableViewer profileTableViewer;
    private Button offlineModeBtn;
    private Button forceUpdateBtn;
    private Text profilesText;
    private boolean offlineMode;
    private boolean forceUpdate;
    List<ProfileSelection> sharedProfiles;
    Set<IMavenProjectFacade> facades;
    IMavenProjectFacade facade;
    final Action activationAction = new ChangeProfileStateAction(ProfileState.Active);
    final Action deActivationAction = new ChangeProfileStateAction(ProfileState.Disabled);
    private Label warningImg;
    private Label warningLabel;

    public SelectProfilesDialog(Shell parentShell, Set<IMavenProjectFacade> facades, List<ProfileSelection> sharedProfiles) {
        super(parentShell);
        this.setShellStyle(super.getShellStyle() | 0x10);
        this.offlineMode = MavenPlugin.getMavenConfiguration().isOffline();
        this.facades = facades;
        if (facades.size() == 1) {
            this.facade = facades.iterator().next();
        }
        this.sharedProfiles = sharedProfiles;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SelectProfilesDialog_Select_Maven_profiles);
    }

    protected Control createDialogArea(Composite parent) {
        String text;
        boolean hasProfiles;
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setEnabled(true);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 12;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.setTitle(Messages.SelectProfilesDialog_Maven_profile_selection);
        boolean bl = hasProfiles = !this.sharedProfiles.isEmpty();
        if (this.facade == null) {
            text = NLS.bind((String)Messages.SelectProfilesDialog_Select_active_profiles_for_selected_projects, (Object)this.facades.size());
        } else {
            text = NLS.bind((String)Messages.SelectProfilesDialog_Select_the_active_Maven_profiles, (Object)this.facade.getProject().getName());
            if (hasProfiles) {
                this.displayProfilesAsText(container);
            }
        }
        this.setMessage(text);
        if (hasProfiles && this.facade == null) {
            this.displayWarning(container);
        }
        Label lblAvailable = new Label(container, 0);
        lblAvailable.setLayoutData((Object)new GridData(64, 0x1000000, true, false, 2, 1));
        String textLabel = this.getAvailableText(hasProfiles);
        lblAvailable.setText(textLabel);
        if (hasProfiles) {
            this.displayProfilesTable(container);
            this.addSelectionButton(container, Messages.SelectProfilesDialog_SelectAll, true);
            this.addSelectionButton(container, Messages.SelectProfilesDialog_DeselectAll, false);
            this.addActivationButton(container, "Activate", ProfileState.Active);
            this.addActivationButton(container, "Deactivate", ProfileState.Disabled);
            this.offlineModeBtn = this.addCheckButton(container, Messages.SelectProfilesDialog_Offline, this.offlineMode);
            this.forceUpdateBtn = this.addCheckButton(container, Messages.SelectProfilesDialog_Force_update, this.forceUpdate);
        }
        return area;
    }

    private void displayWarning(Composite container) {
        this.warningImg = new Label(container, 0x1000000);
        this.warningLabel = new Label(container, 0);
        this.warningLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.warningImg);
        this.warningImg.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.warningLabel.setText(Messages.SelectProfilesDialog_Warning_Common_profiles);
    }

    private String getAvailableText(boolean hasProfiles) {
        String textLabel = hasProfiles ? Messages.SelectProfilesDialog_Available_profiles : (this.facade == null ? NLS.bind((String)Messages.SelectProfilesDialog_No_Common_Profiles, (Object)this.facades.size()) : NLS.bind((String)Messages.SelectProfilesDialog_Project_has_no_available_profiles, (Object)this.facade.getProject().getName()));
        return textLabel;
    }

    private void displayProfilesTable(Composite container) {
        GridData gd = new GridData(4, 4, true, true, 2, 4);
        gd.heightHint = 200;
        gd.widthHint = 500;
        this.profileTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2050);
        Table table = this.profileTableViewer.getTable();
        table.setFocus();
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn profileColumn = new TableColumn(table, 0);
        profileColumn.setText(Messages.SelectProfilesDialog_Profile_id_header);
        profileColumn.setWidth(350);
        TableColumn sourceColumn = new TableColumn(table, 0);
        sourceColumn.setText(Messages.SelectProfilesDialog_Profile_source_header);
        sourceColumn.setWidth(120);
        this.profileTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.profileTableViewer.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider(container.getFont()));
        this.profileTableViewer.addCheckStateListener(event -> {
            ProfileSelection profile = (ProfileSelection)event.getElement();
            if (this.profileTableViewer.getGrayed((Object)profile)) {
                this.profileTableViewer.setGrayed((Object)profile, false);
            }
            profile.setSelected(this.profileTableViewer.getChecked((Object)profile));
            if (Boolean.FALSE.equals(profile.getSelected()) || profile.getActivationState() == null) {
                profile.setActivationState(ProfileState.Active);
            }
            this.updateProfilesAsText();
            this.profileTableViewer.refresh();
        });
        this.profileTableViewer.setInput(this.sharedProfiles);
        this.createMenu();
    }

    private void displayProfilesAsText(Composite container) {
        Label profilesLabel = new Label(container, 0);
        profilesLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        profilesLabel.setText(NLS.bind((String)Messages.SelectProfilesDialog_Active_Profiles_for_Project, (Object)this.facade.getProject().getName()));
        this.profilesText = new Text(container, 2048);
        this.profilesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.profilesText.setForeground(Display.getCurrent().getSystemColor(16));
        this.profilesText.setEditable(false);
        this.profilesText.setToolTipText(Messages.SelectProfilesDialog_Read_Only_profiles);
        this.updateProfilesAsText();
    }

    private void updateProfilesAsText() {
        if (this.profilesText != null) {
            this.profilesText.setText(ProfileUtil.toString(this.sharedProfiles));
        }
    }

    private Button addCheckButton(Composite container, String label, boolean selected) {
        Button checkBtn = new Button(container, 32);
        checkBtn.setText(label);
        checkBtn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        checkBtn.setSelection(selected);
        return checkBtn;
    }

    private Button addSelectionButton(Composite container, String label, final boolean ischecked) {
        Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectProfilesDialog.this.profileTableViewer.setAllGrayed(false);
                for (ProfileSelection profile : SelectProfilesDialog.this.sharedProfiles) {
                    SelectProfilesDialog.this.profileTableViewer.setChecked((Object)profile, ischecked);
                    profile.setSelected(ischecked);
                    if (ischecked && profile.getActivationState() != null) continue;
                    profile.setActivationState(ProfileState.Active);
                }
                SelectProfilesDialog.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    private Button addActivationButton(Composite container, String label, final ProfileState state) {
        Button button = new Button(container, 0);
        button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection s = SelectProfilesDialog.this.profileTableViewer.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)s;
                    SelectProfilesDialog.this.setActivationState(sel, state);
                }
                SelectProfilesDialog.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.profileTableViewer != null) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        if (this.profileTableViewer != null) {
            this.offlineMode = this.offlineModeBtn.getSelection();
            this.forceUpdate = this.forceUpdateBtn.getSelection();
        }
        super.okPressed();
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu contextMenu = menuMgr.createContextMenu(this.profileTableViewer.getControl());
        menuMgr.addMenuListener((IMenuListener)this);
        this.profileTableViewer.getControl().setMenu(contextMenu);
        menuMgr.setRemoveAllWhenShown(true);
        for (ProfileSelection p : this.sharedProfiles) {
            Boolean selected = p.getSelected();
            if (selected == null || p.getActivationState() == null) {
                this.profileTableViewer.setGrayed((Object)p, true);
                this.profileTableViewer.setChecked((Object)p, true);
                continue;
            }
            this.profileTableViewer.setChecked((Object)p, selected.booleanValue());
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.profileTableViewer.getSelection();
        if (!selection.isEmpty()) {
            String text;
            String selectionText;
            boolean multiSelection = selection.size() > 1;
            ProfileState state = null;
            if (multiSelection) {
                selectionText = "selected profiles";
            } else {
                ProfileSelection entry = (ProfileSelection)selection.getFirstElement();
                state = entry.getActivationState();
                selectionText = entry.getId();
            }
            if (state == null || ProfileState.Disabled.equals((Object)state)) {
                text = Messages.SelectProfilesDialog_Activate_menu;
                this.activationAction.setText(NLS.bind((String)text, (Object)selectionText));
                manager.add((IAction)this.activationAction);
            }
            if (!ProfileState.Disabled.equals((Object)state)) {
                text = Messages.SelectProfilesDialog_Deactivate_menu;
                this.deActivationAction.setText(NLS.bind((String)text, (Object)selectionText));
                manager.add((IAction)this.deActivationAction);
            }
        }
    }

    public boolean isOffline() {
        return this.offlineMode;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    private void setActivationState(IStructuredSelection sel, ProfileState state) {
        if (sel == null) {
            return;
        }
        for (Object o : sel) {
            if (!(o instanceof ProfileSelection)) continue;
            ProfileSelection ps = (ProfileSelection)o;
            ps.setActivationState(state);
            this.profileTableViewer.setGrayed((Object)ps, false);
            if (!ProfileState.Disabled.equals((Object)state)) continue;
            this.profileTableViewer.setChecked((Object)ps, true);
            ps.setSelected(true);
        }
    }

    private void refresh() {
        this.profileTableViewer.refresh();
        this.updateProfilesAsText();
    }

    private class ChangeProfileStateAction
    extends Action {
        private final ProfileState state;

        public ChangeProfileStateAction(ProfileState state) {
            this.state = state;
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)SelectProfilesDialog.this.profileTableViewer.getSelection();
            if (!selection.isEmpty()) {
                SelectProfilesDialog.this.setActivationState(selection, this.state);
                SelectProfilesDialog.this.refresh();
            }
            super.run();
        }
    }

    private class ProfileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    ITableColorProvider {
        private final Font implicitActivationFont;
        private final Color inactiveColor;

        public ProfileLabelProvider(Font defaultFont) {
            FontData[] fds;
            FontData[] fontDataArray = fds = defaultFont.getFontData();
            int n = fds.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(2);
                ++n2;
            }
            this.implicitActivationFont = new Font(defaultFont.getDevice(), fds);
            this.inactiveColor = Display.getCurrent().getSystemColor(15);
        }

        public Font getFont(Object element, int columnIndex) {
            ProfileSelection entry = (ProfileSelection)element;
            Font font = null;
            if (Boolean.TRUE.equals(entry.getAutoActive()) && PROFILE_ID_COLUMN == columnIndex) {
                font = this.implicitActivationFont;
            }
            return font;
        }

        public Color getForeground(Object element, int columnIndex) {
            ProfileSelection entry = (ProfileSelection)element;
            if (ProfileState.Disabled.equals((Object)entry.getActivationState())) {
                return this.inactiveColor;
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ProfileSelection entry = (ProfileSelection)element;
            StringBuilder text = new StringBuilder();
            if (entry != null) {
                if (columnIndex == PROFILE_ID_COLUMN) {
                    text.append(entry.getId());
                    ProfileState state = entry.getActivationState();
                    if (Boolean.TRUE.equals(entry.getSelected()) && state == ProfileState.Disabled) {
                        text.append(Messages.SelectProfilesDialog_deactivated);
                    } else if (Boolean.TRUE.equals(entry.getAutoActive())) {
                        text.append(Messages.SelectProfilesDialog_autoactivated);
                    }
                } else if (columnIndex == SOURCE_COLUMN) {
                    text.append(entry.getSource());
                }
            }
            return text.toString();
        }
    }
}

