/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.conversion;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.codehaus.plexus.util.dag.Vertex;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.project.conversion.DuplicateConversionParticipantException;
import org.eclipse.m2e.core.project.conversion.AbstractProjectConversionParticipant;
import org.eclipse.osgi.util.NLS;

public class ProjectConversionParticipantSorter {
    private List<AbstractProjectConversionParticipant> sortedConverters;

    public ProjectConversionParticipantSorter(List<AbstractProjectConversionParticipant> converters) throws CycleDetectedException, DuplicateConversionParticipantException {
        String converterId;
        if (converters == null) {
            throw new IllegalArgumentException("converters parameter can not be null");
        }
        if (converters.isEmpty()) {
            this.sortedConverters = Collections.emptyList();
            return;
        }
        if (converters.size() == 1) {
            this.sortedConverters = Collections.singletonList(converters.get(0));
            return;
        }
        DAG dag = new DAG();
        HashMap<String, AbstractProjectConversionParticipant> converterMap = new HashMap<String, AbstractProjectConversionParticipant>(converters.size());
        for (AbstractProjectConversionParticipant converter : converters) {
            converterId = converter.getId();
            AbstractProjectConversionParticipant conflictingConverter = converterMap.put(converterId, converter);
            if (conflictingConverter != null) {
                Status error = new Status(4, "org.eclipse.m2e.core", NLS.bind((String)Messages.ProjectConversion_error_duplicate_conversion_participant, (Object)converterId));
                throw new DuplicateConversionParticipantException((IStatus)error);
            }
            dag.addVertex(converterId);
        }
        for (Vertex converterVx : dag.getVertices()) {
            converterId = converterVx.getLabel();
            AbstractProjectConversionParticipant converter = (AbstractProjectConversionParticipant)converterMap.get(converterId);
            List<String> predecessors = converter.getPrecedingConverterIds();
            for (String id : predecessors) {
                Vertex predecessor = dag.getVertex(id);
                if (predecessor == null) continue;
                dag.addEdge(converterVx, predecessor);
            }
            List<String> successors = converter.getSucceedingConverterIds();
            for (String id : successors) {
                Vertex successor = dag.getVertex(id);
                if (successor == null) continue;
                dag.addEdge(successor, converterVx);
            }
        }
        List sortedConverterIds = TopologicalSorter.sort((DAG)dag);
        this.sortedConverters = sortedConverterIds.stream().map(converterMap::get).toList();
    }

    public List<AbstractProjectConversionParticipant> getSortedConverters() {
        return this.sortedConverters;
    }
}

