/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.ls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfoParams;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.MicroProfilePropertyDefinitionParams;
import org.eclipse.lsp4mp.commons.MicroProfilePropertyDocumentationParams;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.eclipse.lsp4mp.jdt.internal.core.ls.AbstractMicroProfileDelegateCommandHandler;
import org.eclipse.lsp4mp.jdt.internal.core.ls.ArgumentUtils;
import org.eclipse.lsp4mp.jdt.internal.core.ls.JDTUtilsLSImpl;

public class MicroProfileDelegateCommandHandler
extends AbstractMicroProfileDelegateCommandHandler {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileDelegateCommandHandler.class.getName());
    private static final String PROJECT_INFO_COMMAND_ID = "microprofile/projectInfo";
    private static final String PROPERTY_DEFINITION_COMMAND_ID = "microprofile/propertyDefinition";
    private static final String PROPERTY_DOCUMENTATION_COMMAND_ID = "microprofile/propertyDocumentation";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        switch (commandId) {
            case "microprofile/projectInfo": {
                return MicroProfileDelegateCommandHandler.getMicroProfileProjectInfo(arguments, commandId, progress);
            }
            case "microprofile/propertyDefinition": {
                return MicroProfileDelegateCommandHandler.findDeclaredProperty(arguments, commandId, progress);
            }
            case "microprofile/propertyDocumentation": {
                return MicroProfileDelegateCommandHandler.collectPropertyDocumentation(arguments, commandId, progress);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    private static MicroProfileProjectInfo getMicroProfileProjectInfo(List<Object> arguments, String commandId, IProgressMonitor progress) throws Exception {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileProjectInfoParams argument!", commandId));
        }
        String applicationPropertiesUri = ArgumentUtils.getString(obj, "uri");
        if (applicationPropertiesUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileProjectInfoParams.uri (application.properties URI)!", commandId));
        }
        List scopesIndex = (List)obj.get("scopes");
        ArrayList<MicroProfilePropertiesScope> scopes = new ArrayList<MicroProfilePropertiesScope>();
        for (Number scopeIndex : scopesIndex) {
            scopes.add(MicroProfilePropertiesScope.forValue(scopeIndex.intValue()));
        }
        DocumentFormat documentFormat = DocumentFormat.PlainText;
        Number documentFormatIndex = (Number)obj.get("documentFormat");
        if (documentFormatIndex != null) {
            documentFormat = DocumentFormat.forValue(documentFormatIndex.intValue());
        }
        MicroProfileProjectInfoParams params = new MicroProfileProjectInfoParams(applicationPropertiesUri);
        params.setScopes(scopes);
        params.setDocumentFormat(documentFormat);
        MicroProfileProjectInfo[] projectInfo = new MicroProfileProjectInfo[1];
        Job job = Job.create((String)"MicroProfile properties collector", monitor -> {
            microProfileProjectInfoArray[0] = PropertiesManager.getInstance().getMicroProfileProjectInfo(params, JDTUtilsLSImpl.getInstance(), monitor);
        });
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Error while joining MicroProfile properties collector job", e);
        }
        Exception jobException = (Exception)job.getResult().getException();
        if (jobException != null) {
            if (jobException.getCause() != null) {
                throw (Exception)jobException.getCause();
            }
            throw jobException;
        }
        return projectInfo[0];
    }

    private static Location findDeclaredProperty(List<Object> arguments, String commandId, IProgressMonitor progress) throws CoreException {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfilePropertyDefinitionParams argument!", commandId));
        }
        String applicationPropertiesUri = ArgumentUtils.getString(obj, "uri");
        if (applicationPropertiesUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfilePropertyDefinitionParams.uri (application.properties URI)!", commandId));
        }
        String sourceType = ArgumentUtils.getString(obj, "sourceType");
        if (sourceType == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfilePropertyDefinitionParams.sourceType!", commandId));
        }
        String sourceField = ArgumentUtils.getString(obj, "sourceField");
        String sourceMethod = ArgumentUtils.getString(obj, "sourceMethod");
        MicroProfilePropertyDefinitionParams params = new MicroProfilePropertyDefinitionParams();
        params.setUri(applicationPropertiesUri);
        params.setSourceType(sourceType);
        params.setSourceField(sourceField);
        params.setSourceMethod(sourceMethod);
        return PropertiesManager.getInstance().findPropertyLocation(params, JDTUtilsLSImpl.getInstance(), progress);
    }

    private static String collectPropertyDocumentation(List<Object> arguments, String commandId, IProgressMonitor progress) throws CoreException {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfilePropertyDocumentationParams argument!", commandId));
        }
        String applicationPropertiesUri = ArgumentUtils.getString(obj, "uri");
        if (applicationPropertiesUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfilePropertyDocumentationParams.uri (properties file URI)!", commandId));
        }
        String sourceType = ArgumentUtils.getString(obj, "sourceType");
        if (sourceType == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfilePropertyDocumentationParams.sourceType!", commandId));
        }
        DocumentFormat documentFormat = DocumentFormat.forValue(ArgumentUtils.getInt(obj, "documentFormat"));
        if (documentFormat == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfilePropertyDocumentationParams.documentFormat!", commandId));
        }
        String sourceField = ArgumentUtils.getString(obj, "sourceField");
        String sourceMethod = ArgumentUtils.getString(obj, "sourceMethod");
        MicroProfilePropertyDocumentationParams params = new MicroProfilePropertyDocumentationParams();
        params.setUri(applicationPropertiesUri);
        params.setSourceType(sourceType);
        params.setSourceField(sourceField);
        params.setSourceMethod(sourceMethod);
        params.setDocumentFormat(documentFormat);
        return PropertiesManager.getInstance().collectPropertyDocumentation(params, JDTUtilsLSImpl.getInstance(), progress);
    }
}

