/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class JavaUtils {
    private JavaUtils() {
    }

    public static IJavaProject createJavaProject(String projectName, String[] jars) throws Exception {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        JavaUtils.createJavaProject(testProject, new Path(JavaUtils.getWorkingProjectDirectory().getAbsolutePath()).append(projectName), "src", "bin", jars, (IProgressMonitor)new NullProgressMonitor());
        JavaUtils.waitForBackgroundJobs();
        return JavaCore.create((IProject)testProject);
    }

    private static void waitForBackgroundJobs() {
    }

    private static IProject createJavaProject(IProject project, IPath projectLocation, String src, String bin, String[] jars, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (project.exists()) {
            return project;
        }
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        if (projectLocation != null) {
            description.setLocation(projectLocation);
        }
        project.create(description, monitor);
        project.open(monitor);
        description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (StringUtils.isNotBlank((CharSequence)bin)) {
            IFolder output = project.getFolder(bin);
            if (!output.exists()) {
                output.create(true, true, monitor);
            }
            javaProject.setOutputLocation(output.getFullPath(), monitor);
        }
        ArrayList<IClasspathEntry> classpaths = new ArrayList<IClasspathEntry>();
        if (StringUtils.isNotBlank((CharSequence)src)) {
            IFolder source = project.getFolder(src);
            if (!source.exists()) {
                source.create(true, true, monitor);
            }
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)source);
            IClasspathEntry srcClasspath = JavaCore.newSourceEntry((IPath)root.getPath());
            classpaths.add(srcClasspath);
        }
        if (jars != null) {
            String[] stringArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                String jar = stringArray[n2];
                IPackageFragmentRoot root = javaProject.getPackageFragmentRoot(jar);
                IClasspathEntry libClasspath = JavaCore.newLibraryEntry((IPath)root.getPath(), null, null);
                classpaths.add(libClasspath);
                ++n2;
            }
        }
        javaProject.setRawClasspath(classpaths.toArray(new IClasspathEntry[0]), monitor);
        return project;
    }

    public static File getWorkingProjectDirectory() throws IOException {
        File dir = new File("target", "workingProjects");
        FileUtils.forceMkdir((File)dir);
        return dir;
    }

    public static String getJarPath(String jar) {
        java.nio.file.Path jarPath = Paths.get("jars", jar);
        return jarPath.toAbsolutePath().toString();
    }
}

