/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.config;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.junit.After;
import org.junit.Test;

public class MicroProfileConfigJavaDefinitionTest
extends BasePropertiesManagerTest {
    private static IJavaProject javaProject;

    @After
    public void cleanup() throws JavaModelException, IOException {
        MicroProfileConfigJavaDefinitionTest.deleteFile("application.yaml", javaProject);
        MicroProfileConfigJavaDefinitionTest.deleteFile("application.properties", javaProject);
        MicroProfileConfigJavaDefinitionTest.deleteFile("META-INF/microprofile-config.properties", javaProject);
    }

    @Test
    public void configPropertyNameDefinition() throws Exception {
        javaProject = MicroProfileConfigJavaDefinitionTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/application.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaDefinitionTest.saveFile("application.properties", "greeting.message = hello\r\ngreeting.name = quarkus\r\ngreeting.number = 100", javaProject);
        MicroProfileForJavaAssert.assertJavaDefinitions(MicroProfileForJavaAssert.p(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.def(MicroProfileForJavaAssert.r(14, 28, 44), propertiesFileUri, "greeting.message"));
        MicroProfileForJavaAssert.assertJavaDefinitions(MicroProfileForJavaAssert.p(14, 28), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.def(MicroProfileForJavaAssert.r(14, 28, 44), propertiesFileUri, "greeting.message"));
        MicroProfileForJavaAssert.assertJavaDefinitions(MicroProfileForJavaAssert.p(14, 43), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.def(MicroProfileForJavaAssert.r(14, 28, 44), propertiesFileUri, "greeting.message"));
        MicroProfileForJavaAssert.assertJavaDefinitions(MicroProfileForJavaAssert.p(14, 27), javaFileUri, JDT_UTILS, new MicroProfileDefinition[0]);
        MicroProfileForJavaAssert.assertJavaDefinitions(MicroProfileForJavaAssert.p(14, 44), javaFileUri, JDT_UTILS, new MicroProfileDefinition[0]);
        MicroProfileForJavaAssert.assertJavaDefinitions(MicroProfileForJavaAssert.p(26, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.def(MicroProfileForJavaAssert.r(26, 28, 43), propertiesFileUri, "greeting.number"));
        MicroProfileForJavaAssert.assertJavaDefinitions(MicroProfileForJavaAssert.p(23, 33), javaFileUri, JDT_UTILS, new MicroProfileDefinition[0]);
    }
}

