/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.metadata.ItemBase;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.junit.Assert;

public class MicroProfileAssert {
    public static void assertProperties(MicroProfileProjectInfo info, ItemMetadata ... expected) {
        MicroProfileAssert.assertProperties(info, null, expected);
    }

    public static void assertProperties(MicroProfileProjectInfo info, Integer expectedCount, ItemMetadata ... expected) {
        if (expectedCount != null) {
            Assert.assertEquals((long)expectedCount.intValue(), (long)info.getProperties().size());
        }
        ItemMetadata[] itemMetadataArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            ItemMetadata item = itemMetadataArray[n2];
            MicroProfileAssert.assertProperty(info, item);
            ++n2;
        }
    }

    private static void assertProperty(MicroProfileProjectInfo info, ItemMetadata expected) {
        List matches = info.getProperties().stream().filter(completion -> expected.getName().equals(completion.getName())).collect(Collectors.toList());
        Assert.assertEquals((String)(String.valueOf(expected.getName()) + " should only exist once: Actual: " + info.getProperties().stream().map(c -> c.getName()).collect(Collectors.joining(","))), (long)1L, (long)matches.size());
        ItemMetadata actual = (ItemMetadata)matches.get(0);
        Assert.assertEquals((String)("Test 'extension name' for '" + expected.getName() + "'"), (Object)expected.getExtensionName(), (Object)actual.getExtensionName());
        Assert.assertEquals((String)("Test 'type' for '" + expected.getName() + "'"), (Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((String)("Test 'description' for '" + expected.getName() + "'"), (Object)expected.getDescription(), (Object)actual.getDescription());
        Assert.assertEquals((String)("Test 'binary' for '" + expected.getName() + "'"), (Object)expected.isBinary(), (Object)actual.isBinary());
        Assert.assertEquals((String)("Test 'source type' for '" + expected.getName() + "'"), (Object)expected.getSourceType(), (Object)actual.getSourceType());
        Assert.assertEquals((String)("Test 'source field' for '" + expected.getName() + "'"), (Object)expected.getSourceField(), (Object)actual.getSourceField());
        Assert.assertEquals((String)("Test 'source method' for '" + expected.getName() + "'"), (Object)expected.getSourceMethod(), (Object)actual.getSourceMethod());
        Assert.assertEquals((String)("Test 'phase' for '" + expected.getName() + "'"), (long)expected.getPhase(), (long)actual.getPhase());
        Assert.assertEquals((String)("Test 'default value' for '" + expected.getName() + "'"), (Object)expected.getDefaultValue(), (Object)actual.getDefaultValue());
    }

    public static ItemMetadata p(String extensionName, String name, String type, String description, boolean binary, String sourceType, String sourceField, String sourceMethod, int phase, String defaultValue) {
        ItemMetadata item = new ItemMetadata();
        item.setExtensionName(extensionName);
        item.setName(name);
        item.setType(type);
        item.setDescription(description);
        item.setSource(Boolean.valueOf(!binary));
        item.setSourceType(sourceType);
        item.setSourceMethod(sourceMethod);
        item.setSourceField(sourceField);
        item.setPhase(phase);
        item.setDefaultValue(defaultValue);
        return item;
    }

    public static void assertPropertiesDuplicate(MicroProfileProjectInfo info) {
        Map<String, Long> propertiesCount = info.getProperties().stream().collect(Collectors.groupingBy(ItemBase::getName, Collectors.counting()));
        List result = propertiesCount.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).collect(Collectors.toList());
        Assert.assertEquals((String)result.stream().map(entry -> String.valueOf((String)entry.getKey()) + "=" + entry.getValue()).collect(Collectors.joining(",")), (long)0L, (long)result.size());
    }

    public static void assertHints(MicroProfileProjectInfo info, ItemHint ... expected) {
        MicroProfileAssert.assertHints(info, null, expected);
    }

    public static void assertHints(MicroProfileProjectInfo info, Integer expectedCount, ItemHint ... expected) {
        if (expectedCount != null) {
            Assert.assertEquals((long)expectedCount.intValue(), (long)info.getHints().size());
        }
        ItemHint[] itemHintArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            ItemHint item = itemHintArray[n2];
            MicroProfileAssert.assertHint(info, item);
            ++n2;
        }
    }

    private static void assertHint(MicroProfileProjectInfo info, ItemHint expected) {
        List matches = info.getHints().stream().filter(completion -> expected.getName().equals(completion.getName())).collect(Collectors.toList());
        Assert.assertEquals((String)(String.valueOf(expected.getName()) + " should only exist once: Actual: " + info.getHints().stream().map(c -> c.getName()).collect(Collectors.joining(","))), (long)1L, (long)matches.size());
        ItemHint actual = (ItemHint)matches.get(0);
        Assert.assertEquals((String)("Test 'description' for '" + expected.getName() + "'"), (Object)expected.getDescription(), (Object)actual.getDescription());
    }

    public static ItemHint h(String name, String description, boolean binary, String sourceType, ItemHint.ValueHint ... values) {
        ItemHint item = new ItemHint();
        item.setName(name);
        if (!binary) {
            item.setSource(Boolean.TRUE);
        }
        item.setDescription(description);
        item.setSourceType(sourceType);
        if (values != null) {
            item.setValues(Arrays.asList(values));
        }
        return item;
    }

    public static ItemHint.ValueHint vh(String value, String description, String sourceType) {
        ItemHint.ValueHint vh = new ItemHint.ValueHint();
        vh.setValue(value);
        vh.setDescription(description);
        vh.setSourceType(sourceType);
        return vh;
    }

    public static void assertHintsDuplicate(MicroProfileProjectInfo info) {
        Map<String, Long> hintsCount = info.getHints().stream().collect(Collectors.groupingBy(ItemBase::getName, Collectors.counting()));
        List result = hintsCount.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).collect(Collectors.toList());
        Assert.assertEquals((String)result.stream().map(entry -> String.valueOf((String)entry.getKey()) + "=" + entry.getValue()).collect(Collectors.joining(",")), (long)0L, (long)result.size());
    }
}

