/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.util.Ranges;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.java.hover.IJavaHoverParticipant;
import org.eclipse.lsp4mp.jdt.core.java.hover.JavaHoverContext;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileConfigHoverParticipant
implements IJavaHoverParticipant {
    @Override
    public boolean isAdaptedForHover(JavaHoverContext context, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.config.inject.ConfigProperty") != null;
    }

    @Override
    public Hover collectHover(JavaHoverContext context, IProgressMonitor monitor) throws CoreException {
        IJavaElement hoverElement = context.getHoverElement();
        if (hoverElement.getElementType() != 8 && hoverElement.getElementType() != 14) {
            return null;
        }
        ITypeRoot typeRoot = context.getTypeRoot();
        IJDTUtils utils = context.getUtils();
        Position hoverPosition = context.getHoverPosition();
        IAnnotatable hoverField = (IAnnotatable)hoverElement;
        IAnnotation annotation = AnnotationUtils.getAnnotation(hoverField, "org.eclipse.microprofile.config.inject.ConfigProperty");
        if (annotation == null) {
            return null;
        }
        String annotationSource = annotation.getSource();
        String propertyKey = AnnotationUtils.getAnnotationMemberValue(annotation, "name");
        if (propertyKey == null) {
            return null;
        }
        ISourceRange r = annotation.getSourceRange();
        int offset = annotationSource.indexOf(propertyKey);
        Range propertyKeyRange = utils.toRange((IOpenable)typeRoot, r.getOffset() + offset, propertyKey.length());
        if (hoverPosition.equals((Object)propertyKeyRange.getEnd()) || !Ranges.containsPosition((Range)propertyKeyRange, (Position)hoverPosition)) {
            return null;
        }
        IJavaProject javaProject = typeRoot.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        String propertyValue = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(javaProject).getProperty(propertyKey, null);
        if (propertyValue == null && (propertyValue = AnnotationUtils.getAnnotationMemberValue(annotation, "defaultValue")) != null && propertyValue.length() == 0) {
            propertyValue = null;
        }
        DocumentFormat documentFormat = context.getDocumentFormat();
        return new Hover(MicroProfileConfigHoverParticipant.getDocumentation(propertyKey, propertyValue, documentFormat, true), propertyKeyRange);
    }

    public static MarkupContent getDocumentation(String propertyKey, String propertyValue, DocumentFormat documentFormat, boolean insertSpacing) {
        boolean markdown = DocumentFormat.Markdown.equals((Object)documentFormat);
        StringBuilder content = new StringBuilder();
        if (markdown) {
            content.append("`");
        }
        content.append(propertyKey);
        if (propertyValue == null) {
            if (markdown) {
                content.append("`");
            }
            content.append(" is not set.");
        } else {
            if (insertSpacing) {
                content.append(" = ");
            } else {
                content.append("=");
            }
            content.append(propertyValue);
            if (markdown) {
                content.append("`");
            }
        }
        return new MarkupContent(markdown ? "markdown" : "plaintext", content.toString());
    }
}

