/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;
import org.eclipse.lsp4mp.commons.metadata.ConfigurationMetadata;
import org.eclipse.lsp4mp.jdt.core.AbstractPropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;

public abstract class AbstractStaticPropertiesProvider
extends AbstractPropertiesProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractStaticPropertiesProvider.class.getName());
    private static final String PLATFORM_PLUGIN = "platform:/plugin/";
    private final String pluginId;
    private final String path;
    private ConfigurationMetadata metadata;

    public AbstractStaticPropertiesProvider(String pluginId, String path) {
        this.pluginId = pluginId;
        this.path = path;
    }

    @Override
    public final void endSearch(SearchContext context, IProgressMonitor monitor) {
        if (this.isAdaptedFor(context, monitor)) {
            this.collectStaticProperties(context, monitor);
        }
    }

    protected abstract boolean isAdaptedFor(SearchContext var1, IProgressMonitor var2);

    protected void collectStaticProperties(SearchContext context, IProgressMonitor monitor) {
        if (this.metadata == null) {
            try {
                this.metadata = this.getMetadata();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "In AbstractStaticPropertiesProvider#collectStaticProperties, IOException", e);
            }
        }
        if (this.metadata != null) {
            context.getCollector().merge(this.metadata, IPropertiesCollector.MergingStrategy.IGNORE_IF_EXISTS);
        }
    }

    protected ConfigurationMetadata getMetadata() throws IOException {
        InputStream in = this.getInputStream();
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8.name());
        return (ConfigurationMetadata)AbstractStaticPropertiesProvider.createGson().fromJson((Reader)reader, ConfigurationMetadata.class);
    }

    protected InputStream getInputStream() throws IOException {
        if (this.path == null || this.path.length() < 0) {
            return null;
        }
        if (this.pluginId != null) {
            URL url = new URL(PLATFORM_PLUGIN + this.pluginId + "/" + this.path);
            return url.openStream();
        }
        return new FileInputStream(new File(this.path));
    }

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).create();
    }

    @Override
    public void collectProperties(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
    }

    @Override
    protected String[] getPatterns() {
        return null;
    }

    @Override
    protected SearchPattern createSearchPattern(String pattern) {
        return null;
    }
}

