/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.server;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageServer;

public interface StreamConnectionProvider {
    public void start() throws IOException;

    public @Nullable InputStream getInputStream();

    public @Nullable OutputStream getOutputStream();

    public @Nullable InputStream getErrorStream();

    default public @Nullable InputStream forwardCopyTo(@Nullable InputStream input, final @Nullable OutputStream output) {
        if (input == null) {
            return null;
        }
        if (output == null) {
            return input;
        }
        FilterInputStream filterInput = new FilterInputStream(input){

            @Override
            public int read() throws IOException {
                int res = super.read();
                if (res == -1) {
                    return -1;
                }
                output.write(res);
                return res;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int bytes = super.read(b, off, len);
                if (bytes == -1) {
                    return -1;
                }
                if (bytes == 0) {
                    return 0;
                }
                output.write(b, off, bytes);
                return bytes;
            }
        };
        return filterInput;
    }

    default public @Nullable Object getInitializationOptions(@Nullable URI rootUri) {
        return null;
    }

    default public @Nullable Object getExperimentalFeaturesPOJO() {
        return null;
    }

    default public String getTrace(@Nullable URI rootUri) {
        return "off";
    }

    public void stop();

    default public void handleMessage(Message message, LanguageServer languageServer, @Nullable URI rootURI) {
    }
}

