/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.jdt;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.jdt.LSJavaProposal;
import org.eclipse.lsp4e.jdt.LSJavaProposalExtension;
import org.eclipse.lsp4e.jdt.LSJavaProposalExtension2;
import org.eclipse.lsp4e.jdt.Messages;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;

public class LSJavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private static final long TIMEOUT_LENGTH = 300L;
    private final LSContentAssistProcessor lsContentAssistProcessor = new LSContentAssistProcessor(false);
    private @Nullable String javaCompletionSpecificErrorMessage;

    public void sessionStarted() {
    }

    @NonNullByDefault(value={})
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        CompletableFuture<ICompletionProposal[]> future = CompletableFuture.supplyAsync(() -> this.lsContentAssistProcessor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset()));
        try {
            return List.of(this.asJavaProposals(future));
        }
        catch (ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError((Throwable)e);
            this.javaCompletionSpecificErrorMessage = this.createErrorMessage(e);
            return Collections.emptyList();
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError((Throwable)e);
            this.javaCompletionSpecificErrorMessage = this.createErrorMessage(e);
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
    }

    private String createErrorMessage(Exception ex) {
        return Messages.javaSpecificCompletionError + " : " + (ex.getMessage() != null ? ex.getMessage() : ex.toString());
    }

    private ICompletionProposal[] asJavaProposals(CompletableFuture<ICompletionProposal[]> future) throws InterruptedException, ExecutionException, TimeoutException {
        ICompletionProposal[] originalProposals = future.get(300L, TIMEOUT_UNIT);
        ICompletionProposal[] javaProposals = new ICompletionProposal[originalProposals.length];
        int i = 0;
        while (i < originalProposals.length) {
            javaProposals[i] = originalProposals[i] instanceof ICompletionProposalExtension2 ? new LSJavaProposalExtension2(originalProposals[i]) : (originalProposals[i] instanceof ICompletionProposalExtension ? new LSJavaProposalExtension(originalProposals[i]) : new LSJavaProposal(originalProposals[i]));
            ++i;
        }
        return javaProposals;
    }

    @NonNullByDefault(value={})
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IContextInformation[] contextInformation = this.lsContentAssistProcessor.computeContextInformation(context.getViewer(), context.getInvocationOffset());
        return contextInformation == null ? List.of() : List.of(contextInformation);
    }

    public @Nullable String getErrorMessage() {
        return this.javaCompletionSpecificErrorMessage != null ? this.javaCompletionSpecificErrorMessage : this.lsContentAssistProcessor.getErrorMessage();
    }

    public void sessionEnded() {
    }
}

