/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.semanticTokens.SemanticHighlightReconcilerStrategy;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SemanticTokensLegendProviderTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(this.getClass().getName() + System.currentTimeMillis());
    }

    @Test
    public void testSemanticTokensLegendProvider() throws CoreException, IOException {
        List<String> tokenTypes = Arrays.asList("keyword", "other");
        List<String> tokenModifiers = Arrays.asList("obsolete");
        SemanticTokensTestUtil.setSemanticTokensLegend(tokenTypes, tokenModifiers);
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt", "test content");
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)file, c -> Boolean.TRUE).iterator().next();
        SemanticTokensLegend semanticTokensLegend = new SemanticHighlightReconcilerStrategy().getSemanticTokensLegend(wrapper);
        Assert.assertNotNull((Object)semanticTokensLegend);
        Assert.assertEquals(tokenTypes, (Object)semanticTokensLegend.getTokenTypes());
        Assert.assertEquals(tokenModifiers, (Object)semanticTokensLegend.getTokenModifiers());
    }
}

