/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SemanticHighlightReconcilerStrategyTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;
    private Shell shell;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(this.getClass().getName() + System.currentTimeMillis());
        this.shell = new Shell();
        List<String> tokenTypes = Arrays.asList("keyword");
        List<String> tokenModifiers = Arrays.asList("obsolete");
        SemanticTokensTestUtil.setSemanticTokensLegend(tokenTypes, tokenModifiers);
    }

    @Test
    public void testKeyword() throws CoreException {
        SemanticTokens semanticTokens = new SemanticTokens();
        semanticTokens.setData(SemanticTokensTestUtil.keywordSemanticTokens());
        MockLanguageServer.INSTANCE.getTextDocumentService().setSemanticTokens(semanticTokens);
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt", "type foo {\n\t\n}\ntype bar extends foo {\n\t\n}\n");
        ITextViewer textViewer = TestUtils.openTextViewer(file);
        Display display = this.shell.getDisplay();
        DisplayHelper.sleep((Display)display, (long)2000L);
        Object[] styleRanges = textViewer.getTextWidget().getStyleRanges();
        List<StyleRange> expectedStyleRanges = Arrays.asList(new StyleRange(0, 4, SemanticTokensTestUtil.GREEN, null), new StyleRange(15, 4, SemanticTokensTestUtil.GREEN, null), new StyleRange(24, 7, SemanticTokensTestUtil.GREEN, null));
        Assert.assertArrayEquals((Object[])expectedStyleRanges.toArray(), (Object[])styleRanges);
    }
}

