/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.operations.references.URIMatch;
import org.eclipse.search.internal.ui.text.DecoratingFileSearchLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class FileAndURIMatchLabelProvider
extends DecoratingStyledCellLabelProvider {
    private final DecoratingFileSearchLabelProvider fileMatchLabelProvider;

    public FileAndURIMatchLabelProvider(FileAndURIMatchBaseLabelProvider baseLabelProvider, DecoratingFileSearchLabelProvider fileMatchLabelProvider) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)baseLabelProvider, fileMatchLabelProvider.getLabelDecorator(), fileMatchLabelProvider.getDecorationContext());
        this.fileMatchLabelProvider = fileMatchLabelProvider;
    }

    public static class FileAndURIMatchBaseLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private DelegatingStyledCellLabelProvider.IStyledLabelProvider resourceMatchDelegate;

        public FileAndURIMatchBaseLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider styledStringProvider) {
            this.resourceMatchDelegate = styledStringProvider;
        }

        public void addListener(ILabelProviderListener listener) {
            this.resourceMatchDelegate.addListener(listener);
        }

        public void dispose() {
            this.resourceMatchDelegate.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            if (this.canDelegate(element)) {
                return this.resourceMatchDelegate.isLabelProperty(element, property);
            }
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.resourceMatchDelegate.removeListener(listener);
        }

        /*
         * WARNING - void declaration
         */
        public StyledString getStyledText(Object element) {
            if (this.canDelegate(element)) {
                return this.resourceMatchDelegate.getStyledText(element);
            }
            Object object = element;
            if (object instanceof URI) {
                void uri;
                URI uRI = (URI)object;
                URI cfr_ignored_0 = (URI)object;
                if ("file".equals(uri.getScheme())) {
                    return new StyledString(uri.getPath());
                }
                try {
                    URI trimmedURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment());
                    StyledString res = new StyledString(trimmedURI.toString());
                    if (uri.getQuery() != null) {
                        res.append("?" + uri.getRawQuery(), StyledString.QUALIFIER_STYLER);
                    }
                    return res;
                }
                catch (URISyntaxException ex) {
                    return new StyledString(uri.toString());
                }
            }
            Object object2 = element;
            if (object2 instanceof URIMatch) {
                void match;
                URIMatch ex = (URIMatch)((Object)object2);
                URIMatch cfr_ignored_1 = (URIMatch)((Object)object2);
                return new StyledString(String.valueOf(match.getOffset()) + ".." + (match.getOffset() + match.getLength()));
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Image getImage(Object element) {
            if (this.canDelegate(element)) {
                return this.resourceMatchDelegate.getImage(element);
            }
            Object object = element;
            if (object instanceof URI) {
                void uri;
                URI uRI = (URI)object;
                URI cfr_ignored_0 = (URI)object;
                if ("file".equals(uri.getScheme())) {
                    File file = new File((URI)uri);
                    if (file.isDirectory()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    }
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
            }
            return null;
        }

        private boolean canDelegate(Object element) {
            return !(element instanceof URI) && !(element instanceof URIMatch);
        }
    }
}

