/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.linkedediting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LinkedEditingTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("LinkedEditingTest" + System.currentTimeMillis());
    }

    @Test
    public void testLinkedEditing() throws CoreException {
        Annotation annotation;
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(new Position(1, 3), new Position(1, 7)));
        ranges.add(new Range(new Position(3, 4), new Position(3, 8)));
        LinkedEditingRanges linkkedEditingRanges = new LinkedEditingRanges(ranges);
        MockLanguageServer.INSTANCE.setLinkedEditingRanges(linkkedEditingRanges);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "<html>\n  <body>\n    a body text\n  </body>\n</html>");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        viewer.getTextWidget().setCaretOffset(11);
        if (!(viewer instanceof ISourceViewer)) {
            Assert.fail();
        }
        ISourceViewer sourceViewer = (ISourceViewer)viewer;
        viewer.getTextWidget().setSelection(11);
        HashMap<org.eclipse.jface.text.Position, Annotation> annotations = new HashMap<org.eclipse.jface.text.Position, Annotation>();
        TestUtils.waitForAndAssertCondition(3000, () -> {
            Iterator iterator = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!annotation.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")) continue;
                return true;
            }
            return false;
        });
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            annotation = (Annotation)iterator.next();
            annotations.put(model.getPosition(annotation), annotation);
        }
        annotation = (Annotation)annotations.get(new LinkedPosition(sourceViewer.getDocument(), 10, 4, 0));
        Assert.assertNotNull((Object)annotation);
        Assert.assertTrue((boolean)annotation.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link"));
    }

    @Test
    public void testLinkedEditingExitPolicy() throws CoreException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(new Position(1, 3), new Position(1, 7)));
        ranges.add(new Range(new Position(3, 4), new Position(3, 8)));
        LinkedEditingRanges linkkedEditingRanges = new LinkedEditingRanges(ranges, "[:A-Z_a-z]*\\Z");
        MockLanguageServer.INSTANCE.setLinkedEditingRanges(linkkedEditingRanges);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "<html>\n  <body class=\"test\">\n    a body text\n  </body>\n</html>");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        if (!(viewer instanceof ISourceViewer)) {
            Assert.fail();
        }
        ISourceViewer sourceViewer = (ISourceViewer)viewer;
        viewer.getTextWidget().setCaretOffset(14);
        viewer.getTextWidget().setSelection(14);
        TestUtils.waitForAndAssertCondition(3000, () -> {
            Iterator iterator = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!annotation.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")) continue;
                return true;
            }
            return false;
        });
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        List<Annotation> annotations = this.findAnnotations(sourceViewer, 14).stream().filter(a -> a.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")).toList();
        Assert.assertEquals((String)("Exepected only 1 link annotation here, got " + annotations), (long)1L, (long)annotations.size());
        Annotation masterAnnotation = this.findAnnotation(sourceViewer, "org.eclipse.ui.internal.workbench.texteditor.link.master");
        Assert.assertNotNull((Object)masterAnnotation);
        Assert.assertTrue((boolean)annotations.contains(masterAnnotation));
        org.eclipse.jface.text.Position masterPosition = model.getPosition(masterAnnotation);
        Assert.assertNotNull((Object)masterPosition);
        Annotation slaveAnnotation = this.findAnnotation(sourceViewer, "org.eclipse.ui.internal.workbench.texteditor.link.slave");
        Assert.assertNotNull((Object)slaveAnnotation);
        org.eclipse.jface.text.Position slavePosition = model.getPosition(slaveAnnotation);
        Assert.assertNotNull((Object)slavePosition);
        Assert.assertEquals((Object)viewer.getTextWidget().getTextRange(masterPosition.getOffset(), masterPosition.getLength()), (Object)viewer.getTextWidget().getTextRange(slavePosition.getOffset(), slavePosition.getLength()));
        viewer.getTextWidget().setCaretOffset(15);
        viewer.getTextWidget().setSelection(15);
        TestUtils.waitForAndAssertCondition(3000, () -> {
            Iterator iterator = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!annotation.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")) continue;
                return true;
            }
            return false;
        });
        model = sourceViewer.getAnnotationModel();
        Assert.assertFalse((boolean)this.findAnnotations(sourceViewer, 15).stream().anyMatch(a -> a.getType().startsWith("org.eclipse.ui.internal.workbench.texteditor.link")));
    }

    private List<Annotation> findAnnotations(ISourceViewer sourceViewer, int offset) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            org.eclipse.jface.text.Position position = model.getPosition(annotation);
            if (position == null || !position.includes(offset)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    private Annotation findAnnotation(ISourceViewer sourceViewer, String type) {
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (annotation.getType() == null || !annotation.getType().equals(type)) continue;
            return annotation;
        }
        return null;
    }
}

