/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.highlight;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class HighlightTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("HighlightTest" + System.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighlight() throws CoreException {
        ITextViewer viewer;
        this.checkGenericEditorVersion();
        MockLanguageServer.INSTANCE.setDocumentHighlights(List.of(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read), new DocumentHighlight(new Range(new Position(0, 7), new Position(0, 12)), DocumentHighlightKind.Write), new DocumentHighlight(new Range(new Position(0, 13), new Position(0, 17)), DocumentHighlightKind.Text)));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer iTextViewer = viewer = TestUtils.openTextViewer(testFile);
        if (iTextViewer instanceof ISourceViewer) {
            void sourceViewer;
            ISourceViewer iSourceViewer = (ISourceViewer)iTextViewer;
            ISourceViewer cfr_ignored_0 = (ISourceViewer)iTextViewer;
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            sourceViewer.getTextWidget().setCaretOffset(1);
            TestUtils.waitForAndAssertCondition(3000, () -> {
                this.assertHasAnnotion(annotationModel, "org.eclipse.lsp4e.read", 2, 4);
                this.assertHasAnnotion(annotationModel, "org.eclipse.lsp4e.write", 7, 5);
                this.assertHasAnnotion(annotationModel, "org.eclipse.lsp4e.text", 13, 4);
                return true;
            });
        } else {
            Assert.fail((String)("ISourceViewer expected but got: " + viewer));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCheckIfOtherAnnotationsRemains() throws CoreException {
        ITextViewer viewer;
        this.checkGenericEditorVersion();
        MockLanguageServer.INSTANCE.setDocumentHighlights(List.of(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read)));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer iTextViewer = viewer = TestUtils.openTextViewer(testFile);
        if (iTextViewer instanceof ISourceViewer) {
            void sourceViewer;
            ISourceViewer iSourceViewer = (ISourceViewer)iTextViewer;
            ISourceViewer cfr_ignored_0 = (ISourceViewer)iTextViewer;
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            String fakeAnnotationType = "FAKE_TYPE";
            Annotation fakeAnnotation = new Annotation("FAKE_TYPE", false, null);
            org.eclipse.jface.text.Position fakeAnnotationPosition = new org.eclipse.jface.text.Position(0, 10);
            annotationModel.addAnnotation(fakeAnnotation, fakeAnnotationPosition);
            viewer.getTextWidget().setCaretOffset(1);
            TestUtils.waitForAndAssertCondition(3000, () -> {
                this.assertHasAnnotion(annotationModel, "org.eclipse.lsp4e.read", 2, 4);
                this.assertHasAnnotion(annotationModel, "FAKE_TYPE", position.offset, position.length);
                return true;
            });
        }
    }

    private void assertHasAnnotion(IAnnotationModel annotationModel, String annotationType, int posOffset, int posLen) {
        boolean[] hasAnnotation = new boolean[1];
        ArrayList annotations = new ArrayList();
        annotationModel.getAnnotationIterator().forEachRemaining(anno -> {
            org.eclipse.jface.text.Position annoPos = annotationModel.getPosition(anno);
            if (anno.getType().equals(annotationType) && annoPos.offset == posOffset && annoPos.length == posLen) {
                blArray[0] = true;
            }
            annotations.add("Annotation[type=" + anno.getType() + ", text=" + anno.getText() + ", offset=" + annoPos.offset + ", length=" + annoPos.length + "]");
        });
        if (!hasAnnotation[0]) {
            Assert.fail((String)("Annotation of type [" + annotationType + "] not found at position {offset=" + posOffset + " length=" + posLen + "}. Annotations found: " + annotations));
        }
    }

    private void checkGenericEditorVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.genericeditor");
        Assume.assumeTrue((bundle.getVersion().compareTo(new Version(1, 1, 0)) >= 0 ? 1 : 0) != 0);
    }
}

