/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.NoErrorLoggedRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;

public class LSPEclipseUtilsTest {
    @Rule
    public NoErrorLoggedRule rule = new NoErrorLoggedRule(LanguageServerPlugin.getDefault().getLog());
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Test
    public void testOpenInEditorExternalFile() throws Exception {
        File externalFile = TestUtils.createTempFile("externalFile", ".txt");
        Location location = new Location(LSPEclipseUtils.toUri((File)externalFile).toString(), new Range(new Position(0, 0), new Position(0, 0)));
        LSPEclipseUtils.openInEditor((Location)location, (IWorkbenchPage)UI.getActivePage());
    }

    @Test
    public void testWorkspaceEdit_insertText() throws Exception {
        TextEdit textEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "insert");
        AbstractTextEditor editor = this.applyWorkspaceTextEdit(textEdit);
        Assert.assertEquals((Object)"insertHere", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
        Assert.assertEquals((Object)"insertHere", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
    }

    @Test
    public void testWorkspaceEdit_WithExaggeratedRange() throws Exception {
        TextEdit textEdit = new TextEdit(new Range(new Position(0, 0), new Position(Integer.MAX_VALUE, Integer.MAX_VALUE)), "insert");
        AbstractTextEditor editor = this.applyWorkspaceTextEdit(textEdit);
        Assert.assertEquals((Object)"insert", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
        Assert.assertEquals((Object)"insert", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
    }

    private AbstractTextEditor applyWorkspaceTextEdit(TextEdit textEdit) throws CoreException, PartInitException {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createFile(p, "dummy" + new Random().nextInt(), "Here");
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonMap(LSPEclipseUtils.toUri((IResource)f).toString(), Collections.singletonList(textEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
        return editor;
    }

    @Test
    public void testWorkspaceEditMultipleChanges() throws Exception {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile f = TestUtils.createFile(p, "dummy", "Here\nHere2");
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        LinkedList<TextEdit> edits = new LinkedList<TextEdit>();
        edits.add(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "abc"));
        edits.add(new TextEdit(new Range(new Position(1, 0), new Position(1, 0)), "abc"));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonMap(LSPEclipseUtils.toUri((IResource)f).toString(), edits));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
        Assert.assertEquals((Object)"abcHere\nabcHere2", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
        Assert.assertEquals((Object)"abcHere\nabcHere2", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
    }

    @Test
    public void testWorkspaceEdit_CreateAndPopulateFile() throws Exception {
        IProject p = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile file = p.getFile("test-file.test");
        LinkedList<Either> edits = new LinkedList<Either>();
        String uri = file.getLocation().toFile().toURI().toString();
        edits.add(Either.forRight((Object)new CreateFile(uri)));
        edits.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "abcHere\nabcHere2")))));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(edits);
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertEquals((Object)"abcHere\nabcHere2", (Object)new String(Files.readAllBytes(file.getLocation().toFile().toPath())));
    }

    @Test
    public void testURIToResourceMapping() throws CoreException {
        IProject project1 = null;
        IProject project2 = null;
        project1 = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile file = project1.getFile("res");
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)file, (Object)LSPEclipseUtils.findResourceFor((String)file.getLocationURI().toString()));
        project1.getFile("suffix").create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        project2 = TestUtils.createProject(String.valueOf(project1.getName()) + "suffix");
        Assert.assertEquals((Object)project2, (Object)LSPEclipseUtils.findResourceFor((String)project2.getLocationURI().toString()));
    }

    @Test
    public void testReturnMostNestedFileRegardlessArrayOrder() throws CoreException {
        IProject project1 = null;
        project1 = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile mostNestedFile = project1.getFile("res");
        mostNestedFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        IFolder folder = project1.getFolder("folder");
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile someFile = project1.getFile("folder/res");
        someFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)mostNestedFile, (Object)LSPEclipseUtils.findMostNested((IFile[])new IFile[]{mostNestedFile, someFile}));
        Assert.assertEquals((Object)mostNestedFile, (Object)LSPEclipseUtils.findMostNested((IFile[])new IFile[]{someFile, mostNestedFile}));
    }

    @Test
    public void testLinkedResourceURIToResourceMapping() throws CoreException, IOException {
        IProject project1 = null;
        Path externalFile = null;
        Path externalFolder = null;
        externalFile = Files.createTempFile("tmp_file-", null, new FileAttribute[0]);
        externalFolder = Files.createTempDirectory("tmp_dir-", new FileAttribute[0]);
        project1 = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile linkedFile = project1.getFile("linked_file");
        linkedFile.createLink(externalFile.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)linkedFile.isLinked());
        Assert.assertEquals((Object)linkedFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFile.getLocationURI().toString()));
        IFolder linkedFolder = project1.getFolder("linked_folder");
        linkedFolder.createLink(externalFolder.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)linkedFolder.isLinked());
        Assert.assertEquals((Object)linkedFolder, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolder.getLocationURI().toString()));
        Files.createFile(externalFolder.resolve("child"), new FileAttribute[0]);
        IFile linkedFolderFile = linkedFolder.getFile("child");
        Assert.assertEquals((Object)linkedFolderFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolderFile.getLocationURI().toString()));
    }

    @Test
    public void testVirtualResourceURIToResourceMapping() throws CoreException, IOException {
        IProject project1 = null;
        Path externalFile = null;
        Path externalFolder = null;
        externalFile = Files.createTempFile("tmp_file-", null, new FileAttribute[0]);
        externalFolder = Files.createTempDirectory("tmp_dir-", new FileAttribute[0]);
        project1 = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFolder virtualFolder = project1.getFolder("virtual_folder");
        virtualFolder.create(8192, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)virtualFolder.isVirtual(), (Object)true);
        Assert.assertEquals((Object)virtualFolder.getLocationURI().toString(), (Object)"virtual:/virtual");
        Assert.assertEquals((Object)virtualFolder.getRawLocationURI().toString(), (Object)"virtual:/virtual");
        Assert.assertEquals(null, (Object)LSPEclipseUtils.findResourceFor((String)virtualFolder.getLocationURI().toString()));
        IFile linkedFile = virtualFolder.getFile("linked_file");
        linkedFile.createLink(externalFile.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)linkedFile.isLinked());
        Assert.assertEquals((Object)linkedFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFile.getLocationURI().toString()));
        IFolder linkedFolder = virtualFolder.getFolder("linked_folder");
        linkedFolder.createLink(externalFolder.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)linkedFolder.isLinked());
        Assert.assertEquals((Object)linkedFolder, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolder.getLocationURI().toString()));
        Files.createFile(externalFolder.resolve("child"), new FileAttribute[0]);
        IFile linkedFolderFile = linkedFolder.getFile("child");
        Assert.assertEquals((Object)linkedFolderFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolderFile.getLocationURI().toString()));
    }

    @Test
    public void testCustomURIToResourceMapping() throws CoreException {
        IProject project = null;
        URI uri = URI.create("other://a/res.txt");
        project = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + uri.getScheme());
        IFile file = project.getFile("res.txt");
        file.createLink(uri, 272, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)file, (Object)LSPEclipseUtils.findResourceFor((String)file.getLocationURI().toString()));
        Assert.assertEquals((Object)file, (Object)LSPEclipseUtils.getFileHandle((URI)file.getLocationURI()));
    }

    @Test
    public void testCustomResourceToURIMapping() throws CoreException {
        IProject project = null;
        URI uri = URI.create("other://res.txt");
        project = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + uri.getScheme());
        IFile file = project.getFile("res.txt");
        file.createLink(uri, 272, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((Object)LSPEclipseUtils.toUri((IResource)file).toString(), (Object)"other://a/res.txt");
    }

    @Test
    public void testApplyTextEditLongerThanOrigin() throws Exception {
        IProject project = null;
        IEditorPart editor = null;
        project = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile file = TestUtils.createUniqueTestFile(project, "line1\nlineInsertHere");
        editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        TextEdit textEdit = new TextEdit(new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length())), "Inserted");
        IDocument document = viewer.getDocument();
        LSPEclipseUtils.applyEdit((TextEdit)textEdit, (IDocument)document);
        Assert.assertEquals((Object)"line1\nlineInserted", (Object)document.get());
    }

    @Test
    public void testApplyTextEditShorterThanOrigin() throws Exception {
        IProject project = null;
        IEditorPart editor = null;
        project = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile file = TestUtils.createUniqueTestFile(project, "line1\nlineHERE");
        editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        TextEdit textEdit = new TextEdit(new Range(new Position(1, 4), new Position(1, 4 + "HERE".length())), "Inserted");
        IDocument document = viewer.getDocument();
        LSPEclipseUtils.applyEdit((TextEdit)textEdit, (IDocument)document);
        Assert.assertEquals((Object)"line1\nlineInserted", (Object)document.get());
    }

    @Test
    public void testTextEditInsertSameOffset() throws Exception {
        IProject project = null;
        IEditorPart editor = null;
        project = TestUtils.createProject(String.valueOf(this.getClass().getSimpleName()) + System.currentTimeMillis());
        IFile file = TestUtils.createUniqueTestFile(project, "");
        editor = TestUtils.openEditor(file);
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        TextEdit[] edits = new TextEdit[]{new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), " throws "), new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "Exception")};
        IDocument document = viewer.getDocument();
        LSPEclipseUtils.applyEdits((IDocument)document, Arrays.asList(edits));
        Assert.assertEquals((Object)" throws Exception", (Object)document.get());
    }

    @Test
    public void testURICreationUnix() {
        Assume.assumeFalse((boolean)"win32".equals(Platform.getOS()));
        Assert.assertEquals((Object)"file:///test%20with%20space", (Object)LSPEclipseUtils.toUri((File)new File("/test with space")).toString());
    }

    @Test
    public void testUNCwindowsURI() {
        Assume.assumeTrue((boolean)"win32".equals(Platform.getOS()));
        URI preferredURI = URI.create("file://localhost/c$/Windows");
        URI javaURI = URI.create("file:////localhost/c$/Windows");
        File file1 = LSPEclipseUtils.fromUri((URI)preferredURI);
        File file2 = LSPEclipseUtils.fromUri((URI)javaURI);
        Assert.assertEquals((Object)file1, (Object)file2);
    }

    @Test
    public void testToWorkspaceFolder() throws Exception {
        IProject project = TestUtils.createProject("testToWorkspaceFolder");
        WorkspaceFolder folder = LSPEclipseUtils.toWorkspaceFolder((IProject)project);
        Assert.assertEquals((Object)"testToWorkspaceFolder", (Object)folder.getName());
        Assert.assertEquals((Object)"file://", (Object)folder.getUri().substring(0, "file://".length()));
    }

    @Test
    public void testResourceOperations() throws Exception {
        IProject project = TestUtils.createProject("testResourceOperations");
        IFile targetFile = project.getFile("some/folder/file.txt");
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)new WorkspaceEdit(Collections.singletonList(Either.forRight((Object)new CreateFile(targetFile.getLocationURI().toString())))));
        Assert.assertTrue((boolean)targetFile.exists());
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(targetFile.getLocationURI().toString(), Integer.valueOf(1)), Collections.singletonList(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "hello")))))));
        Assert.assertEquals((Object)"hello", (Object)this.readContent(targetFile));
        IFile otherFile = project.getFile("another/folder/file.lol");
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)new WorkspaceEdit(Collections.singletonList(Either.forRight((Object)new RenameFile(targetFile.getLocationURI().toString(), otherFile.getLocationURI().toString())))));
        Assert.assertFalse((boolean)targetFile.exists());
        Assert.assertTrue((boolean)otherFile.exists());
        Assert.assertEquals((Object)"hello", (Object)this.readContent(otherFile));
    }

    @Test
    public void createExternalFile() throws Exception {
        File file = TestUtils.createTempFile(this.getClass() + "editExternalFile", ".whatever");
        file.delete();
        Assert.assertFalse((boolean)file.exists());
        WorkspaceEdit we = new WorkspaceEdit(Collections.singletonList(Either.forRight((Object)new CreateFile(file.toURI().toString()))));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assert.assertTrue((boolean)file.isFile());
    }

    @Test
    public void editExternalFile() throws Exception {
        File file = TestUtils.createTempFile(this.getClass() + "editExternalFile", ".whatever");
        TextEdit te = new TextEdit();
        te.setRange(new Range(new Position(0, 0), new Position(0, 0)));
        te.setNewText("abc\ndef");
        TextDocumentEdit docEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(file.toURI().toString(), null), Collections.singletonList(te));
        WorkspaceEdit we = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)docEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertEquals((Object)"abc\ndef", (Object)new String(Files.readAllBytes(file.toPath())));
    }

    @Test
    public void renameExternalFile() throws Exception {
        File oldFile = TestUtils.createTempFile(this.getClass() + "editExternalFile", ".whatever");
        File newFile = new File(String.valueOf(oldFile.getAbsolutePath()) + "_renamed");
        TestUtils.addManagedTempFile(newFile);
        WorkspaceEdit we = new WorkspaceEdit(Collections.singletonList(Either.forRight((Object)new RenameFile(oldFile.toURI().toString(), newFile.toURI().toString()))));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assert.assertFalse((boolean)oldFile.isFile());
        Assert.assertTrue((boolean)newFile.isFile());
    }

    /*
     * Loose catch block
     */
    private String readContent(IFile targetFile) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            String string;
            InputStream contentStream;
            ByteArrayOutputStream stream;
            block16: {
                block15: {
                    stream = new ByteArrayOutputStream((int)targetFile.getLocation().toFile().length());
                    contentStream = targetFile.getContents();
                    FileUtil.transferStreams((InputStream)contentStream, (OutputStream)stream, (String)targetFile.getFullPath().toString(), (IProgressMonitor)new NullProgressMonitor());
                    string = new String(stream.toByteArray());
                    if (contentStream == null) break block15;
                    contentStream.close();
                }
                if (stream == null) break block16;
                stream.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (contentStream != null) {
                            contentStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testTextEditDoesntAutomaticallySaveOpenResourceFiles() throws Exception {
        IProject project = TestUtils.createProject("testTextEditDoesntAutomaticallySaveOpenFiles");
        IFile targetFile = project.getFile("blah.txt");
        targetFile.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)UI.getActivePage(), (IFile)targetFile, (String)"org.eclipse.ui.genericeditor.GenericEditor");
        TextEdit te = new TextEdit();
        te.setRange(new Range(new Position(0, 0), new Position(0, 0)));
        te.setNewText("abc\ndef");
        TextDocumentEdit docEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(LSPEclipseUtils.toUri((IResource)targetFile).toString(), null), Collections.singletonList(te));
        WorkspaceEdit we = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)docEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assert.assertEquals((Object)"abc\ndef", (Object)((StyledText)((AbstractTextEditor)editor).getAdapter(Control.class)).getText());
        Assert.assertTrue((boolean)editor.isDirty());
    }

    @Test
    public void testTextEditDoesntAutomaticallySaveOpenExternalFiles() throws Exception {
        File file = TestUtils.createTempFile("testTextEditDoesntAutomaticallySaveOpenExternalFiles", ".whatever");
        IEditorPart editor = IDE.openInternalEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        TextEdit te = new TextEdit();
        te.setRange(new Range(new Position(0, 0), new Position(0, 0)));
        te.setNewText("abc\ndef");
        TextDocumentEdit docEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(file.toURI().toString(), null), Collections.singletonList(te));
        WorkspaceEdit we = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)docEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assert.assertEquals((Object)"abc\ndef", (Object)((StyledText)((AbstractTextEditor)editor).getAdapter(Control.class)).getText());
        Assert.assertTrue((boolean)editor.isDirty());
    }

    @Test
    public void testGetOpenEditorExternalFile() throws Exception {
        File file = TestUtils.createTempFile("testDiagnosticsOnExternalFile", ".lspt");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(97);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        Assert.assertNotEquals(Collections.emptySet(), (Object)LSPEclipseUtils.findOpenEditorsFor((URI)file.toURI()));
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35");
        Assert.assertEquals((long)34L, (long)actual.getStart().getLine());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineNoEndLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35-L36");
        Assert.assertEquals((long)34L, (long)actual.getStart().getLine());
        Assert.assertEquals((long)35L, (long)actual.getEnd().getLine());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineStartCharNoEndLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35,10");
        Assert.assertEquals((long)34L, (long)actual.getStart().getLine());
        Assert.assertEquals((long)9L, (long)actual.getStart().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineStartCharWithEndLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35,10-L37");
        Assert.assertEquals((long)34L, (long)actual.getStart().getLine());
        Assert.assertEquals((long)9L, (long)actual.getStart().getCharacter());
        Assert.assertEquals((long)36L, (long)actual.getEnd().getLine());
        Assert.assertEquals((long)9L, (long)actual.getEnd().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineStartCharWithEndLineNoWithEndChar() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35,10-L37,34");
        Assert.assertEquals((long)34L, (long)actual.getStart().getLine());
        Assert.assertEquals((long)9L, (long)actual.getStart().getCharacter());
        Assert.assertEquals((long)36L, (long)actual.getEnd().getLine());
        Assert.assertEquals((long)33L, (long)actual.getEnd().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithoutLCharacter() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#35,10-37,34");
        Assert.assertEquals((long)34L, (long)actual.getStart().getLine());
        Assert.assertEquals((long)9L, (long)actual.getStart().getCharacter());
        Assert.assertEquals((long)36L, (long)actual.getEnd().getLine());
        Assert.assertEquals((long)33L, (long)actual.getEnd().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnNullRange_BlankFragment() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#");
        Assert.assertNull((Object)actual);
    }

    @Test
    public void parseRange_shouldReturnNullRange_NoFragment() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b");
        Assert.assertNull((Object)actual);
    }
}

