/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.IInternalDebugCoreConstants;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.MappingEnablementTester;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockLanguageServerMultiRootFolders;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LanguageServiceAccessorTest {
    private static final Predicate<ServerCapabilities> MATCH_ALL = capabilities -> true;
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("LanguageServiceAccessorTest" + System.currentTimeMillis());
    }

    @Test
    public void testGetLSWrapper() throws IOException {
        LanguageServersRegistry.LanguageServerDefinition serverDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.lsp4e.test.server");
        Assert.assertNotNull((Object)serverDefinition);
        LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)this.project, (LanguageServersRegistry.LanguageServerDefinition)serverDefinition);
        Assert.assertNotNull((Object)lsWrapper);
    }

    @Test
    public void testGetLSPDocumentInfoForInvalidDocument() {
        List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)new Document(), MATCH_ALL);
        Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetLSPDocumentInfoForInvalidTextEditor() throws CoreException {
        IFile testFile = TestUtils.createFile(this.project, "not_associated_with_ls.abc", "");
        ITextViewer textViewer = TestUtils.openTextViewer(testFile);
        List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)textViewer.getDocument(), MATCH_ALL);
        Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetLanguageServerInvalidFile() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "not_associated_with_ls.abc", "");
        LanguageServiceAccessorTest.assertEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, MATCH_ALL));
    }

    @Test
    public void testLSAsExtension() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt", "");
        LanguageServer ls = (LanguageServer)((CompletableFuture)LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, MATCH_ALL).get(0)).get(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)ls);
    }

    @Test
    public void testLSAsRunConfiguration() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseRunConfiguration.lspt2", "");
        LanguageServer ls = (LanguageServer)((CompletableFuture)LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile, MATCH_ALL).get(0)).get(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)ls);
    }

    @Test
    public void testLSAsExtensionForDifferentLanguageId() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt-different", "");
        Collection lsWrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)lsWrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)lsWrappers.iterator().next();
        Assert.assertNotNull((Object)wrapper);
        IContentType contentType = Platform.getContentTypeManager().getContentType("org.eclipse.lsp4e.test.content-type-different");
        Assert.assertEquals((Object)"differentLanguageId", (Object)wrapper.getLanguageId(new IContentType[]{contentType}));
    }

    @Test
    public void testGetLSWrappersInitializationFailed() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "fileWithFailedServer.lsptWithException", "");
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
    }

    @Test
    public void testReuseSameLSforMultiContentType() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        List file1LanguageServers = LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)file1LanguageServers.size());
        ArrayList file2LanguageServers = new ArrayList();
        for (CompletableFuture future : LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile2, MATCH_ALL)) {
            file2LanguageServers.add(future.get(2L, TimeUnit.SECONDS));
        }
        Assert.assertEquals((long)2L, (long)file2LanguageServers.size());
        LanguageServer file1LS = (LanguageServer)((CompletableFuture)file1LanguageServers.get(0)).get(2L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)file2LanguageServers.contains(file1LS));
        Assert.assertEquals((String)"Not right amount of language servers bound to project", (long)2L, (long)LanguageServiceAccessor.getLanguageServers((IProject)this.project, MATCH_ALL).size());
    }

    @Test
    public void testGetOnlyRunningLanguageServers() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        IEditorPart editor2 = TestUtils.openEditor(testFile2);
        LanguageServiceAccessorTest.assertNotEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, MATCH_ALL));
        LanguageServiceAccessorTest.assertNotEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile2, MATCH_ALL));
        List runningServers = LanguageServiceAccessor.getActiveLanguageServers(MATCH_ALL);
        Assert.assertEquals((long)2L, (long)runningServers.size());
        ((AbstractTextEditor)editor1).close(false);
        ((AbstractTextEditor)editor2).close(false);
        TestUtils.waitForCondition(5000, () -> LanguageServiceAccessor.getActiveLanguageServers(MATCH_ALL).isEmpty());
        Assert.assertEquals((long)0L, (long)LanguageServiceAccessor.getActiveLanguageServers(MATCH_ALL).size());
        editor1 = TestUtils.openEditor(testFile1);
        LanguageServiceAccessorTest.assertNotEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, MATCH_ALL));
        TestUtils.waitForCondition(5000, () -> LanguageServiceAccessor.getActiveLanguageServers(MATCH_ALL).size() > 0);
        Assert.assertEquals((long)1L, (long)LanguageServiceAccessor.getActiveLanguageServers(MATCH_ALL).size());
    }

    @Test
    public void testCreateNewLSAfterInitialProjectGotDeleted() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessorTest.assertNotEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, MATCH_ALL));
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, MATCH_ALL);
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServer.INSTANCE.isRunning());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "");
        TestUtils.openEditor(testFile2);
        LanguageServiceAccessorTest.assertNotEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile2, MATCH_ALL));
        TestUtils.waitForAndAssertCondition(5000, () -> MockLanguageServer.INSTANCE.isRunning());
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, MATCH_ALL);
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertTrue((wrapper1 != wrapper2 ? 1 : 0) != 0);
    }

    @Test
    public void testReuseMultirootFolderLSAfterInitialProjectGotDeleted() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "lsptWithMultiRoot", "");
        TestUtils.openEditor(testFile1);
        LanguageServiceAccessorTest.assertNotEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile1, MATCH_ALL));
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, MATCH_ALL);
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        UI.getActivePage().closeAllEditors(false);
        TestUtils.waitForAndAssertCondition(5000, () -> !MockLanguageServerMultiRootFolders.INSTANCE.isRunning());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = TestUtils.createProject("LanguageServiceAccessorTest2" + System.currentTimeMillis());
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lsptWithMultiRoot", "");
        TestUtils.openEditor(testFile2);
        LanguageServiceAccessorTest.assertNotEmpty(LanguageServiceAccessor.getInitializedLanguageServers((IFile)testFile2, MATCH_ALL));
        wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, MATCH_ALL);
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertSame((Object)wrapper1, (Object)wrapper2);
    }

    @Test
    public void testDontRestartUnrelatedLSForFileFromSameProject() throws Exception {
        IFile testFile1 = TestUtils.createUniqueTestFile(this.project, "");
        IFile testFile2 = TestUtils.createUniqueTestFile(this.project, "lspt-different", "");
        Collection wrappers1 = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers1.size());
        LanguageServerWrapper wrapper1 = (LanguageServerWrapper)wrappers1.iterator().next();
        Assert.assertTrue((boolean)wrapper1.isActive());
        wrapper1.disconnect(testFile1.getLocationURI());
        Assert.assertFalse((boolean)wrapper1.isActive());
        Collection wrappers2 = LanguageServiceAccessor.getLSWrappers((IFile)testFile2, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers2.size());
        LanguageServerWrapper wrapper2 = (LanguageServerWrapper)wrappers2.iterator().next();
        Assert.assertTrue((boolean)wrapper2.isActive());
        Assert.assertFalse((boolean)wrapper1.isActive());
        wrapper2.disconnect(testFile2.getLocationURI());
    }

    @Test
    public void testLastDocumentDisconnectedTimeoutManualStop() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptWithLastDocumentDisconnectedTimeout", "");
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.disconnect(testFile.getLocationURI());
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.stop();
        Assert.assertFalse((boolean)wrapper.isActive());
    }

    @Test
    public void testLastDocumentDisconnectedTimeoutTimerStop() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptWithLastDocumentDisconnectedTimeout", "");
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.disconnect(testFile.getLocationURI());
        Assert.assertTrue((boolean)wrapper.isActive());
        TestUtils.waitForAndAssertCondition(5000, () -> !wrapper.isActive());
    }

    @Test
    public void testLastDocumentDisconnectedTimeoutZero() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        Assert.assertTrue((boolean)wrapper.isActive());
        wrapper.disconnect(testFile.getLocationURI());
        Assert.assertFalse((boolean)wrapper.isActive());
    }

    @Test
    public void testLanguageServerHierarchy_moreSpecializedFirst() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptchild", "");
        Collection servers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Iterator iterator = servers.iterator();
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server2", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
    }

    @Test
    public void testLanguageServerHierarchy_parentContentTypeUsed() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "lsptchildNoLS", "");
        Collection servers = LanguageServiceAccessor.getLSWrappers((IFile)testFile, MATCH_ALL);
        Iterator iterator = servers.iterator();
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server", (Object)((LanguageServerWrapper)iterator.next()).serverDefinition.id);
        Assert.assertFalse((String)"Should only be a single LS", (boolean)iterator.hasNext());
    }

    @Test
    public void testLanguageServerEnablement() throws Exception {
        String serverId = "org.eclipse.lsp4e.test.server.disable";
        String prefKey = "org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled";
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled", Boolean.FALSE.toString());
        IFile disabledFile = TestUtils.createUniqueTestFile(this.project, "lspt-disabled", "");
        Assert.assertFalse((boolean)LanguageServiceAccessor.getLSWrappers((IFile)disabledFile, MATCH_ALL).stream().filter(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")).findAny().isPresent());
        IFile enabledFile = TestUtils.createUniqueTestFile(this.project, "lspt-enabled", "");
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)enabledFile, MATCH_ALL).stream().filter(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")).findAny().isPresent());
        LanguageServerPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.lsp4e.test.server.disable/org.eclipse.lsp4e.test.content-type-disabled", Boolean.TRUE.toString());
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)disabledFile, MATCH_ALL).stream().filter(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")).findAny().isPresent());
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)enabledFile, MATCH_ALL).stream().filter(w -> w.serverDefinition.id.equals("org.eclipse.lsp4e.test.server.disable")).findAny().isPresent());
    }

    @Test
    public void testLanguageServerEnablementTester() throws Exception {
        String serverId = "org.eclipse.lsp4e.test.server.disable";
        IFile file = TestUtils.createUniqueTestFile(this.project, "lspt-tester", "");
        Assert.assertTrue((boolean)LanguageServiceAccessor.getLSWrappers((IFile)file, MATCH_ALL).isEmpty());
        MappingEnablementTester.enabled = true;
        Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)file, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        Assert.assertEquals((Object)"org.eclipse.lsp4e.test.server.disable", (Object)((LanguageServerWrapper)wrappers.iterator().next()).serverDefinition.id);
    }

    @Test
    public void testStatusHandlerLSAsRunConfiguration() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseRunConfiguration.lspt2", "");
        boolean oldStatusHandler = LanguageServiceAccessorTest.isStatusHandlersEnabled();
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assert.assertNotNull((Object)document);
        LanguageServiceAccessor.getLanguageServers((IDocument)document, null).get(2L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)LanguageServiceAccessorTest.isStatusHandlersEnabled(), (Object)oldStatusHandler);
        LanguageServiceAccessorTest.setStatusHandlersEnabled(false);
        oldStatusHandler = LanguageServiceAccessorTest.isStatusHandlersEnabled();
        LanguageServiceAccessor.getLanguageServers((IDocument)document, null).get(2L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)LanguageServiceAccessorTest.isStatusHandlersEnabled(), (Object)false);
        LanguageServiceAccessorTest.setStatusHandlersEnabled(true);
        oldStatusHandler = LanguageServiceAccessorTest.isStatusHandlersEnabled();
        LanguageServiceAccessor.getLanguageServers((IDocument)document, null).get(2L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)LanguageServiceAccessorTest.isStatusHandlersEnabled(), (Object)true);
    }

    @Test
    public void testLSforExternalThenLocalFile() throws Exception {
        IWorkbenchWindow wb = UI.getActiveWindow();
        File local = TestUtils.createTempFile("testLSforExternalThenLocalFile", ".lspt");
        ITextEditor editor = (ITextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)wb.getActivePage(), (IFileStore)EFS.getStore((URI)local.toURI()));
        Predicate<ServerCapabilities> hasHoverCapabilities = capabilities -> {
            Either hoverProvider = capabilities.getHoverProvider();
            return hoverProvider.isLeft() ? (Boolean)hoverProvider.getLeft() : hoverProvider.getRight() != null;
        };
        Assert.assertEquals((long)1L, (long)((List)LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getTextViewer((IEditorPart)editor).getDocument(), hasHoverCapabilities).get()).size());
        wb.getActivePage().closeAllEditors(false);
        Assert.assertEquals((long)1L, (long)((List)LanguageServiceAccessor.getLanguageServers((IDocument)TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "")).getDocument(), hasHoverCapabilities).get()).size());
    }

    @Test
    public void testSingletonLS() throws Exception {
        IFile testFile1 = TestUtils.createFile(this.project, "shouldUseSingletonLS.lsp-singletonLS", "");
        IDocument document1 = LSPEclipseUtils.getDocument((IResource)testFile1);
        Assert.assertNotNull((Object)document1);
        CompletableFuture languageServers = LanguageServiceAccessor.getLanguageServers((IDocument)document1, MATCH_ALL);
        IProject project2 = TestUtils.createProject("project2");
        IFile testFile2 = TestUtils.createFile(project2, "shouldUseSingletonLS2.lsp-singletonLS", "");
        IDocument document2 = LSPEclipseUtils.getDocument((IResource)testFile2);
        Assert.assertNotNull((Object)document2);
        CompletableFuture languageServers2 = LanguageServiceAccessor.getLanguageServers((IDocument)document2, MATCH_ALL);
        Assert.assertEquals((long)1L, (long)((List)languageServers.get()).size());
        Assert.assertEquals(languageServers.get(), languageServers2.get());
    }

    private static boolean isStatusHandlersEnabled() {
        return Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, true, null);
    }

    private static void setStatusHandlersEnabled(boolean enabled) {
        Preferences.setBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, (boolean)enabled, null);
    }

    private static <T> void assertEmpty(Collection<T> coll) {
        Assert.assertTrue((String)("Given collection is expected to be empty! " + coll), (boolean)coll.isEmpty());
    }

    private static <T> void assertNotEmpty(Collection<T> coll) {
        Assert.assertFalse((String)"Given collection must not be empty!", (boolean)coll.isEmpty());
    }
}

