/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.format;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FormatTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
    }

    @Test
    public void testFormattingInvalidDocument() throws InterruptedException, ExecutionException {
        LSPFormatter formatter = new LSPFormatter();
        ITextSelection selection = TextSelection.emptySelection();
        List edits = (List)formatter.requestFormatting((IDocument)new Document(), selection).get();
        Assert.assertEquals((long)0L, (long)edits.size());
    }

    @Test
    public void testFormattingNoChanges() throws CoreException, InvocationTargetException, InterruptedException, ExecutionException {
        MockLanguageServer.INSTANCE.setFormattingTextEdits(Collections.emptyList());
        IFile file = TestUtils.createUniqueTestFile(this.project, "Formatting Other Text");
        IEditorPart editor = TestUtils.openEditor(file);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LSPFormatter formatter = new LSPFormatter();
        ISelection selection = viewer.getSelectionProvider().getSelection();
        List edits = (List)formatter.requestFormatting(viewer.getDocument(), (ITextSelection)selection).get();
        editor.getSite().getShell().getDisplay().syncExec(() -> formatter.applyEdits(viewer.getDocument(), edits));
        ITextEditor textEditor = (ITextEditor)editor;
        textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        Assert.assertEquals((Object)"Formatting Other Text", (Object)viewer.getDocument().get());
        TestUtils.closeEditor(editor, false);
    }

    @Test
    public void testFormatting() throws CoreException, InvocationTargetException, InterruptedException, ExecutionException {
        ArrayList<TextEdit> formattingTextEdits = new ArrayList<TextEdit>();
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 0), new Position(0, 1)), "MyF"));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 10), new Position(0, 11)), ""));
        formattingTextEdits.add(new TextEdit(new Range(new Position(0, 21), new Position(0, 21)), " Second"));
        MockLanguageServer.INSTANCE.setFormattingTextEdits(formattingTextEdits);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Formatting Other Text");
        IEditorPart editor = TestUtils.openEditor(file);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LSPFormatter formatter = new LSPFormatter();
        ISelection selection = viewer.getSelectionProvider().getSelection();
        List edits = (List)formatter.requestFormatting(viewer.getDocument(), (ITextSelection)selection).get();
        editor.getSite().getShell().getDisplay().syncExec(() -> formatter.applyEdits(viewer.getDocument(), edits));
        ITextEditor textEditor = (ITextEditor)editor;
        textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        Assert.assertEquals((Object)"MyFormattingOther Text Second", (Object)viewer.getDocument().get());
        TestUtils.closeEditor(editor, false);
    }

    @Test
    public void testNullFormatting() throws CoreException, InvocationTargetException, InterruptedException, ExecutionException {
        Document document = new Document("Formatting Other Text");
        LSPFormatter formatter = new LSPFormatter();
        formatter.applyEdits((IDocument)document, null);
        Assert.assertEquals((Object)"Formatting Other Text", (Object)document.get());
    }
}

