/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.impl;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsat.external.api.LSATException;
import org.eclipse.lsat.external.api.LSATService;
import org.eclipse.lsat.external.api.impl.LaunchConfigurationManager;
import org.osgi.service.component.annotations.Component;

@Component(service={LSATService.class}, immediate=true)
public class LSATServiceImpl
implements LSATService {
    public static final String MAPPED_RESOURCE_PATHS = "org.eclipse.debug.core.MAPPED_RESOURCE_PATHS";
    public static final String MAPPED_RESOURCE_TYPES = "org.eclipse.debug.core.MAPPED_RESOURCE_TYPES";
    public static final String LAUNCH_PREFIX = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes";
    public static final String MODEL_IFILE = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.model";
    public static final String SETTING_IFILE = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.setting";
    public static final String INTERACTIVE_TIMINGANALYSIS = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.interactive_timinganalysis";
    public static final String NO_GANTT_CHART = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.no_gantt_chart";
    public static final String GANTT_CHART = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.plain_gantt_chart";
    public static final String CRITICAL_PATH = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.critical_path_no_claims";
    public static final String STOCHASTIC_IMPACT = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.stochastic_impact";
    public static final String STOCHASTIC_SAMPLE_LENGTH = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.stochastic_sample_length";
    public static final String REMOVE_CLAIMS_RELEASES_DEPENDENCIES = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.remove_claims_releases_dependencies";
    public static final String EXPORT_JSON = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.export_json";
    public static final String PAPERSCRIPT_ANIMATION = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.paperscript_animation";
    public static final String EXPORT_MOTIONPLOTS = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.export_motionplots";
    public static final String EXPORT_MOTIONPLOTS_FILTER = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.export_motionplots_filter";
    public static final String MOTIONPLOTS_SAMPLE_FREQUENCY = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.motionplots_sample_frequency";
    public static final String COLOR_ERRONEOUS_MOVES = "org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes.color_erroneous_moves";

    public String timingAnalysis(String projectName, String dispatchFilename, String settingFilename, LSATService.TimingAnalysisGoal goal, int stochasticSampleLength, boolean exportMotionPlots, int motionPlotSampleFrequency, String motionPlotFilter, boolean colorErroneousMoves, boolean debug) throws LSATException {
        IProject project = LSATServiceImpl.getProject(projectName);
        IFile dispatchFile = LSATServiceImpl.getProjectFile(project, dispatchFilename + ".dispatching");
        IFile settingFile = LSATServiceImpl.getProjectFile(project, settingFilename + ".setting");
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(MODEL_IFILE, dispatchFile.getFullPath().toString());
        attributes.put(SETTING_IFILE, settingFile.getFullPath().toString());
        attributes.put(MAPPED_RESOURCE_TYPES, List.of("1", "1"));
        attributes.put(INTERACTIVE_TIMINGANALYSIS, false);
        attributes.put(CRITICAL_PATH, goal == LSATService.TimingAnalysisGoal.CRITICAL_PATH);
        attributes.put(GANTT_CHART, true);
        attributes.put(EXPORT_JSON, true);
        attributes.put(PAPERSCRIPT_ANIMATION, false);
        attributes.put(STOCHASTIC_IMPACT, goal == LSATService.TimingAnalysisGoal.STOCHASTIC_IMPACT);
        attributes.put(STOCHASTIC_SAMPLE_LENGTH, Integer.toString(stochasticSampleLength));
        attributes.put(EXPORT_MOTIONPLOTS, exportMotionPlots);
        attributes.put(EXPORT_MOTIONPLOTS_FILTER, motionPlotFilter);
        attributes.put(MOTIONPLOTS_SAMPLE_FREQUENCY, Integer.toString(motionPlotSampleFrequency));
        attributes.put(COLOR_ERRONEOUS_MOVES, colorErroneousMoves);
        try {
            LaunchConfigurationManager.runLaunchConfiguration("ExternalTimingAnalysis", "org.eclipse.lsat.timinganalysis.ui.launchConfigurationType", attributes, debug);
        }
        catch (CoreException e) {
            throw new LSATException("Run Failed", (Throwable)e);
        }
        String resultFilename = "analysis/scheduled/" + dispatchFilename;
        if (goal == LSATService.TimingAnalysisGoal.CRITICAL_PATH) {
            resultFilename = resultFilename + "-critical";
        }
        if (goal == LSATService.TimingAnalysisGoal.STOCHASTIC_IMPACT) {
            resultFilename = resultFilename + "-stochastic";
        }
        resultFilename = resultFilename + ".json";
        IFile resultFile = LSATServiceImpl.getProjectFile(project, resultFilename);
        try {
            return resultFile.readString();
        }
        catch (CoreException e) {
            throw new LSATException("Reading results failed", (Throwable)e);
        }
    }

    public List<String> list(String projectName, LSATService.FileType fileType) throws LSATException {
        if (fileType == LSATService.FileType.PROJECT) {
            return Arrays.stream(LSATServiceImpl.getAllProjects()).map(IResource::getName).toList();
        }
        IProject project = LSATServiceImpl.getProject(projectName);
        try {
            return Arrays.stream(project.members()).filter(IFile.class::isInstance).map(IFile.class::cast).filter(f -> f.getFileExtension().equals(fileType.getExtension())).map(IFile::getName).toList();
        }
        catch (CoreException e) {
            throw new LSATException("List Failed", (Throwable)e);
        }
    }

    public String reloadProject(String projectName) throws LSATException {
        return LSATServiceImpl.reloadProject(LSATServiceImpl.getProject(projectName));
    }

    public List<String> reloadAllProjects() throws LSATException {
        return Arrays.stream(LSATServiceImpl.getAllProjects()).map(LSATServiceImpl::reloadProject).toList();
    }

    private static String reloadProject(IProject project) {
        try {
            project.refreshLocal(2, null);
            return project.getName();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IProject[] getAllProjects() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getProjects();
    }

    public static IProject getProject(String projectName) throws LSATException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            throw new LSATException("Project " + projectName + " does not exist");
        }
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                throw new LSATException("Project open failed", (Throwable)e);
            }
        }
        return project;
    }

    private static IFile getProjectFile(IProject project, String filePath) throws LSATException {
        IFile file = project.getFile(filePath);
        if (!file.exists()) {
            throw new LSATException("Project " + project.getName() + " does not contain file " + filePath);
        }
        return file;
    }
}

