/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers;

import java.text.MessageFormat;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.CommentRemover;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.FuncparamNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.nodedata.FunctionNodeData;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.SharedParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.TreeTapsetParser;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public final class FunctionParser
extends TreeTapsetParser {
    private static FunctionParser parser = null;
    public static final String UNKNOWN_TYPE = "unknown";
    private static final String FUNC_REGEX = "(?s)(?<!\\w)function\\s+{0}(?:\\s*:\\s*(\\w+))?\\s*\\(([^)]+?)?\\)";
    private static final Pattern P_FUNCTION = Pattern.compile("function (?!_)(\\w+) \\(.*?\\)");
    private static final Pattern P_PARAM = Pattern.compile("(\\w+)(?:\\s*:\\s*(\\w+))?");
    private static final Pattern P_ALL_CAP = Pattern.compile("[A-Z_1-9]*");
    private static final Pattern P_RETURN = Pattern.compile("(?<!\\w)return\\W");

    public static FunctionParser getInstance() {
        if (parser != null) {
            return parser;
        }
        parser = new FunctionParser();
        return parser;
    }

    private FunctionParser() {
        super(Messages.FunctionParser_name);
    }

    @Override
    protected int runAction(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return 8;
        }
        String tapsetContents = SharedParser.getInstance().getTapsetContents();
        int result = this.verifyRunResult(tapsetContents);
        if (result != 0) {
            return result;
        }
        boolean canceled = false;
        try (Scanner scanner = new Scanner(tapsetContents);){
            scanner.useDelimiter("(?=# file )");
            while (scanner.hasNext()) {
                if (monitor.isCanceled()) {
                    canceled = true;
                    break;
                }
                this.addFunctionsFromFileContents(scanner.next());
            }
        }
        this.tree.sortLevel();
        return !canceled ? 0 : 8;
    }

    private void addFunctionsFromFileContents(String fileContents) {
        String filename;
        try (Scanner st = new Scanner(fileContents);){
            filename = SharedParser.findFileNameInTag(st.nextLine());
        }
        Matcher matcher = P_FUNCTION.matcher(fileContents);
        String scriptText = null;
        while (matcher.find()) {
            String functionName = matcher.group(1);
            if (P_ALL_CAP.matcher(functionName).matches()) continue;
            if (scriptText == null) {
                scriptText = CommentRemover.execWithFile(filename);
            }
            this.addFunctionFromScript(functionName, scriptText, filename);
        }
    }

    private void addFunctionFromScript(String functionName, String scriptText, String scriptFilename) {
        String regex = MessageFormat.format(FUNC_REGEX, functionName);
        Matcher mScript = Pattern.compile(regex).matcher(scriptText);
        if (mScript.find()) {
            String functionLine = mScript.group();
            String functionType = mScript.group(1);
            if (functionType == null && this.isPatternInScriptBlock(scriptText, mScript.end(), P_RETURN)) {
                functionType = UNKNOWN_TYPE;
            }
            TreeDefinitionNode function = new TreeDefinitionNode((Object)new FunctionNodeData(functionLine, functionType), functionName, scriptFilename, true);
            this.tree.add((TreeNode)function);
            this.addParamsFromString(mScript.group(2), (TreeNode)function);
        }
    }

    private boolean isPatternInScriptBlock(String scriptText, int start, Pattern p) {
        int end;
        int bcount = 1;
        for (end = start = scriptText.indexOf(123, start) + 1; end < scriptText.length(); ++end) {
            char c = scriptText.charAt(end);
            if (c == '{') {
                ++bcount;
                continue;
            }
            if (c == '}' && --bcount == 0) break;
        }
        return p.matcher(scriptText.substring(start, end)).find();
    }

    private void addParamsFromString(String params, TreeNode parentFunction) {
        if (params != null) {
            Matcher mParams = P_PARAM.matcher(params);
            while (mParams.find()) {
                parentFunction.add(new TreeNode((Object)new FuncparamNodeData(mParams.group(2)), mParams.group(1), false));
            }
        }
        parentFunction.sortLevel();
    }

    @Override
    protected int delTapsets(String[] deletions, IProgressMonitor monitor) {
        for (int i = 0; i < deletions.length; ++i) {
            int fn = this.tree.getChildCount();
            for (int f = 0; f < fn; ++f) {
                if (monitor.isCanceled()) {
                    return 8;
                }
                String definition = ((TreeDefinitionNode)this.tree.getChildAt(f)).getDefinition();
                if (definition == null || !definition.startsWith(deletions[i])) continue;
                this.tree.remove(f--);
                --fn;
            }
        }
        return 0;
    }

    @Override
    protected int addTapsets(String tapsetContents, String[] additions, IProgressMonitor monitor) {
        boolean canceled = false;
        block0: for (int i = 0; i < additions.length; ++i) {
            int firstTagIndex = 0;
            while ((firstTagIndex = tapsetContents.indexOf(SharedParser.makeFileTag(additions[i]), firstTagIndex)) != -1) {
                String fileContents;
                int nextTagIndex = tapsetContents.indexOf("# file ", firstTagIndex + 1);
                String string = fileContents = nextTagIndex != -1 ? tapsetContents.substring(firstTagIndex, nextTagIndex) : tapsetContents.substring(firstTagIndex);
                if (monitor.isCanceled()) {
                    canceled = true;
                    continue block0;
                }
                this.addFunctionsFromFileContents(fileContents);
                tapsetContents = tapsetContents.substring(0, firstTagIndex).concat(tapsetContents.substring(firstTagIndex + fileContents.length()));
            }
        }
        this.tree.sortLevel();
        return !canceled ? 0 : 8;
    }
}

