/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.utils.TextEditUtils;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TextEditUtilsTest
extends AbstractCacheBasedTest {
    @Test
    public void textEdit() {
        TextDocument document = new TextDocument("<a/>", "test.xml");
        TextEdit edit = TextEditUtils.createTextEditIfNeeded((int)1, (int)2, (String)" ", (TextDocument)document);
        Assertions.assertNotNull((Object)edit);
        Assertions.assertEquals((Object)XMLAssert.te(0, 1, 0, 2, " "), (Object)edit);
    }

    @Test
    public void noTextEdit() {
        TextDocument document = new TextDocument("<a />", "test.xml");
        TextEdit edit = TextEditUtils.createTextEditIfNeeded((int)2, (int)3, (String)" ", (TextDocument)document);
        Assertions.assertNull((Object)edit);
    }

    @Test
    public void textEdit2() {
        TextDocument document = new TextDocument("<a  />", "test.xml");
        TextEdit edit = TextEditUtils.createTextEditIfNeeded((int)1, (int)4, (String)" ", (TextDocument)document);
        Assertions.assertNotNull((Object)edit);
        Assertions.assertEquals((Object)XMLAssert.te(0, 1, 0, 4, " "), (Object)edit);
    }

    @Test
    public void textEditQuote() {
        TextDocument document = new TextDocument("<a name='value '> </a>", "test.xml");
        TextEdit edit = TextEditUtils.createTextEditIfNeeded((int)8, (int)9, (String)"\"", (TextDocument)document);
        Assertions.assertNotNull((Object)edit);
        Assertions.assertEquals((Object)XMLAssert.te(0, 8, 0, 9, "\""), (Object)edit);
    }
}

