/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class TextEditUtils {
    private static final Logger LOGGER = Logger.getLogger(TextEditUtils.class.getName());

    public static TextEdit createTextEditIfNeeded(int from, int to, String expectedContent, TextDocument textDocument) {
        char c;
        String text = textDocument.getText();
        if (TextEditUtils.isMatchExpectedContent(from, to, expectedContent, text)) {
            return null;
        }
        if (from == to) {
            try {
                Position endPos;
                Position startPos = endPos = textDocument.positionAt(to);
                Range range = new Range(startPos, endPos);
                return new TextEdit(range, expectedContent);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        int i = expectedContent.length() - 1;
        boolean matchExpectedContent = true;
        while (from >= 0 && Character.isWhitespace(c = text.charAt(from))) {
            if (matchExpectedContent) {
                if (i < 0) {
                    matchExpectedContent = false;
                } else {
                    if (expectedContent.charAt(i) != c) {
                        matchExpectedContent = false;
                    }
                    --i;
                }
            }
            --from;
        }
        ++from;
        if (matchExpectedContent) {
            boolean bl = matchExpectedContent = to - from == expectedContent.length();
        }
        if (!matchExpectedContent) {
            try {
                Position endPos = textDocument.positionAt(to);
                Position startPos = to == from ? endPos : textDocument.positionAt(from);
                Range range = new Range(startPos, endPos);
                return new TextEdit(range, expectedContent);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    private static boolean isMatchExpectedContent(int from, int to, String expectedContent, String text) {
        if (expectedContent.length() == to - from) {
            int j = 0;
            for (int i = from; i < to; ++i) {
                char c = text.charAt(i);
                if (expectedContent.charAt(j) != c) {
                    return false;
                }
                ++j;
            }
        } else {
            return false;
        }
        return true;
    }

    public static String applyEdits(TextDocument document, List<? extends TextEdit> edits) throws BadLocationException {
        String text = document.getText();
        List<? extends TextEdit> sortedEdits = TextEditUtils.mergeSort(edits, (a, b) -> {
            int diff = a.getRange().getStart().getLine() - b.getRange().getStart().getLine();
            if (diff == 0) {
                return a.getRange().getStart().getCharacter() - b.getRange().getStart().getCharacter();
            }
            return diff;
        });
        int lastModifiedOffset = 0;
        ArrayList<String> spans = new ArrayList<String>();
        for (TextEdit textEdit : sortedEdits) {
            int startOffset = document.offsetAt(textEdit.getRange().getStart());
            if (startOffset < lastModifiedOffset) {
                throw new Error("Overlapping edit");
            }
            if (startOffset > lastModifiedOffset) {
                spans.add(text.substring(lastModifiedOffset, startOffset));
            }
            if (textEdit.getNewText() != null) {
                spans.add(textEdit.getNewText());
            }
            lastModifiedOffset = document.offsetAt(textEdit.getRange().getEnd());
        }
        spans.add(text.substring(lastModifiedOffset));
        return spans.stream().collect(Collectors.joining());
    }

    private static <T> List<T> mergeSort(List<T> data, Comparator<T> comparator) {
        if (data.size() <= 1) {
            return data;
        }
        int p = data.size() / 2 | 0;
        List<T> left = data.subList(0, p);
        List<T> right = data.subList(p, data.size());
        TextEditUtils.mergeSort(left, comparator);
        TextEditUtils.mergeSort(right, comparator);
        int leftIdx = 0;
        int rightIdx = 0;
        int i = 0;
        while (leftIdx < left.size() && rightIdx < right.size()) {
            int ret = comparator.compare(left.get(leftIdx), right.get(rightIdx));
            if (ret <= 0) {
                data.set(i++, left.get(leftIdx++));
                continue;
            }
            data.set(i++, right.get(rightIdx++));
        }
        while (leftIdx < left.size()) {
            data.set(i++, left.get(leftIdx++));
        }
        while (rightIdx < right.size()) {
            data.set(i++, right.get(rightIdx++));
        }
        return data;
    }
}

