/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.services.format.XMLFormatterDocument;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

class XMLFormatter {
    private static final Logger LOGGER = Logger.getLogger(XMLFormatter.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLFormatter(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<? extends TextEdit> format(DOMDocument xmlDocument, Range range, SharedSettings sharedSettings) {
        try {
            if (sharedSettings.getFormattingSettings().isExperimental()) {
                XMLFormatterDocumentNew formatterDocument = new XMLFormatterDocumentNew(xmlDocument, range, sharedSettings, this.getFormatterParticipants());
                return formatterDocument.format();
            }
            XMLFormatterDocument formatterDocument = new XMLFormatterDocument(xmlDocument.getTextDocument(), range, sharedSettings, this.getFormatterParticipants());
            return formatterDocument.format();
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Formatting failed due to BadLocation", e);
            return null;
        }
    }

    private Collection<IFormatterParticipant> getFormatterParticipants() {
        return this.extensionsRegistry.getFormatterParticipants();
    }
}

