/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings.capabilities;

import org.eclipse.lemminx.settings.capabilities.ClientCapabilitiesWrapper;
import org.eclipse.lemminx.settings.capabilities.ServerCapabilitiesConstants;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;

public class ServerCapabilitiesInitializer {
    private ServerCapabilitiesInitializer() {
    }

    public static ServerCapabilities getNonDynamicServerCapabilities(ClientCapabilitiesWrapper clientCapabilities, boolean isIncremental) {
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        serverCapabilities.setTextDocumentSync(isIncremental ? TextDocumentSyncKind.Incremental : TextDocumentSyncKind.Full);
        serverCapabilities.setDocumentSymbolProvider(Boolean.valueOf(!clientCapabilities.isDocumentSymbolDynamicRegistrationSupported()));
        serverCapabilities.setDocumentHighlightProvider(Boolean.valueOf(!clientCapabilities.isDocumentHighlightDynamicRegistered()));
        serverCapabilities.setCodeActionProvider(Boolean.valueOf(!clientCapabilities.isCodeActionDynamicRegistered()));
        serverCapabilities.setDocumentFormattingProvider(Boolean.valueOf(!clientCapabilities.isFormattingDynamicRegistrationSupported()));
        serverCapabilities.setDocumentRangeFormattingProvider(Boolean.valueOf(!clientCapabilities.isRangeFormattingDynamicRegistrationSupported()));
        serverCapabilities.setHoverProvider(Boolean.valueOf(!clientCapabilities.isHoverDynamicRegistered()));
        serverCapabilities.setRenameProvider(Boolean.valueOf(!clientCapabilities.isRenameDynamicRegistrationSupported()));
        serverCapabilities.setFoldingRangeProvider(Boolean.valueOf(!clientCapabilities.isRangeFoldingDynamicRegistrationSupported()));
        serverCapabilities.setDefinitionProvider(Boolean.valueOf(!clientCapabilities.isDefinitionDynamicRegistered()));
        serverCapabilities.setTypeDefinitionProvider(Boolean.valueOf(!clientCapabilities.isTypeDefinitionDynamicRegistered()));
        serverCapabilities.setReferencesProvider(Boolean.valueOf(!clientCapabilities.isReferencesDynamicRegistrationSupported()));
        serverCapabilities.setLinkedEditingRangeProvider(Boolean.valueOf(!clientCapabilities.isLinkedEditingRangeDynamicRegistered()));
        if (!clientCapabilities.isLinkDynamicRegistrationSupported()) {
            serverCapabilities.setDocumentLinkProvider(ServerCapabilitiesConstants.DEFAULT_LINK_OPTIONS);
        }
        if (!clientCapabilities.isCompletionDynamicRegistrationSupported()) {
            serverCapabilities.setCompletionProvider(ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS);
        }
        if (!clientCapabilities.isCodeLensDynamicRegistrationSupported()) {
            serverCapabilities.setCodeLensProvider(ServerCapabilitiesConstants.DEFAULT_CODELENS_OPTIONS);
        }
        return serverCapabilities;
    }
}

