/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.AttributeCompletionItem;
import org.eclipse.lemminx.services.extensions.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.ICompletionResponse;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentModelCompletionParticipant
extends CompletionParticipantAdapter {
    @Override
    public void onTagOpen(ICompletionRequest request, ICompletionResponse response) throws Exception {
        try {
            DOMDocument document = request.getXMLDocument();
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            DOMElement parentElement = request.getParentElement();
            if (parentElement == null) {
                Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(document, null);
                for (CMDocument cmDocument : cmDocuments) {
                    ContentModelCompletionParticipant.fillWithChildrenElementDeclaration(null, null, cmDocument.getElements(), null, false, request, response);
                }
                return;
            }
            Collection<CMDocument> cmRootDocuments = contentModelManager.findCMDocument(parentElement, parentElement.getNamespaceURI());
            String defaultPrefix = null;
            for (CMDocument cmDocument : cmRootDocuments) {
                CMElementDeclaration cmElement = cmDocument.findCMElement(parentElement, parentElement.getNamespaceURI());
                if (cmElement == null) continue;
                defaultPrefix = parentElement.getPrefix();
                ContentModelCompletionParticipant.fillWithPossibleElementDeclaration(parentElement, cmElement, defaultPrefix, contentModelManager, request, response);
            }
            if (parentElement.isDocumentElement()) {
                Collection<String> prefixes = parentElement.getAllPrefixes();
                for (String prefix : prefixes) {
                    String namespaceURI;
                    if (defaultPrefix != null && prefix.equals(defaultPrefix) || this.hasNamespace(namespaceURI = DOMElement.getNamespaceURI(prefix, parentElement), cmRootDocuments)) continue;
                    Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(parentElement, namespaceURI);
                    for (CMDocument cmDocument : cmDocuments) {
                        ContentModelCompletionParticipant.fillWithChildrenElementDeclaration(parentElement, null, cmDocument.getElements(), prefix, true, request, response);
                    }
                }
            }
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }

    private boolean hasNamespace(String namespaceURI, Collection<CMDocument> cmRootDocuments) {
        if (cmRootDocuments.isEmpty()) {
            return false;
        }
        for (CMDocument cmDocument : cmRootDocuments) {
            if (!cmDocument.hasNamespace(namespaceURI)) continue;
            return true;
        }
        return false;
    }

    private static void fillWithPossibleElementDeclaration(DOMElement parentElement, CMElementDeclaration cmElement, String defaultPrefix, ContentModelManager contentModelManager, ICompletionRequest request, ICompletionResponse response) throws BadLocationException {
        Collection<CMElementDeclaration> possibleElements = cmElement.getPossibleElements(parentElement, request.getOffset());
        boolean isAny = CMElementDeclaration.ANY_ELEMENT_DECLARATIONS.equals(possibleElements);
        Collection<CMDocument> cmDocuments = null;
        if (isAny) {
            cmDocuments = contentModelManager.findCMDocument(parentElement);
        }
        ContentModelCompletionParticipant.fillWithChildrenElementDeclaration(parentElement, cmDocuments, possibleElements, defaultPrefix, false, request, response);
    }

    private static void fillWithChildrenElementDeclaration(DOMElement element, Collection<CMDocument> cmDocuments, Collection<CMElementDeclaration> cmElements, String defaultPrefix, boolean forceUseOfPrefix, ICompletionRequest request, ICompletionResponse response) throws BadLocationException {
        XMLGenerator generator = request.getXMLGenerator();
        if (cmDocuments != null) {
            HashSet<String> tags = new HashSet<String>();
            HashSet<CMElementDeclaration> processedElements = new HashSet<CMElementDeclaration>();
            for (CMDocument cmDocument : cmDocuments) {
                Collection<CMElementDeclaration> elements = cmDocument.getElements();
                ContentModelCompletionParticipant.fillCompletionItem(elements, element, defaultPrefix, forceUseOfPrefix, request, response, generator, tags, processedElements);
            }
            DOMDocument document = element.getOwnerDocument();
            NodeList list = document.getChildNodes();
            ContentModelCompletionParticipant.addTagName(list, tags, request, response);
        } else {
            for (CMElementDeclaration child : cmElements) {
                ContentModelCompletionParticipant.addCompletionItem(child, element, defaultPrefix, forceUseOfPrefix, request, response, generator, null);
            }
        }
    }

    private static void fillCompletionItem(Collection<CMElementDeclaration> elements, DOMElement element, String defaultPrefix, boolean forceUseOfPrefix, ICompletionRequest request, ICompletionResponse response, XMLGenerator generator, Set<String> tags, Set<CMElementDeclaration> processedElements) {
        for (CMElementDeclaration child : elements) {
            if (processedElements.contains(child)) continue;
            processedElements.add(child);
            ContentModelCompletionParticipant.addCompletionItem(child, element, defaultPrefix, forceUseOfPrefix, request, response, generator, tags);
            ContentModelCompletionParticipant.fillCompletionItem(child.getElements(), element, defaultPrefix, forceUseOfPrefix, request, response, generator, tags, processedElements);
        }
    }

    private static void addTagName(NodeList list, Set<String> tags, ICompletionRequest request, ICompletionResponse response) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (1 != node.getNodeType()) continue;
            DOMElement elt = (DOMElement)node;
            String tagName = elt.getTagName();
            if (!StringUtils.isEmpty(tagName) && !tags.contains(tagName)) {
                CompletionItem item = new CompletionItem(tagName);
                item.setKind(CompletionItemKind.Property);
                item.setFilterText(request.getFilterForStartTagName(tagName));
                String xml = elt.getOwnerDocument().getText().substring(elt.getStart(), elt.getEnd());
                item.setTextEdit(new TextEdit(request.getReplaceRange(), xml));
                response.addCompletionItem(item);
                tags.add(item.getLabel());
            }
            ContentModelCompletionParticipant.addTagName(elt.getChildNodes(), tags, request, response);
        }
    }

    private static void addCompletionItem(CMElementDeclaration elementDeclaration, DOMElement parentElement, String defaultPrefix, boolean forceUseOfPrefix, ICompletionRequest request, ICompletionResponse response, XMLGenerator generator, Set<String> tags) {
        String prefix = forceUseOfPrefix ? defaultPrefix : (parentElement != null ? parentElement.getPrefix(elementDeclaration.getNamespace()) : null);
        String label = elementDeclaration.getName(prefix);
        if (tags != null) {
            if (tags.contains(label)) {
                return;
            }
            tags.add(label);
        }
        CompletionItem item = new CompletionItem(label);
        item.setFilterText(request.getFilterForStartTagName(label));
        item.setKind(CompletionItemKind.Property);
        MarkupContent documentation = XMLGenerator.createMarkupContent(elementDeclaration, request);
        item.setDocumentation(documentation);
        String xml = generator.generate(elementDeclaration, prefix, ContentModelCompletionParticipant.isGenerateEndTag(request.getNode(), request.getOffset(), label));
        item.setTextEdit(new TextEdit(request.getReplaceRange(), xml));
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        response.addCompletionItem(item, true);
    }

    private static boolean isGenerateEndTag(DOMNode node, int offset, String tagName) {
        if (node == null) {
            return true;
        }
        return node.getOrphanEndElement(offset, tagName) == null;
    }

    @Override
    public void onAttributeName(boolean generateValue, ICompletionRequest request, ICompletionResponse response) throws Exception {
        DOMElement parentElement;
        DOMElement dOMElement = parentElement = request.getNode().isElement() ? (DOMElement)request.getNode() : null;
        if (parentElement == null) {
            return;
        }
        try {
            Range fullRange = request.getReplaceRange();
            boolean canSupportSnippet = request.isCompletionSnippetsSupported();
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(parentElement);
            for (CMDocument cmDocument : cmDocuments) {
                CMElementDeclaration cmElement = cmDocument.findCMElement(parentElement, parentElement.getNamespaceURI());
                if (cmElement == null) continue;
                this.fillAttributesWithCMAttributeDeclarations(parentElement, fullRange, cmElement, canSupportSnippet, generateValue, request, response);
            }
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }

    private void fillAttributesWithCMAttributeDeclarations(DOMElement parentElement, Range fullRange, CMElementDeclaration cmElement, boolean canSupportSnippet, boolean generateValue, ICompletionRequest request, ICompletionResponse response) {
        Collection<CMAttributeDeclaration> attributes = cmElement.getAttributes();
        if (attributes == null) {
            return;
        }
        for (CMAttributeDeclaration cmAttribute : attributes) {
            String attrName = cmAttribute.getName();
            if (parentElement.hasAttribute(attrName)) continue;
            AttributeCompletionItem item = new AttributeCompletionItem(attrName, canSupportSnippet, fullRange, generateValue, cmAttribute.getDefaultValue(), cmAttribute.getEnumerationValues(), request.getSharedSettings());
            MarkupContent documentation = XMLGenerator.createMarkupContent(cmAttribute, cmElement, (ISharedSettingsRequest)request);
            item.setDocumentation(documentation);
            response.addCompletionAttribute(item);
        }
    }

    @Override
    public void onAttributeValue(String valuePrefix, ICompletionRequest request, ICompletionResponse response) throws Exception {
        DOMElement parentElement;
        DOMElement dOMElement = parentElement = request.getNode().isElement() ? (DOMElement)request.getNode() : null;
        if (parentElement == null) {
            return;
        }
        try {
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(parentElement);
            for (CMDocument cmDocument : cmDocuments) {
                CMElementDeclaration cmElement = cmDocument.findCMElement(parentElement, parentElement.getNamespaceURI());
                if (cmElement == null) continue;
                this.fillAttributeValuesWithCMAttributeDeclarations(cmElement, request, response);
            }
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }

    private void fillAttributeValuesWithCMAttributeDeclarations(CMElementDeclaration cmElement, ICompletionRequest request, ICompletionResponse response) {
        String attributeName = request.getCurrentAttributeName();
        CMAttributeDeclaration cmAttribute = cmElement.findCMAttribute(attributeName);
        if (cmAttribute != null) {
            Range fullRange = request.getReplaceRange();
            cmAttribute.getEnumerationValues().forEach(value -> {
                CompletionItem item = new CompletionItem();
                item.setLabel(value);
                String insertText = request.getInsertAttrValue((String)value);
                item.setLabel(value);
                item.setKind(CompletionItemKind.Value);
                item.setFilterText(insertText);
                item.setTextEdit(new TextEdit(fullRange, insertText));
                MarkupContent documentation = XMLGenerator.createMarkupContent(cmAttribute, value, cmElement, request);
                item.setDocumentation(documentation);
                response.addCompletionItem(item);
            });
        }
    }

    @Override
    public void onXMLContent(ICompletionRequest request, ICompletionResponse response) throws Exception {
        try {
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            DOMElement parentElement = request.getParentElement();
            if (parentElement != null) {
                Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(parentElement);
                for (CMDocument cmDocument : cmDocuments) {
                    CMElementDeclaration cmElement = cmDocument.findCMElement(parentElement, parentElement.getNamespaceURI());
                    Collection<Object> values = cmElement != null ? cmElement.getEnumerationValues() : Collections.emptyList();
                    if (values.isEmpty()) continue;
                    DOMDocument document = parentElement.getOwnerDocument();
                    int startOffset = parentElement.getStartTagCloseOffset() + 1;
                    Position start = parentElement.getOwnerDocument().positionAt(startOffset);
                    Position end = request.getPosition();
                    int endOffset = parentElement.getEndTagOpenOffset();
                    if (endOffset > 0) {
                        end = document.positionAt(endOffset);
                    }
                    int completionOffset = request.getOffset();
                    String tokenStart = StringUtils.getWhitespaces(document.getText(), startOffset, completionOffset);
                    Range fullRange = new Range(start, end);
                    values.forEach(value -> {
                        CompletionItem item = new CompletionItem();
                        item.setLabel(value);
                        String insertText = value;
                        item.setLabel(value);
                        item.setKind(CompletionItemKind.Value);
                        item.setFilterText(tokenStart + insertText);
                        item.setTextEdit(new TextEdit(fullRange, insertText));
                        MarkupContent documentation = XMLGenerator.createMarkupContent(cmElement, value, (ISharedSettingsRequest)request);
                        item.setDocumentation(documentation);
                        response.addCompletionItem(item);
                    });
                }
            }
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }
}

